/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.coreservice.client.listener.ActionListener;
import com.ainirobot.coreservice.client.messagedispatcher.IMsgHandle;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;

class ActionMessage
implements IMsgHandle,
IRecyclable {
    private static final String TAG = ActionMessage.class.getSimpleName();
    private static RecyclablePool<ActionMessage> sPool = new RecyclablePool();
    MsgType msgType;
    String msgStr;
    String extraData;
    ActionListener msgListener;
    int msgCode;

    @Override
    public void handleMessage() {
        try {
            Log.d((String)TAG, (String)("msgType : " + (Object)((Object)this.msgType)));
            switch (this.msgType) {
                case result: {
                    this.msgListener.onResult(this.msgCode, this.msgStr, this.extraData);
                    this.msgListener.onResult(this.msgCode, this.msgStr);
                    break;
                }
                case error: {
                    this.msgListener.onError(this.msgCode, this.msgStr, this.extraData);
                    this.msgListener.onError(this.msgCode, this.msgStr);
                    break;
                }
                case status: {
                    this.msgListener.onStatusUpdate(this.msgCode, this.msgStr, this.extraData);
                    this.msgListener.onStatusUpdate(this.msgCode, this.msgStr);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        sPool.recycle(this);
    }

    @Override
    public void recycle() {
        Log.d((String)TAG, (String)("recycle : " + this.msgStr + ","));
        this.msgStr = null;
        this.extraData = null;
        this.msgListener = null;
    }

    private ActionMessage(ActionListener msgListener, MsgType msgType, String msgStr, int msgCode, String extraData) {
        this.msgCode = msgCode;
        this.msgStr = msgStr;
        this.extraData = extraData;
        this.msgType = msgType;
        this.msgListener = msgListener;
    }

    static ActionMessage obtain(ActionListener msgListener, MsgType msgType, String msgStr, int msgCode, String extraData) {
        ActionMessage actionMessage = sPool.obtain();
        if (actionMessage == null) {
            actionMessage = new ActionMessage(msgListener, msgType, msgStr, msgCode, extraData);
        } else {
            actionMessage.msgType = msgType;
            actionMessage.msgStr = msgStr;
            actionMessage.msgCode = msgCode;
            actionMessage.extraData = extraData;
            actionMessage.msgListener = msgListener;
        }
        return actionMessage;
    }

    static enum MsgType {
        result,
        error,
        status;

    }
}

