/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.coreservice.client.listener.ActionListener;
import com.ainirobot.coreservice.client.messagedispatcher.ActionMessage;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.listener.IActionListener;

class ActionDispatcher
extends IActionListener.Stub
implements IRecyclable {
    private static final String TAG = ActionDispatcher.class.getSimpleName();
    private static RecyclablePool<ActionDispatcher> sPool = new RecyclablePool();
    private DispatchHandler mDispatchHandler;
    private ActionListener mListener;

    private ActionDispatcher(DispatchHandler dispatchHandler, ActionListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    static ActionDispatcher obtain(DispatchHandler dispatchHandler, ActionListener listener) {
        ActionDispatcher actionDispatcher = sPool.obtain();
        if (actionDispatcher == null) {
            actionDispatcher = new ActionDispatcher(dispatchHandler, listener);
        } else {
            actionDispatcher.mDispatchHandler = dispatchHandler;
            actionDispatcher.mListener = listener;
        }
        return actionDispatcher;
    }

    @Override
    public void onResult(int status, String responseString) throws RemoteException {
    }

    @Override
    public void onError(int errorCode, String errorString) throws RemoteException {
    }

    @Override
    public void onStatusUpdate(int status, String data) throws RemoteException {
    }

    @Override
    public void onResultWithExtraData(int status, String responseString, String extraData) throws RemoteException {
        DispatchHandler dispatchHandler = this.mDispatchHandler;
        ActionListener listener = this.mListener;
        Log.d((String)"DISPATCHER_TAG", (String)("onResultWithExtraData responseString : " + responseString + ", extraData : " + extraData));
        if (dispatchHandler != null && listener != null) {
            ActionMessage actionMessage = ActionMessage.obtain(listener, ActionMessage.MsgType.result, responseString, status, extraData);
            dispatchHandler.sendMessage(dispatchHandler.obtainMessage(1, actionMessage));
            sPool.recycle(this);
        } else {
            Log.e((String)TAG, (String)("onResult status = " + status + "; data = " + responseString));
        }
    }

    @Override
    public void onErrorWithExtraData(int errorCode, String errorString, String extraData) throws RemoteException {
        DispatchHandler dispatchHandler = this.mDispatchHandler;
        ActionListener listener = this.mListener;
        if (dispatchHandler != null && listener != null) {
            ActionMessage actionMessage = ActionMessage.obtain(listener, ActionMessage.MsgType.error, errorString, errorCode, extraData);
            dispatchHandler.sendMessage(dispatchHandler.obtainMessage(1, actionMessage));
            sPool.recycle(this);
        } else {
            Log.e((String)TAG, (String)("onError status = " + errorCode + "; data = " + errorString));
        }
    }

    @Override
    public void onStatusUpdateWithExtraData(int status, String data, String extraData) throws RemoteException {
        DispatchHandler dispatchHandler = this.mDispatchHandler;
        ActionListener listener = this.mListener;
        if (dispatchHandler != null && listener != null) {
            ActionMessage actionMessage = ActionMessage.obtain(listener, ActionMessage.MsgType.status, data, status, extraData);
            dispatchHandler.sendMessage(dispatchHandler.obtainMessage(1, actionMessage));
        } else {
            Log.e((String)TAG, (String)("onStatusUpdate status = " + status + "; data = " + data));
        }
    }

    @Override
    public void recycle() {
        this.mDispatchHandler = null;
        this.mListener = null;
    }
}

