/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.log;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.client.receiver.LogBroadcastReceiver;
import java.util.concurrent.ConcurrentHashMap;

public final class RLog {
    private static final int LEVEL_V = 1;
    private static final int LEVEL_I = 2;
    private static final int LEVEL_D = 4;
    private static ConcurrentHashMap<String, LogInfo> mPruneLog = new ConcurrentHashMap();
    private static int mLevel = 6;
    private static int mLevelValue = 2;

    public static void initRLog(Context context) {
        RLog.receiver(context);
    }

    private static void receiver(Context context) {
        LogBroadcastReceiver receiver = new LogBroadcastReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.ainirobot.coreservice.client.LogBroadcastReceiver");
        context.registerReceiver((BroadcastReceiver)receiver, filter);
    }

    public static synchronized void pruneLog(String tag, String msg, long period) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        if (mPruneLog.containsKey(tag)) {
            LogInfo log = mPruneLog.get(tag);
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime - log.getPreTime() > period) {
                RLog.i(tag, msg + "   ++++++ expire count: " + log.getCount());
                log.setPreTime(currentTime);
                log.setCount(0L);
            } else {
                log.setCount(log.getCount() + 1L);
            }
        } else {
            LogInfo log = new LogInfo();
            log.setCount(0L);
            log.setPreTime(SystemClock.currentThreadTimeMillis());
            RLog.i(tag, msg + "   ++++++ expire count: " + log.getCount());
            mPruneLog.put(tag, log);
        }
    }

    public static boolean setLogLevel(int level) {
        Log.i((String)"RLog", (String)(" set log level: " + level));
        switch (level) {
            case 1: {
                mLevel = 7;
                return true;
            }
            case 2: {
                mLevel = 6;
                return true;
            }
            case 3: {
                mLevel = 4;
                return true;
            }
        }
        return false;
    }

    public static void v(String tag, String msg) {
        if ((mLevel & 1) == 1) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void i(String tag, String msg) {
        if ((mLevel & 2) == 2) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg) {
        if ((mLevel & 4) == 4) {
            Log.d((String)tag, (String)msg);
        }
    }

    private static class LogInfo {
        private long preTime;
        private long count;

        private LogInfo() {
        }

        public long getPreTime() {
            return this.preTime;
        }

        public void setPreTime(long preTime) {
            this.preTime = preTime;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }
}

