/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.input;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.ainirobot.coreservice.IOtaRegistry;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.client.BaseApi;
import com.ainirobot.coreservice.client.IntentUtil;
import com.ainirobot.coreservice.client.StatusListener;
import com.ainirobot.coreservice.client.input.OtaCallback;
import com.ainirobot.coreservice.client.messagedispatcher.StatusDispatcher;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingApi;
import com.ainirobot.coreservice.config.ServiceConfig;
import java.util.ArrayList;
import java.util.List;

public class OtaApi
extends BaseApi {
    private IOtaRegistry mOtaRegistry;
    private static OtaApi mOtaApi = new OtaApi();
    private ServiceConnection apiConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            OtaApi.this.mRobotBinderPool = IRobotBinderPool.Stub.asInterface(service);
            try {
                OtaApi.this.mOtaRegistry = IOtaRegistry.Stub.asInterface(OtaApi.this.mRobotBinderPool.queryBinder(9, OtaApi.this.ctx.getPackageName()));
                OtaApi.this.notifyEventApiConnected();
            }
            catch (RemoteException | NullPointerException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            OtaApi.this.notifyEventApiDisconnected();
            OtaApi.this.mOtaRegistry = null;
        }
    };

    private OtaApi() {
        this.mSubApiList.add(RobotSettingApi.getInstance());
    }

    public static OtaApi getInstance() {
        if (mOtaApi == null) {
            mOtaApi = new OtaApi();
        }
        return mOtaApi;
    }

    public void connectApi(Context context) {
        this.ctx = context;
        Intent intent = IntentUtil.createExplicitIntent("com.ainirobot.coreservice.service.CoreService", IRobotBinderPool.class.getName());
        context.bindService(intent, this.apiConnection, 1);
    }

    @Override
    public void disconnectApi() {
        try {
            this.ctx.unbindService(this.apiConnection);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void registerCallBack(OtaCallback callback) {
        try {
            this.mOtaRegistry.registerCallback(callback);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String registerStatusListener(String type, StatusListener listener) {
        try {
            if (listener == null) {
                return null;
            }
            StatusDispatcher statusListener = this.mMessageDispatcher.obtainStatusDispatcher(listener);
            String id = this.mOtaRegistry.registerStatusListener(type, statusListener);
            statusListener.register(id);
            return id;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean unregisterStatusListener(StatusListener listener) {
        try {
            if (listener == null) {
                return false;
            }
            this.mMessageDispatcher.unregisterStatusDispatcher(listener.getId());
            return this.mOtaRegistry.unregisterStatusListener(listener.getId());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int sendOtaEvent(boolean isForceUpdate, String params) {
        try {
            return this.mOtaRegistry.sendOtaRequest(isForceUpdate ? "req_ota_upgrade_force" : "req_ota_upgrade", params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int finishOtaUpgrade(String params) {
        try {
            return this.mOtaRegistry.sendOtaRequest("req_ota_finish", params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void updateProgress(String params) {
        try {
            this.mOtaRegistry.updateProgress(params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int startDownloadFullPack(String params) {
        try {
            return this.mOtaRegistry.sendOtaRequest("req_ota_download", params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getNavigationVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_navi_get_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startNavigationUpdate(String params) {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_navi_start_update", params, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getNavigationUpdateParams() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_navi_get_update_params", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getHeadVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_head_get_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startHeadScp(String params) {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_head_start_scp", params, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getOtaHeadVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_head_ota_get_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startHeadUpdate(String params) {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_head_start_update", params, true);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getHeadUpdateParams() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_head_get_update_params", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startCanUpdate(String params) {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_ota_start", params, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanOtaState() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_ota_get_state", null, true);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanBoardVersion(String params) {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_board_version", params, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanMotorHorizontalVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_motor_h_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanMotorVerticalVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_motor_v_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanPsbVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_psb_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanPsbSVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_psb_s_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanAutoChargeVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_auto_charge_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCanBatteryVersion() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_can_get_battery_version", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int isHeadConnected() {
        try {
            return this.mOtaRegistry.sendOtaCommand("cmd_head_is_header_connected", null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<ServiceConfig> getConfig() {
        try {
            return this.mOtaRegistry.getConfig();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new ArrayList<ServiceConfig>();
        }
    }
}

