/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.input;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.coreservice.IDumpRegistry;
import com.ainirobot.coreservice.IHWService;
import com.ainirobot.coreservice.client.BaseApi;
import com.ainirobot.coreservice.client.IntentUtil;

public class DumpApi
extends BaseApi {
    private static final String TAG = DumpApi.class.getSimpleName();
    private IDumpRegistry mDumpRegistry;
    protected ServiceConnection apiConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            DumpApi.this.mDumpRegistry = IDumpRegistry.Stub.asInterface(service);
            DumpApi.this.mIsServiceConnected = true;
            DumpApi.this.notifyEventApiConnected();
        }

        public void onServiceDisconnected(ComponentName className) {
            DumpApi.this.mIsServiceConnected = false;
            DumpApi.this.notifyEventApiDisconnected();
            DumpApi.this.mDumpRegistry = null;
        }
    };

    public DumpApi(Context ctx) {
        super(ctx);
    }

    @Override
    public void connectApi() {
        Intent intent = IntentUtil.createExplicitIntent("com.ainirobot.coreservice.service.CoreService", IDumpRegistry.class.getName());
        intent.putExtra("packageName", this.ctx.getPackageName());
        this.ctx.bindService(intent, this.apiConnection, 1);
    }

    @Override
    public void disconnectApi() {
        try {
            this.ctx.unbindService(this.apiConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void registerHWService(String serviceName, IHWService HWService2) {
        try {
            this.mDumpRegistry.registerHWCallback(serviceName, HWService2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private boolean isConnected() {
        return this.mDumpRegistry != null && this.mDumpRegistry.asBinder().pingBinder();
    }

    public void sendAsyncResponse(String cmdType, int result, String message) {
        try {
            this.mDumpRegistry.sendAsyncResponse(cmdType, result, message);
        }
        catch (RemoteException e) {
            Log.d((String)TAG, (String)("Send async response failed : " + cmdType + "  " + message));
            e.printStackTrace();
        }
    }

    public void sendAysncStatus(String cmdType, String status) {
        try {
            this.mDumpRegistry.sendAsyncStatus(cmdType, status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void sendStatusReport(String serviceName, String type, String params) {
        try {
            this.mDumpRegistry.sendStatusReport(serviceName, type, params);
        }
        catch (RemoteException e) {
            Log.d((String)TAG, (String)("Send status report failed : " + type + "  " + params));
            e.printStackTrace();
        }
    }

    public void sendExceptionReport(String serviceName, String type, String params) {
        try {
            this.mDumpRegistry.sendExceptionReport(serviceName, type, params);
        }
        catch (RemoteException e) {
            Log.d((String)TAG, (String)("Send exception report failed : " + type + "  " + params));
            e.printStackTrace();
        }
    }
}

