/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.hardware;

import android.os.Binder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.IHWService;
import com.ainirobot.coreservice.IInspectCallBack;
import com.ainirobot.coreservice.bean.Command;
import com.ainirobot.coreservice.client.exception.BinderExceptionHandler;
import com.ainirobot.coreservice.config.ServiceConfig;
import java.util.List;

public abstract class HWService
extends IHWService.Stub {
    private final String TAG = this.getClass().getSimpleName();
    private ServiceConfig config;
    private List<Command> commands;
    private volatile boolean isMounted = false;

    @Override
    public int getHWStatus() throws RemoteException {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Command> mount(String serviceName, ServiceConfig config) throws RemoteException {
        if (this.isMounted) {
            return this.commands;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.config = config;
            this.commands = this.onMount(serviceName, config);
            this.isMounted = true;
        }
        catch (Exception e) {
            BinderExceptionHandler.handle(e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startInspect(IInspectCallBack callback) throws RemoteException {
        long identity = Binder.clearCallingIdentity();
        try {
            if (!this.isEnable()) {
                Log.d((String)this.TAG, (String)"Service is disabled : start inspect");
                return;
            }
            this.onInspectStart(callback);
        }
        catch (Exception e) {
            BinderExceptionHandler.handle(e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset() throws RemoteException {
        long identity = Binder.clearCallingIdentity();
        try {
            if (!this.isEnable()) {
                Log.d((String)this.TAG, (String)"Service is disabled : reset");
                return;
            }
            this.onReset();
        }
        catch (Exception e) {
            BinderExceptionHandler.handle(e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startUpgrade(String subsystem, String params) throws RemoteException {
        long identity = Binder.clearCallingIdentity();
        try {
            this.onUpgrade(subsystem, params);
        }
        catch (Exception e) {
            BinderExceptionHandler.handle(e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String exeSyncCommand(String cmdType, String params, String language) throws RemoteException {
        long identity = Binder.clearCallingIdentity();
        try {
            if (!this.isEnable()) {
                Log.d((String)this.TAG, (String)("Service is disabled : " + cmdType + "  " + params));
                String string = null;
                return string;
            }
            Log.d((String)this.TAG, (String)("Exe sync command : " + cmdType + "  " + params));
            String string = this.onSyncCommand(cmdType, params, language);
            return string;
        }
        catch (Exception e) {
            BinderExceptionHandler.handle(e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void exeAsyncCommand(String cmdType, String params, String language) throws RemoteException {
        long identity = Binder.clearCallingIdentity();
        try {
            if (!this.isEnable()) {
                Log.d((String)this.TAG, (String)("Service is disabled : " + cmdType + "  " + params));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)cmdType)) {
                Log.d((String)this.TAG, (String)"Invalid  command type");
                return;
            }
            Log.d((String)this.TAG, (String)("Exe async command : " + cmdType + "  " + params));
            this.onAsyncCommand(cmdType, params, language);
        }
        catch (Exception e) {
            BinderExceptionHandler.handle(e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    private boolean isEnable() {
        return this.config == null || this.config.isEnable();
    }

    @Override
    public boolean startStatusSocket(String type, int socketPort) throws RemoteException {
        return false;
    }

    @Override
    public boolean closeStatusSocket(String type, int socketPort) throws RemoteException {
        return false;
    }

    public abstract List<Command> onMount(String var1, ServiceConfig var2);

    public abstract void onInspectStart(IInspectCallBack var1);

    public abstract boolean onUpgrade(String var1, String var2);

    public abstract void onReset();

    public abstract void onAsyncCommand(String var1, String var2, String var3);

    public abstract String onSyncCommand(String var1, String var2, String var3);

    @Override
    public abstract String getBoardName() throws RemoteException;

    @Override
    public abstract boolean isNeedUpgrade(String var1, String var2) throws RemoteException;

    @Override
    public abstract String getVersion(String var1) throws RemoteException;

    @Override
    public void switchAppControl(String packageName, String lastPackageName) {
    }

    @Override
    public void setLanguage(String language) {
    }
}

