/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.firstconfig;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.IFirstConfigRegistry;
import com.ainirobot.coreservice.IStatusListener;
import com.ainirobot.coreservice.client.BaseApi;
import com.ainirobot.coreservice.client.IntentUtil;
import com.ainirobot.coreservice.client.actionbean.AutoChargeBean;
import com.ainirobot.coreservice.client.actionbean.CommandBean;
import com.ainirobot.coreservice.client.actionbean.InspectActionBean;
import com.ainirobot.coreservice.client.listener.ActionListener;
import com.ainirobot.coreservice.client.listener.CommandListener;
import com.ainirobot.coreservice.client.messagedispatcher.ActionDispatcher;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class FirstConfigApi
extends BaseApi {
    private IFirstConfigRegistry firstConfigRegistry;
    private volatile boolean mIsServiceConnected = false;
    private static Gson mGson = new Gson();
    protected ServiceConnection apiConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d((String)"FC_core", (String)"FCApi onServiceConnected");
            FirstConfigApi.this.firstConfigRegistry = IFirstConfigRegistry.Stub.asInterface(service);
            FirstConfigApi.this.mIsServiceConnected = true;
            FirstConfigApi.this.notifyEventApiConnected();
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.d((String)"FC_core", (String)"FCApi onServiceDisconnected");
            FirstConfigApi.this.mIsServiceConnected = false;
            FirstConfigApi.this.notifyEventApiDisconnected();
            FirstConfigApi.this.firstConfigRegistry = null;
        }
    };

    private FirstConfigApi() {
    }

    public static FirstConfigApi getInstance() {
        return InstanceHolder.instance;
    }

    public void connectApi(Context context) {
        Intent intent = IntentUtil.createExplicitIntent("com.ainirobot.coreservice.service.CoreService", IFirstConfigRegistry.class.getName());
        context.bindService(intent, this.apiConnection, 0);
    }

    public void disconnectApi(Context context) {
        try {
            context.unbindService(this.apiConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public int sendFirstConfigRequest(String type, String params) {
        try {
            Log.d((String)"FC_core", (String)("sendFirstConfigRequest type = " + type + ", param = " + params));
            return this.firstConfigRegistry.sendFirstConfigRequest(type, params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int sendFirstConfigCommand(String cmdAction, String cmdParam) {
        try {
            return this.firstConfigRegistry.sendFirstConfigCommand(cmdAction, cmdParam);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String registerStatusListener(String type, IStatusListener listener) {
        try {
            return this.firstConfigRegistry.registerStatusListener(type, listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean unregisterStatusListener(String id) {
        try {
            return this.firstConfigRegistry.unregisterStatusListener(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isServiceConnected() {
        return this.mIsServiceConnected;
    }

    public int startInspection(int reqId, ActionListener listener) {
        return this.startInspection(reqId, 30000L, listener);
    }

    public int startInspection(int reqId, long time, ActionListener listener) {
        Log.d((String)"FC_core", (String)("========== startInspection timeout = " + time + " =================="));
        InspectActionBean bean = new InspectActionBean();
        bean.setReqId(reqId);
        bean.setTimeOut(time);
        String jsonStr = mGson.toJson((Object)bean);
        try {
            ActionDispatcher actionListener = null;
            if (listener != null) {
                actionListener = this.mMessageDispatcher.obtainActionDispatcher(listener);
            }
            return this.firstConfigRegistry.startAction(reqId, 20, jsonStr, actionListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -101;
        }
    }

    public int remoteRequestQrcode(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_qrcode", null, false);
        Log.d((String)"FC_core", (String)("FCApi remoteRequestQrcode reqId = " + reqId));
        return this.startAction(reqId, 177, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteBindStatus(int reqId, CommandListener listener) {
        JsonObject obj = new JsonObject();
        CommandBean bean = new CommandBean("cmd_remote_bind_status", obj.toString(), false);
        Log.d((String)"FC_core", (String)("FCApi remoteBindStatus\u3000reqId = " + reqId));
        return this.startAction(reqId, 183, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPosition(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_position", null, false);
        return this.startAction(reqId, 171, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int motionLine(int reqId, String direction, float speed, float distance, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("direction", (Object)direction);
            param.put("distance", (double)distance);
            param.put("linear_speed", (double)speed);
            CommandBean bean = new CommandBean();
            bean.setContinue(false);
            bean.setParams(param.toString());
            bean.setCmdType("cmd_navi_move_direction");
            String params = mGson.toJson((Object)bean);
            ActionListener al = this.parseCommand(listener);
            return this.startAction(reqId, 110, params, al);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int switchChargeMode(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_switch_auto_charge_mode", null, false);
        return this.startAction(reqId, 175, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int startAutoCharge(int reqId, CommandListener listener) {
        Log.d((String)"FC_core", (String)("startAutoCharge reqId = " + reqId));
        CommandBean bean = new CommandBean("cmd_can_auto_charge_start", null, false);
        return this.startAction(reqId, 172, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopAutoCharge(int reqId) {
        CommandBean bean = new CommandBean("cmd_can_auto_charge_end", null, false);
        return this.startAction(reqId, 173, mGson.toJson((Object)bean), null);
    }

    public int getChargeStatus(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_charge_status", null, false);
        return this.startAction(reqId, 174, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setStartChargePoseAction(int reqId, long timeout, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 22, toJson, listener);
    }

    public int startNaviToAutoCharge(int reqId, long timeout, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 21, toJson, listener);
    }

    public int remoteChargePile(int reqId, String status, String msg, boolean result, CommandListener listener) {
        try {
            Log.d((String)"FC_core", (String)("remoteChargePile msg : " + msg));
            JsonObject value = new JsonObject();
            value.addProperty("status", status);
            value.addProperty("name", "\u56de\u5145\u70b9");
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                JsonElement msgJson = new JsonParser().parse(msg);
                if (msgJson != null && msgJson.isJsonObject()) {
                    value.add("position", msgJson);
                } else {
                    value.addProperty("msg", msg);
                }
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "set_charging_pile");
            obj.add("value", (JsonElement)value);
            obj.addProperty("result", Boolean.valueOf(result));
            CommandBean bean = new CommandBean("cmd_remote_charge_pile", mGson.toJson((JsonElement)obj), false);
            Log.d((String)"FC_core", (String)("FCApi remoteChargePile\u3000reqId = " + reqId));
            return this.startAction(reqId, 202, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Throwable e) {
            Log.e((String)"FC_core", (String)("FCApi remoteChargePile e : " + e.getLocalizedMessage()));
            return 0;
        }
    }

    public int remoteFirstCharge(int reqId, String status, boolean result, CommandListener listener) {
        try {
            JsonObject value = new JsonObject();
            value.addProperty("status", status);
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "first_recharging");
            obj.add("value", (JsonElement)value);
            obj.addProperty("result", Boolean.valueOf(result));
            CommandBean bean = new CommandBean("cmd_remote_first_charging", mGson.toJson((JsonElement)obj), false);
            Log.d((String)"FC_core", (String)("FCApi remoteFirstCharge\u3000reqId = " + reqId));
            return this.startAction(reqId, 201, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Throwable e) {
            Log.e((String)"FC_core", (String)("remoteFirstCharge e : " + e.getLocalizedMessage()));
            return 0;
        }
    }

    public int getPlace(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_place_name", param, false);
        return this.startAction(reqId, 128, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int isRobotEstimate(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_is_estimate", "", false);
        return this.startAction(reqId, 133, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    private int startAction(int reqId, int actionId, String params, ActionListener listener) {
        try {
            ActionDispatcher actionListener = null;
            if (listener != null) {
                actionListener = this.mMessageDispatcher.obtainActionDispatcher(listener);
            }
            return this.firstConfigRegistry.startAction(reqId, actionId, params, actionListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private ActionListener parseCommand(final CommandListener listener) {
        if (listener == null) {
            return null;
        }
        ActionListener al = new ActionListener(){

            @Override
            public void onResult(int status, String responseString) throws RemoteException {
                listener.onResult(status, responseString);
                listener.onResult(status, responseString, "");
            }
        };
        return al;
    }

    public int postSetPlaceToServer(int reqId, String params) {
        CommandBean bean = new CommandBean("cmd_remote_post_set_place", params, false);
        return this.startAction(reqId, 206, mGson.toJson((Object)bean), null);
    }

    private static class InstanceHolder {
        private static final FirstConfigApi instance = new FirstConfigApi();

        private InstanceHolder() {
        }
    }
}

