/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.ashmem;

import android.support.annotation.NonNull;
import android.util.Log;
import com.ainirobot.coreservice.client.ashmem.BaseShareMemBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TopIRImageBean
extends BaseShareMemBean {
    private long timeStamp;
    private int type_size;
    private int width;
    private int height;
    private int stride;
    private int imageDataLength;
    private byte[] imageData;

    public TopIRImageBean() {
        this.type = BaseShareMemBean.ShareDataType.TOPIR_IMG.getType();
    }

    public TopIRImageBean(long timeStamp, int type_size, int width, int height, int stride, int imageDataLength, byte[] imageData) {
        this.type = BaseShareMemBean.ShareDataType.TOPIR_IMG.getType();
        this.timeStamp = timeStamp;
        this.type_size = type_size;
        this.width = width;
        this.height = height;
        this.stride = stride;
        this.imageDataLength = imageDataLength;
        this.imageData = imageData;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getType_size() {
        return this.type_size;
    }

    public void setType_size(int type_size) {
        this.type_size = type_size;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getStride() {
        return this.stride;
    }

    public void setStride(int stride) {
        this.stride = stride;
    }

    public int getImageDataLength() {
        return this.imageDataLength;
    }

    public void setImageDataLength(int imageDataLength) {
        this.imageDataLength = imageDataLength;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        Log.d((String)"TopIRImageBean", (String)("beanToStream: bean=" + this.toString()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(this.type);
            dos.writeLong(this.timeStamp);
            dos.writeInt(this.type_size);
            dos.writeInt(this.width);
            dos.writeInt(this.height);
            dos.writeInt(this.stride);
            dos.writeInt(this.imageDataLength);
            dos.write(this.imageData);
            Log.d((String)"TopIRImageBean", (String)("toBytes imageData length=" + this.imageData.length));
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"TopIRImageBean", (String)("beanToStream:e: " + e.getMessage()));
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.close(dos);
            this.close(bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopIRImageBean arrayToBean(byte[] stream) {
        if (stream == null || stream.length <= 0) {
            return null;
        }
        Log.d((String)"TopIRImageBean", (String)("streamToBean: stream length=" + stream.length));
        ByteArrayInputStream bis = new ByteArrayInputStream(stream);
        DataInputStream dis = new DataInputStream(bis);
        try {
            this.setType(dis.readInt());
            this.setTimeStamp(dis.readLong());
            this.setType_size(dis.readInt());
            this.setWidth(dis.readInt());
            this.setHeight(dis.readInt());
            this.setStride(dis.readInt());
            int imageDataLength = dis.readInt();
            this.setImageDataLength(imageDataLength);
            if (imageDataLength > 0) {
                byte[] buffer = new byte[imageDataLength];
                dis.read(buffer);
                this.setImageData(buffer);
            }
            Log.d((String)"TopIRImageBean", (String)("streamToBean: result=" + this.toString()));
            TopIRImageBean topIRImageBean = this;
            return topIRImageBean;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"TopIRImageBean", (String)("streamToBean:e: " + e.getMessage()));
            TopIRImageBean topIRImageBean = null;
            return topIRImageBean;
        }
        finally {
            this.close(dis);
            this.close(bis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopIRImageBean streamToBean(@NonNull InputStream stream) {
        DataInputStream dis = new DataInputStream(stream);
        try {
            this.setType(dis.readInt());
            this.setTimeStamp(dis.readLong());
            this.setType_size(dis.readInt());
            this.setWidth(dis.readInt());
            this.setHeight(dis.readInt());
            this.setStride(dis.readInt());
            int imageDataLength = dis.readInt();
            this.setImageDataLength(imageDataLength);
            if (imageDataLength > 0) {
                byte[] buffer = new byte[imageDataLength];
                dis.read(buffer);
                this.setImageData(buffer);
            }
            Log.d((String)"TopIRImageBean", (String)("streamToBean: result=" + this.toString()));
            TopIRImageBean topIRImageBean = this;
            return topIRImageBean;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"TopIRImageBean", (String)("streamToBean:e: " + e.getMessage()));
            TopIRImageBean topIRImageBean = null;
            return topIRImageBean;
        }
        finally {
            this.close(dis);
            this.close(stream);
        }
    }

    public String toString() {
        return "TopIRImageBean{type=" + this.type + "timeStamp=" + this.timeStamp + "type_size=" + this.type_size + ", width=" + this.width + ", width=" + this.height + ", stride=" + this.stride + ", imageDataLength=" + this.imageDataLength + ", imageData=" + Arrays.toString(this.imageData) + '}';
    }

    public void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

