/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.ashmem;

import android.content.Context;
import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.IShareMemoryApi;
import com.ainirobot.coreservice.IShareMemoryCallback;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.utils.DelayTask;
import com.ainirobot.coreservice.utils.ResUtils;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;

public class ShareMemoryApi
extends BaseSubApi {
    private static final String TAG = ShareMemoryApi.class.getSimpleName();
    private static final String MEMORY_FILE_NAME = "Robot_Share_Memory";
    private static ShareMemoryApi instance;
    private volatile IShareMemoryApi iShareMemoryInterface;
    private Context mContext = null;

    public ShareMemoryApi() {
        Log.i((String)TAG, (String)"ShareMemoryApi create");
        this.startNewThread(TAG);
    }

    public static synchronized ShareMemoryApi getInstance() {
        if (instance == null) {
            instance = new ShareMemoryApi();
        }
        return instance;
    }

    @Override
    public void onConnect(IRobotBinderPool robotBinderPool, Context context) {
        this.mContext = context;
        Log.d((String)TAG, (String)"on connect");
        try {
            this.iShareMemoryInterface = IShareMemoryApi.Stub.asInterface(robotBinderPool.queryBinder(12, null));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDisconnect() {
        super.onDisconnect();
        Log.d((String)TAG, (String)"on dis connect");
        this.iShareMemoryInterface = null;
    }

    public boolean writeToMemoryFile(final byte[] bytes) {
        long availableMemory = ResUtils.getAvailableMemory((Context)this.mContext);
        if (bytes == null || (long)bytes.length > availableMemory * 2L / 3L) {
            Log.e((String)TAG, (String)("writeToMemoryFile failed or Memory is not enough, availableMemory : " + availableMemory / 1024L + " KB"));
            return false;
        }
        if (this.iShareMemoryInterface == null) {
            Log.d((String)TAG, (String)"writeToMemoryFile failed , iShareMemoryInterface is null");
            return false;
        }
        DelayTask.submit(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)("start writeBytes length :" + bytes.length / 1024 + "KB"));
                ShareMemoryApi.this.writeBytes(bytes);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBytes(byte[] bytes) {
        String string = TAG;
        synchronized (string) {
            try {
                long l1 = System.currentTimeMillis();
                MemoryFile memoryFile = new MemoryFile(MEMORY_FILE_NAME, bytes.length);
                memoryFile.allowPurging(true);
                memoryFile.writeBytes(bytes, 0, 0, bytes.length);
                Method method = MemoryFile.class.getDeclaredMethod("getFileDescriptor", new Class[0]);
                FileDescriptor fd = (FileDescriptor)method.invoke((Object)memoryFile, new Object[0]);
                ParcelFileDescriptor pfd = ParcelFileDescriptor.dup((FileDescriptor)fd);
                if (this.iShareMemoryInterface != null) {
                    this.iShareMemoryInterface.setParcelFileDescriptor(pfd);
                }
                this.closeMemoryFile(memoryFile, pfd);
                Log.d((String)TAG, (String)("writeBytes cost time:" + (System.currentTimeMillis() - l1)));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void closeMemoryFile(MemoryFile memoryFile, ParcelFileDescriptor pfd) {
        if (pfd != null) {
            try {
                pfd.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (memoryFile != null) {
            memoryFile.close();
        }
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        try {
            Log.d((String)TAG, (String)"getParcelFileDescriptor: ");
            if (this.iShareMemoryInterface != null) {
                return this.iShareMemoryInterface.getParcelFileDescriptor();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void registerPfdListener(IShareMemoryCallback callback) {
        try {
            if (this.iShareMemoryInterface != null) {
                this.iShareMemoryInterface.registerCallback(callback);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregisterPfdListener(IShareMemoryCallback callback) {
        try {
            if (this.iShareMemoryInterface != null) {
                this.iShareMemoryInterface.unregisterCallback(callback);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startShare() {
        try {
            this.iShareMemoryInterface.startShare();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopShare() {
        try {
            this.iShareMemoryInterface.stopShare();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

