/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import org.json.JSONException;
import org.json.JSONObject;

public class Pose {
    private float px;
    private float py;
    private float theta;
    private final long time;
    private String name;
    private int status;
    private float distance;
    private boolean ignoreDistance = false;
    private int safeDistance = 10;

    public Pose() {
        this.time = System.currentTimeMillis();
    }

    public Pose(float x, float y, float theta) {
        this.px = x;
        this.py = y;
        this.theta = theta;
        this.time = System.currentTimeMillis();
    }

    public Pose(float x, float y, float theta, String name) {
        this.px = x;
        this.py = y;
        this.theta = theta;
        this.name = name;
        this.time = System.currentTimeMillis();
    }

    public Pose(float x, float y, float theta, String name, boolean ignoreDistance, int safeDistance) {
        this.px = x;
        this.py = y;
        this.theta = theta;
        this.name = name;
        this.ignoreDistance = ignoreDistance;
        this.safeDistance = safeDistance;
        this.time = System.currentTimeMillis();
    }

    public float getX() {
        return this.px;
    }

    public float getY() {
        return this.py;
    }

    public float getTheta() {
        return this.theta;
    }

    public long getTime() {
        return this.time;
    }

    public void setX(float x) {
        this.px = x;
    }

    public void setY(float y) {
        this.py = y;
    }

    public void setTheta(float theta) {
        this.theta = theta;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public boolean getIgnoreDistance() {
        return this.ignoreDistance;
    }

    public void setIgnoreDistance(boolean ignoreDistance) {
        this.ignoreDistance = ignoreDistance;
    }

    public int getSafeDistance() {
        return this.safeDistance;
    }

    public void setSafeDistance(int safeDistance) {
        this.safeDistance = safeDistance;
    }

    public String toString() {
        return "x=" + this.px + "  y=" + this.py + " theta=" + this.theta + " name=" + this.name + " ignoreDistance=" + this.ignoreDistance + " safeDistance=" + this.safeDistance;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pose)) {
            return false;
        }
        Pose pose = (Pose)obj;
        return this.px == pose.getX() && this.py == pose.getY() && this.theta == pose.getTheta();
    }

    public int hashCode() {
        int code = 0;
        code += 31 * Float.valueOf(this.px).hashCode() * 10;
        code += 31 * Float.valueOf(this.py).hashCode() * 100;
        return code += 31 * Float.valueOf(this.theta).hashCode() * 1000;
    }

    public double getDistance(Pose pose) {
        if (pose == null) {
            return Double.MAX_VALUE;
        }
        double destX = this.getX();
        double destY = this.getY();
        double x = pose.getX();
        double y = pose.getY();
        return Math.sqrt(Math.pow(x - destX, 2.0) + Math.pow(y - destY, 2.0));
    }

    public String toJson() {
        return this.toJsonObject().toString();
    }

    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        try {
            object.put("px", (double)this.px);
            object.put("py", (double)this.py);
            object.put("theta", (double)this.theta);
            object.put("name", (Object)this.name);
            object.put("ignoreDistance", this.ignoreDistance);
            object.put("safeDistance", this.safeDistance);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }
}

