/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PlaceBean {
    public static final int PLACE_TYPE_ORDINARY = 0;
    public static final int PLACE_TYPE_RECEPTION = 1;
    public static final int PLACE_TYPE_TOILET = 2;
    public static final int PLACE_TYPE_LOUNGE = 3;
    public static final int PLACE_TYPE_FINANCE = 4;
    public static final int PLACE_TYPE_MEETING = 5;
    public static final int PLACE_TYPE_CHARGING_PILE = 6;
    public static final int PLACE_TYPE_CHARGING_POINT = 7;
    public static final int PLACE_STATUS_NORMAL = 0;
    public static final int PLACE_STATUS_DANGER = 1;
    public static final int PLACE_STATUS_OBSTACLE = 2;
    public static final int PLACE_STATUS_OUTSIDE = 3;
    private String placeId = "";
    private String iconUrl = "";
    private int placeType;
    private int placeStatus;
    private float pointTheta;
    private float pointX;
    private float pointY;
    private long updateTime;
    private String mapName = "";
    private String alias = "";
    private Map<String, String> placeNameList;
    private String createTime = "";
    private String mapId;
    private int syncState = 0;
    private boolean ignoreDistance = false;
    private int safeDistance = 10;

    public PlaceBean() {
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public int getPlaceType() {
        return this.placeType;
    }

    public void setPlaceType(int placeType) {
        this.placeType = placeType;
    }

    public int getPlaceStatus() {
        return this.placeStatus;
    }

    public void setPlaceStatus(int placeStatus) {
        this.placeStatus = placeStatus;
    }

    public float getPointTheta() {
        return this.pointTheta;
    }

    public void setPointTheta(float pointTheta) {
        this.pointTheta = pointTheta;
    }

    public float getPointX() {
        return this.pointX;
    }

    public void setPointX(float pointX) {
        this.pointX = pointX;
    }

    public float getPointY() {
        return this.pointY;
    }

    public void setPointY(float pointY) {
        this.pointY = pointY;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getPlaceNameList() {
        return this.placeNameList;
    }

    public String getPlaceName(String languageType) {
        if (null == this.placeNameList) {
            return "";
        }
        return this.placeNameList.get(languageType);
    }

    public String getPlaceName() {
        if (null == this.placeNameList) {
            return "";
        }
        return this.placeNameList.get(Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry());
    }

    public void addPlaceName(String languageType, String name) {
        if (null == this.placeNameList) {
            this.placeNameList = new HashMap<String, String>();
        }
        this.placeNameList.put(languageType, name);
    }

    public void removePlaceName(String languageType) {
        if (this.placeNameList != null) {
            this.placeNameList.remove(languageType);
        }
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public int getSyncState() {
        return this.syncState;
    }

    public void setSyncState(int syncState) {
        this.syncState = syncState;
    }

    public boolean getIgnoreDistance() {
        return this.ignoreDistance;
    }

    public void setIgnoreDistance(boolean ignoreDistance) {
        this.ignoreDistance = ignoreDistance;
    }

    public int getSafeDistance() {
        return this.safeDistance;
    }

    public void setSafeDistance(int safeDistance) {
        this.safeDistance = safeDistance;
    }

    public PlaceBean(JSONObject json, String mapName) {
        this.placeId = json.optString("id");
        this.iconUrl = json.optString("icon_url");
        this.placeType = json.optInt("type");
        this.placeStatus = json.optInt("status");
        this.pointTheta = (float)json.optDouble("theta");
        this.pointX = (float)json.optDouble("x");
        this.pointY = (float)json.optDouble("y");
        if (json.has("time")) {
            this.updateTime = json.optLong("time");
        } else if (json.has("updateTime")) {
            this.updateTime = json.optLong("updateTime");
        }
        this.alias = json.optString("alaias");
        if (json.has("ignoreDistance")) {
            this.ignoreDistance = json.optBoolean("ignoreDistance", false);
        }
        if (json.has("safeDistance")) {
            this.safeDistance = json.optInt("safeDistance", 10);
        }
        this.mapName = mapName;
        JSONObject name = json.optJSONObject("name");
        if (name != null) {
            Iterator it = name.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.addPlaceName(key, name.optString(key));
            }
        }
    }

    public PlaceBean(JsonObject json, String mapName) {
        this.placeId = json.get("id").getAsString();
        this.iconUrl = json.get("icon_url").getAsString();
        this.placeType = json.get("type").getAsInt();
        this.placeStatus = json.get("status").getAsInt();
        this.pointTheta = json.get("theta").getAsFloat();
        this.pointX = json.get("x").getAsFloat();
        this.pointY = json.get("y").getAsFloat();
        if (json.has("time")) {
            this.updateTime = json.get("time").getAsLong();
        } else if (json.has("updateTime")) {
            this.updateTime = json.get("updateTime").getAsLong();
        }
        this.alias = json.get("alaias").getAsJsonObject().toString();
        if (json.has("ignoreDistance")) {
            this.ignoreDistance = json.get("ignoreDistance").getAsBoolean();
        }
        if (json.has("safeDistance")) {
            this.safeDistance = json.get("safeDistance").getAsInt();
        }
        this.mapName = mapName;
        JsonObject name = json.get("name").getAsJsonObject();
        if (name != null) {
            for (Map.Entry item : name.entrySet()) {
                this.addPlaceName((String)item.getKey(), ((JsonElement)item.getValue()).getAsString());
            }
        }
    }

    public JSONObject getJson() {
        JSONObject place = new JSONObject();
        try {
            place.put("id", (Object)this.placeId);
            place.put("icon_url", (Object)this.iconUrl);
            place.put("type", this.placeType);
            place.put("status", this.placeStatus);
            place.put("theta", (double)this.pointTheta);
            place.put("x", (double)this.pointX);
            place.put("y", (double)this.pointY);
            place.put("time", this.updateTime);
            JSONObject name = new JSONObject();
            if (null != this.placeNameList) {
                for (Map.Entry<String, String> stringStringEntry : this.placeNameList.entrySet()) {
                    name.put(stringStringEntry.getKey(), (Object)stringStringEntry.getValue());
                }
            }
            place.put("name", (Object)name);
            place.put("alaias", (Object)new JSONObject(this.alias));
            place.put("ignoreDistance", this.ignoreDistance);
            place.put("safeDistance", this.safeDistance);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return place;
    }
}

