/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;

public class Person {
    public static final String MARK_REMOTE = "R";
    public static final String MARK_LOCAL = "L";
    public static final String MARK_PLUS = "-";
    public static final int REGISTER_REMOTE = 1;
    public static final int REGISTER_LOCAL_OFFICIAL = 2;
    public static final int REGISTER_LOCAL_TEMPORARY = 3;
    public static final int ROLE_GUEST = 1;
    public static final int ROLE_STAFF = 2;
    public static final int ROLE_ADMIN = 3;
    private int personId;
    private String remoteId;
    private int role = 1;
    private int registerType = 3;
    private long registerTime;
    private int spec;
    private String registerName;
    private String name;
    private FaceInfo faceInfo = new FaceInfo();
    private BodyInfo bodyInfo = new BodyInfo();
    private GuestInfo guestInfo = new GuestInfo();

    public FaceInfo getFaceInfo() {
        return this.faceInfo;
    }

    public BodyInfo getBodyInfo() {
        return this.bodyInfo;
    }

    public GuestInfo getGuestInfo() {
        return this.guestInfo;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRegisterType() {
        return this.registerType;
    }

    public void setRegisterType(int registerType) {
        this.registerType = registerType;
    }

    public int getPersonId() {
        return this.personId;
    }

    public void setPersonId(int personId) {
        this.personId = personId;
    }

    public long getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(long registerTime) {
        this.registerTime = registerTime;
    }

    public boolean isLocalRegister() {
        return !TextUtils.isEmpty((CharSequence)this.name);
    }

    public String getRegisterName() {
        return this.registerName;
    }

    public void setRegisterName(String registerName) {
        this.registerName = registerName;
    }

    public int getSpec() {
        return this.spec;
    }

    public void setSpec(int spec) {
        this.spec = spec;
    }

    public String generateRegisterName() {
        String nameInfo = null;
        this.personDataCheck();
        if (this.registerType == 1) {
            nameInfo = "R-" + this.remoteId + MARK_PLUS + this.getName();
        } else if (this.registerType == 2 || this.registerType == 3) {
            nameInfo = "L-" + this.getPersonId() + MARK_PLUS + this.getName();
        }
        return nameInfo;
    }

    public void personDataCheck() {
        if (this.registerType == 1) {
            if (TextUtils.isEmpty((CharSequence)this.remoteId)) {
                throw new RuntimeException("person data error:register type is remote, remote id can not be null"){};
            }
        } else if (this.registerType == 2 || this.registerType == 3) {
            Log.d((String)"Person", (String)("insertPerson remoteId: " + this.remoteId + ", personId: " + this.personId));
        }
    }

    public String toGson() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public class GuestInfo {
        String guestName;
        String location;
        private long bookTime;
        private long invitationTime;
        private long leaveTime;

        public long getBookTime() {
            return this.bookTime;
        }

        public void setBookTime(long bookTime) {
            this.bookTime = bookTime;
        }

        public long getInvitationTime() {
            return this.invitationTime;
        }

        public void setInvitationTime(long invitationTime) {
            this.invitationTime = invitationTime;
        }

        public long getLeaveTime() {
            return this.leaveTime;
        }

        public void setLeaveTime(long leaveTime) {
            this.leaveTime = leaveTime;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getGuestName() {
            return this.guestName;
        }

        public void setGuestName(String name) {
            this.guestName = name;
        }

        public String toLeadingString() {
            return "\u5e26" + Person.this.name + "\u53bb" + this.location;
        }
    }

    public class BodyInfo {
    }

    public class FaceInfo {
        int faceId;
        public int angle;
        public float distance;
        public int headSpeed;
        public int latency;
        public int pictruePath;
        public int facewidth;
        public int faceheight;
        public double faceAngleX;
        public double faceAngleY;
        public double angleInView;
        public int noseHorizontal;
        public int noseVertical;

        public int getFaceWidth() {
            return this.facewidth;
        }

        public int getFaceHeight() {
            return this.faceheight;
        }

        public double getFaceAngleX() {
            return this.faceAngleX;
        }

        public double getFaceAngleY() {
            return this.faceAngleY;
        }

        public int getNoseHorizontal() {
            return this.noseHorizontal;
        }

        public int getNoseVertical() {
            return this.noseVertical;
        }

        public void setFaceWidth(int faceWidth) {
            this.faceheight = faceWidth;
        }

        public void setFaceHeight(int faceHeight) {
            this.faceheight = faceHeight;
        }

        public void setFaceAngleX(double faceAngleX) {
            this.faceAngleX = faceAngleX;
        }

        public void setFaceAngleY(double faceAngleY) {
            this.faceAngleY = faceAngleY;
        }

        public void setNoseHorizontal(int noseHorizontal) {
            this.noseHorizontal = noseHorizontal;
        }

        public void setNoseVertical(int noseVertical) {
            this.noseVertical = noseVertical;
        }

        public int getFaceId() {
            return this.faceId;
        }

        public void setFaceId(int faceId) {
            this.faceId = faceId;
        }

        public int getAngle() {
            return this.angle;
        }

        public void setAngle(int angle) {
            this.angle = angle;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public int getHeadSpeed() {
            return this.headSpeed;
        }

        public void setHeadSpeed(int headSpeed) {
            this.headSpeed = headSpeed;
        }

        public int getLatency() {
            return this.latency;
        }

        public void setLatency(int latency) {
            this.latency = latency;
        }

        public int getPictruePath() {
            return this.pictruePath;
        }

        public void setPictruePath(int pictruePath) {
            this.pictruePath = pictruePath;
        }

        public double getAngleInView() {
            return this.angleInView;
        }

        public void setAngleInView(double angleInView) {
            this.angleInView = angleInView;
        }
    }
}

