/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.client.Definition;
import com.ainirobot.coreservice.client.actionbean.NavigationBean;
import com.ainirobot.coreservice.client.actionbean.Pose;
import java.util.List;
import org.json.JSONObject;

public class NavigationAdvancedBean
extends NavigationBean
implements Cloneable {
    private static final double DEFAULT_DESTINATION_COORDINATE_DEVIATION = 0.5;
    private static final long GO_DESTINATION_MOVING_TIMEOUT_TIME = 600000L;
    private static final long DEFAULT_MULTI_ROBOT_AVOID_WAITING_TIMEOUT = 300000L;
    public static final int TYPE_DESTINATION = 1;
    public static final int TYPE_POSE = 2;
    private static final int WHEEL_OVER_CURRENT_RETRY_DEFAULT_COUNT = 0;
    private static final double DEFAULT_COORDINATE_DEVIATION = 0.5;
    private static final long DEFAULT_AVOID_INTERVAL_TIME = 5000L;
    private static final int DEFAULT_MAX_AVOID_COUNT = 5;
    private static final long DEFAULT_MOVING_TIMEOUT_TIME = 20000L;
    private static final long GET_DISTANCE_INTERVAL_TIME = 1000L;
    private static final long GET_DISTANCE_MIN_INTERVAL_TIME = 200L;
    private static final int DEFAULT_NAVIGAITON_TASK_PRIORITY = 0;
    public static final double NAVIGATION_DEFAULT_DESTINATION_RANGE = 0.5;
    private int targetFloor = 0;
    private Definition.AdvNaviStrategy advNaviStrategy = Definition.AdvNaviStrategy.DEFAULT;
    private boolean fillingStrategy = false;
    private String navigationParams;
    private List<String> standbyDesList;
    private long movieTimeout = 20000L;
    private long avoidIntervalTime = 5000L;
    private int maxAvoidCount = 5;
    private long distanceIntervalTime = 1000L;
    private double inDestinationRange = 0.5;
    private boolean isNeedAvoidNotifyImmediately = true;
    private Pose naviPose;
    private int naviType = 1;
    private String currentPlace;
    private int lastAvoidMaxCnt = 0;
    public static final float LINEAR_SPEED_MIN = 0.1f;
    public static final float LINEAR_SPEED_MAX = 1.2f;
    public static final float ANGULAR_SPEED_MIN = 0.2f;
    public static final float ANGULAR_SPEED_MAX = 1.8f;

    public NavigationAdvancedBean() {
        this.setCoordinateDeviation(0.5);
        this.setMovieTimeout(600000L);
        this.setMultipleWaitTime(300000L);
    }

    public int getTargetFloor() {
        return this.targetFloor;
    }

    public void setTargetFloor(int targetFloor) {
        this.targetFloor = targetFloor;
    }

    public Definition.AdvNaviStrategy getNaviStrategy() {
        return this.advNaviStrategy;
    }

    public void setNaviStrategy(Definition.AdvNaviStrategy advNaviStrategy) {
        this.advNaviStrategy = advNaviStrategy;
    }

    public boolean isFillingStrategy() {
        return this.fillingStrategy;
    }

    public void setFillingStrategy(boolean fillingStrategy) {
        this.fillingStrategy = fillingStrategy;
    }

    public int getLastAvoidMaxCnt() {
        return this.lastAvoidMaxCnt;
    }

    public void setLastAvoidMaxCnt(int lastAvoidMaxCnt) {
        this.lastAvoidMaxCnt = lastAvoidMaxCnt;
    }

    public Pose getNaviPose() {
        return this.naviPose;
    }

    public void setNaviPose(Pose naviPose) {
        this.naviPose = naviPose;
        if (null != naviPose && !TextUtils.isEmpty((CharSequence)naviPose.getName())) {
            this.setDestination(naviPose.getName());
        }
    }

    public String getNavigationParams() {
        return this.navigationParams;
    }

    public void initNavigationParams() {
        if (null != this.navigationParams) {
            try {
                JSONObject params = new JSONObject(this.navigationParams);
                Log.d((String)"NaviAdvancedAction", (String)("setNavigationParams params " + params));
                this.setLastAvoidMaxCnt(params.optInt("last_navigation_avoid_max_count", 0));
                this.setNaviType(params.optInt("navigation_type", 1));
                this.setFillingStrategy(params.optBoolean("fillingWhenDelivery", false));
                this.setCurrentPlace(params.optString("current_place", ""));
                this.setCoordinateDeviation(params.optDouble("coordinate_deviation", 0.5));
                long movieTime = params.optLong("moving_timeout_time", 20000L);
                this.setMovieTimeout(movieTime);
                this.setMaxAvoidCount(params.optInt("max_avoid_count", 5));
                this.setAvoidIntervalTime(params.optLong("avoid_interval_time", 5000L));
                this.setDistanceIntervalTime(params.optLong("get_distance_interval_time", 1000L));
                this.setAdjustAngle(params.optBoolean("param_is_adjust_angle", false));
                this.setDestinationRange(params.optDouble("param_destination_range", 0.5));
                this.setInDestinationRange(params.optDouble("in_destination_range", 0.5));
                long waitTimeout = params.optLong("param_multi_waiting_timeout_time", 300000L);
                this.setMultipleWaitTime(waitTimeout <= 0L ? 300000L : waitTimeout);
                this.setPriority(params.optInt("param_priority", 0));
                this.setNeedAvoidNotifyImmediately(params.optBoolean("param_is_need_avoid_notify_immediately", true));
                this.setLinearAcceleration(params.optDouble("linear_acceleration", 0.0));
                this.setAngularAcceleration(params.optDouble("angular_acceleration", 0.0));
                this.setStartModeLevel(params.optInt("start_mode_level", 0));
                this.setBrakeModeLevel(params.optInt("brake_mode_level", 0));
                int wheelOverCurrentRetryCount = params.optInt("param_wheel_over_current_retry_count", 0);
                if (wheelOverCurrentRetryCount < 0) {
                    wheelOverCurrentRetryCount = 0;
                }
                this.setWheelOverCurrentRetryCount(wheelOverCurrentRetryCount);
                float lineSpeed = (float)params.optDouble("param_linear_speed", (double)0.7f);
                lineSpeed = this.rectifyLinearSpeed(lineSpeed);
                this.setLinearSpeed(lineSpeed);
                float angularSpeed = (float)params.optDouble("param_angular_speed", (double)1.2f);
                angularSpeed = this.rectifyAngularSpeed(angularSpeed);
                this.setAngularSpeed(angularSpeed);
                if (this.naviType == 2) {
                    Pose pose = new Pose();
                    pose.setX(Float.parseFloat(params.optString("pose_x", "0f")));
                    pose.setY(Float.parseFloat(params.optString("pose_y", "0f")));
                    pose.setTheta(Float.parseFloat(params.optString("pose_theta", "0f")));
                    this.setNaviPose(pose);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.navigationParams = null;
                Log.e((String)"NaviAdvancedAction", (String)("setNavigationParams error: " + e.getMessage()));
            }
        }
    }

    public void setNavigationParams(String navigationParams) {
        this.navigationParams = navigationParams;
        this.initNavigationParams();
    }

    public List<String> getStandbyDesList() {
        return this.standbyDesList;
    }

    public void setStandbyDesList(List<String> mStandbyDesList) {
        this.standbyDesList = mStandbyDesList;
    }

    public long getMovieTimeout() {
        return this.movieTimeout;
    }

    public void setMovieTimeout(long movieTimeout) {
        this.movieTimeout = movieTimeout <= 0L ? Long.MAX_VALUE : movieTimeout;
    }

    public long getAvoidIntervalTime() {
        return this.avoidIntervalTime;
    }

    public void setAvoidIntervalTime(long avoidIntervalTime) {
        this.avoidIntervalTime = avoidIntervalTime;
    }

    public int getMaxAvoidCount() {
        return this.maxAvoidCount;
    }

    public void setMaxAvoidCount(int maxAvoidCount) {
        this.maxAvoidCount = maxAvoidCount;
    }

    public long getDistanceIntervalTime() {
        return this.distanceIntervalTime;
    }

    public void setDistanceIntervalTime(long distanceIntervalTime) {
        if (distanceIntervalTime < 200L) {
            distanceIntervalTime = 1000L;
        }
        this.distanceIntervalTime = distanceIntervalTime;
    }

    public boolean isNeedAvoidNotifyImmediately() {
        return this.isNeedAvoidNotifyImmediately;
    }

    public void setNeedAvoidNotifyImmediately(boolean isNeedAvoidNotifyImmediately) {
        this.isNeedAvoidNotifyImmediately = isNeedAvoidNotifyImmediately;
    }

    public int getNaviType() {
        return this.naviType;
    }

    public void setNaviType(int naviType) {
        this.naviType = naviType;
    }

    public String getCurrentPlace() {
        return this.currentPlace;
    }

    public void setCurrentPlace(String currentPlace) {
        this.currentPlace = currentPlace;
    }

    public double getInDestinationRange() {
        return this.inDestinationRange;
    }

    public void setInDestinationRange(double inDestinationRange) {
        this.inDestinationRange = inDestinationRange;
    }

    private float rectifyLinearSpeed(float speed) {
        if (speed < 0.1f) {
            speed = 0.1f;
        } else if (speed > 1.2f) {
            speed = 1.2f;
        }
        return speed;
    }

    private float rectifyAngularSpeed(float speed) {
        if (speed < 0.2f) {
            speed = 0.2f;
        } else if (speed > 1.8f) {
            speed = 1.8f;
        }
        return speed;
    }

    public NavigationAdvancedBean clone() {
        NavigationAdvancedBean bean = null;
        try {
            bean = (NavigationAdvancedBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return bean;
    }

    public String toString() {
        return "NavigationAdvancedBean{destination=" + this.getDestination() + ", targetFloor=" + this.targetFloor + ", naviStrategy=" + (Object)((Object)this.advNaviStrategy) + ", fillingStrategy=" + this.fillingStrategy + ", standbyDesList=" + this.standbyDesList + ", movieTimeout=" + this.movieTimeout + ", avoidIntervalTime=" + this.avoidIntervalTime + ", maxAvoidCount=" + this.maxAvoidCount + ", distanceIntervalTime=" + this.distanceIntervalTime + ", isNeedAvoidNotifyImmediately=" + this.isNeedAvoidNotifyImmediately + ", destinationPose=" + this.naviPose + ", naviType=" + this.naviType + ", currentPlace='" + this.currentPlace + ", lastAvoidMaxCnt=" + this.lastAvoidMaxCnt + ", inDestinationRange=" + this.inDestinationRange + ", navigationParams='" + this.navigationParams + '}';
    }

    public static class Navigation {
        public static final String PARAM_NAVIGATION_TYPE = "navigation_type";
        public static final String PARAM_COORDINATE_DEVIATION = "coordinate_deviation";
        public static final String PARAM_MOVING_TIMEOUT_TIME = "moving_timeout_time";
        public static final String PARAM_AVOID_INTERVAL_TIME = "avoid_interval_time";
        public static final String PARAM_GET_DISTANCE_INTERVAL_TIME = "get_distance_interval_time";
        public static final String PARAM_MAX_AVOID_COUNT = "max_avoid_count";
        public static final String PARAM_LINEAR_SPEED = "param_linear_speed";
        public static final String PARAM_ANGULAR_SPEED = "param_angular_speed";
        public static final String PARAM_IS_ADJUST_ANGLE = "param_is_adjust_angle";
        public static final String PARAM_MULTI_ROBOT_WAITING_TIMEOUT_TIME = "param_multi_waiting_timeout_time";
        public static final String PARAM_IS_NEED_AVOID_NOTIFY_IMMEDIATELY = "param_is_need_avoid_notify_immediately";
        public static final String PARAM_DESTINATION_RANGE = "param_destination_range";
        public static final String PARAM_WHEEL_OVER_CURRENT_RETRY_COUNT = "param_wheel_over_current_retry_count";
        public static final String PARAM_PRIORITY = "param_priority";
        public static final String PARAM_POSE_X = "pose_x";
        public static final String PARAM_POSE_Y = "pose_y";
        public static final String PARAM_POSE_THETA = "pose_theta";
        public static final String PARAM_LINEAR_ACCELERATION = "linear_acceleration";
        public static final String PARAM_ANGULAR_ACCELERATION = "angular_acceleration";
        public static final String PARAM_START_MODE_LEVEL = "start_mode_level";
        public static final String PARAM_BRAKE_MODE_LEVEL = "brake_mode_level";
        public static final String PARAM_IN_DESTINATION_RANGE = "in_destination_range";
        public static final String PARAM_LAST_NAVIGATION_AVOID_MAX_COUNT = "last_navigation_avoid_max_count";
        public static final String PARAM_FILLING_WHEN_DELIVERY = "fillingWhenDelivery";
        public static final String PARAM_CURRENT_PLACE = "current_place";
    }
}

