/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InspectionResult {
    private int result;
    private boolean otaResult = true;
    private List<StepBean> step = new ArrayList<StepBean>();
    private List<FailBean> fail = new ArrayList<FailBean>();
    private List<PassBean> pass = new ArrayList<PassBean>();

    public InspectionResult() {
    }

    public InspectionResult(int result, List<StepBean> step, List<FailBean> fail, List<PassBean> pass) {
        this.result = result;
        this.step = step;
        this.fail = fail;
        this.pass = pass;
    }

    public InspectionResult(int result, boolean otaResult, List<StepBean> step, List<FailBean> fail, List<PassBean> pass) {
        this.result = result;
        this.otaResult = otaResult;
        this.step = step;
        this.fail = fail;
        this.pass = pass;
    }

    public boolean isOtaResult() {
        return this.otaResult;
    }

    public void setOtaResult(boolean otaResult) {
        this.otaResult = otaResult;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public List<StepBean> getStep() {
        return this.step;
    }

    public void setStep(List<StepBean> step) {
        this.step = step;
    }

    public List<FailBean> getFail() {
        return this.fail;
    }

    public void setFail(List<FailBean> fail) {
        this.fail = fail;
    }

    public List<PassBean> getPass() {
        return this.pass;
    }

    public void setPass(List<PassBean> pass) {
        this.pass = pass;
    }

    public String toString() {
        return "InspectionResult{result=" + this.result + ", otaResult=" + this.otaResult + ", step=" + this.step + ", fail=" + this.fail + ", pass=" + this.pass + '}';
    }

    public static class PassBean {
        private String name;
        private String service;

        public PassBean() {
        }

        public PassBean(String name, String service) {
            this.name = name;
            this.service = service;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String toString() {
            return "PassBean{name='" + this.name + '\'' + ", service='" + this.service + '\'' + '}';
        }
    }

    public static class FailBean {
        private String name;
        private int code;
        private String service;
        private String errorMsg;
        private boolean isIgnore;
        private Map<String, String> langErrorMsg = new HashMap<String, String>();

        public FailBean() {
        }

        public FailBean(String name, int code, String service, String errorMsg) {
            this.name = name;
            this.code = code;
            this.service = service;
            this.errorMsg = errorMsg;
        }

        public FailBean(String name, int code, String service, String errorMsg, boolean isIgnore) {
            this.name = name;
            this.code = code;
            this.service = service;
            this.errorMsg = errorMsg;
            this.isIgnore = isIgnore;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public boolean isIgnore() {
            return this.isIgnore;
        }

        public void setIgnore(boolean ignore) {
            this.isIgnore = ignore;
        }

        public void setErrorMsg(Map<String, String> errorMsg) {
            if (errorMsg == null) {
                errorMsg = new HashMap<String, String>();
            }
            this.langErrorMsg = errorMsg;
        }

        public String getErrorMsg(String language) {
            return this.langErrorMsg.get(language);
        }

        public void addErrorMsg(String lang, String errorMsg) {
            this.langErrorMsg.put(lang, errorMsg);
        }

        public String toString() {
            return "FailBean{name='" + this.name + '\'' + ", code=" + this.code + ", service='" + this.service + '\'' + ", errorMsg='" + this.errorMsg + '\'' + ", isIgnore=" + this.isIgnore + '}';
        }
    }

    public static class StepBean {
        private String service;
        private int step;

        public StepBean() {
        }

        public StepBean(String service, int step) {
            this.service = service;
            this.step = step;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public int getStep() {
            return this.step;
        }

        public void setStep(int step) {
            this.step = step;
        }

        public String toString() {
            return "StepBean{service='" + this.service + '\'' + ", step='" + this.step + '\'' + '}';
        }
    }
}

