/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import android.util.Log;
import com.google.gson.Gson;
import java.util.ArrayList;

public class InspectionBean {
    private int result = 1;
    private Data821 data821 = new Data821();
    private Can can = new Can();
    private Head head = new Head();
    private Navigation navigation = new Navigation();

    public Data821 getData821() {
        return this.data821;
    }

    public Can getCan() {
        return this.can;
    }

    public Head getHead() {
        return this.head;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public String toString() {
        return "InspectionBean{data821=" + this.data821 + ", can=" + this.can + ", head=" + this.head + ", navigation=" + this.navigation + '}';
    }

    public String toJsonStr() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public void setResultChecked() {
        this.result = this.checkResult();
    }

    public int getResult() {
        return this.result;
    }

    private int checkResult() {
        Log.d((String)"InspectionBean", (String)this.toString());
        if (this.snapDragon821checkHasError()) {
            return -1;
        }
        if (this.canCheckHasError()) {
            return -2;
        }
        if (this.headCheckHasError()) {
            return -3;
        }
        if (this.navCheckHasError()) {
            return -4;
        }
        return 1;
    }

    public boolean needShowErrorUi() {
        return this.snapDragon821checkShowErrorUi() || this.canCheckShowErrorUi() || this.headCheckShowErrorUi() || this.navCheckShowErrorUi();
    }

    public boolean needReportError() {
        return this.snapDragon821checkHasError() || this.canCheckHasError() || this.headCheckHasError() || this.navCheckHasError();
    }

    private boolean snapDragon821checkShowErrorUi() {
        return false;
    }

    private boolean snapDragon821checkHasError() {
        if (this.isStateError(this.data821.getCamera()) || this.isStateError(this.data821.getLightSensor())) {
            Log.d((String)"InspectionBean", (String)"snapDragon821checkHasError true");
            return true;
        }
        return false;
    }

    private boolean canCheckShowErrorUi() {
        if (this.isStateError(this.can.getLink()) || this.isCanStateError(this.can.getMotorHorizontal()) || this.isCanStateError(this.can.getMotorVertical()) || this.isWheelError(this.can.getWheelLeft()) || this.isWheelError(this.can.getWheelRight()) || this.isStateError(this.can.getMotorZeroCheck()) || this.isPowerPanelError(this.can.getPowerPanel()) || this.isBMSError(this.can.getBattery()) || this.isChargingPanelerror(this.can.getChargingPanel())) {
            Log.d((String)"InspectionBean", (String)"canCheckShowErrorUi true");
            return true;
        }
        return false;
    }

    private boolean canCheckHasError() {
        if (this.canCheckShowErrorUi()) {
            Log.d((String)"InspectionBean", (String)"canCheckHasError true");
            return true;
        }
        return false;
    }

    private boolean headCheckShowErrorUi() {
        if (this.isStateError(this.head.getPing()) || this.isSocketStateError(this.head.getSocket()) || this.isStateError(this.head.getWideFont())) {
            Log.d((String)"InspectionBean", (String)"headCheckShowErrorUi true");
            return true;
        }
        return false;
    }

    private boolean headCheckHasError() {
        if (this.headCheckShowErrorUi() || this.isStateError(this.head.getWideBack()) || this.isStateError(this.head.getVisionBack()) || this.isStateError(this.head.getVisionFont())) {
            Log.d((String)"InspectionBean", (String)"headCheckHasError true");
            return true;
        }
        return false;
    }

    private boolean navCheckShowErrorUi() {
        if (this.isStateError(this.navigation.getPing()) || this.isSocketStateError(this.navigation.getSocket()) || this.isStateError(this.navigation.getServiceOk()) || this.isStateError(this.navigation.getSelfCheckResponse()) || this.isStateError(this.navigation.getLaser()) || this.isStateError(this.navigation.getLaserAvailable()) || this.isStateError(this.navigation.getInfrared()) || this.isStateError(this.navigation.getSpeedometer()) || this.isStateError(this.navigation.getCanControlReady())) {
            Log.d((String)"InspectionBean", (String)"navCheckShowErrorUi true");
            return true;
        }
        return false;
    }

    private boolean navCheckHasError() {
        if (this.navCheckShowErrorUi() || this.isStateError(this.navigation.getResetCamera()) || this.isStateError(this.navigation.getRgbd()) || this.isStateError(this.navigation.getCalibrationReady()) || this.isStateError(this.navigation.getHardDiskSpaceEnough()) || this.isStateError(this.navigation.getCanControlReady())) {
            Log.d((String)"InspectionBean", (String)"navCheckHasError true");
            return true;
        }
        return false;
    }

    private boolean isCanStateError(int state) {
        ArrayList<Integer> listPass = new ArrayList<Integer>(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(-2);
            }
        };
        return !listPass.contains(state);
    }

    private boolean isSocketStateError(int state) {
        ArrayList<Integer> listPass = new ArrayList<Integer>(){
            {
                this.add(2);
                this.add(-2);
            }
        };
        return !listPass.contains(state);
    }

    private boolean isStateError(int state) {
        ArrayList<Integer> listPass = new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(-2);
            }
        };
        return !listPass.contains(state);
    }

    private boolean isWheelError(int state) {
        return state == 3 || state == -1;
    }

    private boolean isPowerPanelError(int state) {
        return state == 3 || state == -1;
    }

    private boolean isBMSError(int battery) {
        return battery == -1;
    }

    private boolean isChargingPanelerror(int state) {
        return state == 255 || state == -1;
    }

    public class Navigation {
        private int ping = 1;
        private int socket = 2;
        private int resetCamera = 1;
        private int rgbd = 1;
        private int laser = 1;
        private int infrared = 1;
        private int speedometer = 1;
        private int laserAvailable = 1;
        private int calibrationReady = 1;
        private int hardDiskSpaceEnough = 1;
        private int canControlReady = 1;
        private int serviceOk = 1;
        private int selfCheckResponse = 1;

        public int getServiceOk() {
            return this.serviceOk;
        }

        public void setServiceOk(int serviceOk) {
            this.serviceOk = serviceOk;
        }

        public int getSelfCheckResponse() {
            return this.selfCheckResponse;
        }

        public void setSelfCheckResponse(int selfCheckResponse) {
            this.selfCheckResponse = selfCheckResponse;
        }

        public int getLaserAvailable() {
            return this.laserAvailable;
        }

        public void setLaserAvailable(int laserAvailable) {
            this.laserAvailable = laserAvailable;
        }

        public int getCalibrationReady() {
            return this.calibrationReady;
        }

        public void setCalibrationReady(int calibrationReady) {
            this.calibrationReady = calibrationReady;
        }

        public int getHardDiskSpaceEnough() {
            return this.hardDiskSpaceEnough;
        }

        public void setHardDiskSpaceEnough(int hardDiskSpaceEnough) {
            this.hardDiskSpaceEnough = hardDiskSpaceEnough;
        }

        public int getPing() {
            return this.ping;
        }

        public void setPing(int ping) {
            this.ping = ping;
        }

        public int getSocket() {
            return this.socket;
        }

        public void setSocket(int socket) {
            this.socket = socket;
        }

        public int getResetCamera() {
            return this.resetCamera;
        }

        public void setResetCamera(int resetCamera) {
            this.resetCamera = resetCamera;
        }

        public int getRgbd() {
            return this.rgbd;
        }

        public void setRgbd(int rgbd) {
            this.rgbd = rgbd;
        }

        public int getLaser() {
            return this.laser;
        }

        public void setLaser(int laser) {
            this.laser = laser;
        }

        public int getInfrared() {
            return this.infrared;
        }

        public void setInfrared(int infrared) {
            this.infrared = infrared;
        }

        public int getSpeedometer() {
            return this.speedometer;
        }

        public void setSpeedometer(int speedometer) {
            this.speedometer = speedometer;
        }

        public int getCanControlReady() {
            return this.canControlReady;
        }

        public void setCanControlReady(int canControlReady) {
            this.canControlReady = canControlReady;
        }

        public String toString() {
            return "Navigation{ping=" + this.ping + ", socket=" + this.socket + ", resetCamera=" + this.resetCamera + ", rgbd=" + this.rgbd + ", laser=" + this.laser + ", infrared=" + this.infrared + ", speedometer=" + this.speedometer + ", laserAvailable = " + this.laserAvailable + ", calibrationReady = " + this.calibrationReady + ", hardDiskSpaceEnough = " + this.hardDiskSpaceEnough + ", canControlReady = " + this.canControlReady + ", serviceOK = " + this.serviceOk + ", selfCheckResponse" + this.selfCheckResponse + '}';
        }
    }

    public class Head {
        private int ping = 1;
        private int socket = 2;
        private int visionFont = 1;
        private int visionBack = 1;
        private int wideFont = 1;
        private int wideBack = 1;

        public int getPing() {
            return this.ping;
        }

        public void setPing(int ping) {
            this.ping = ping;
        }

        public int getSocket() {
            return this.socket;
        }

        public void setSocket(int socket) {
            this.socket = socket;
        }

        public int getVisionFont() {
            return this.visionFont;
        }

        public void setVisionFont(int visionFont) {
            this.visionFont = visionFont;
        }

        public int getVisionBack() {
            return this.visionBack;
        }

        public void setVisionBack(int visionBack) {
            this.visionBack = visionBack;
        }

        public int getWideFont() {
            return this.wideFont;
        }

        public void setWideFont(int wideFont) {
            this.wideFont = wideFont;
        }

        public int getWideBack() {
            return this.wideBack;
        }

        public void setWideBack(int wideBack) {
            this.wideBack = wideBack;
        }

        public String toString() {
            return "Head{ping=" + this.ping + ", socket=" + this.socket + ", visionFont=" + this.visionFont + ", visionBack=" + this.visionBack + ", wideFont=" + this.wideFont + ", wideBack=" + this.wideBack + '}';
        }
    }

    public class Can {
        private int link = 1;
        private int motorHorizontal = 1;
        private int motorVertical = 1;
        private int battery;
        private int charge;
        private int powerPanel = 1;
        private int chargingPanel = 1;
        private int scramStatus;
        private int wheelLeft = 1;
        private int wheelRight = 1;
        private int motorZeroCheck = 1;

        public int getMotorZeroCheck() {
            return this.motorZeroCheck;
        }

        public void setMotorZeroCheck(int motorZeroCheck) {
            this.motorZeroCheck = motorZeroCheck;
        }

        public int getLink() {
            return this.link;
        }

        public void setLink(int link) {
            this.link = link;
        }

        public int getMotorHorizontal() {
            return this.motorHorizontal;
        }

        public void setMotorHorizontal(int motorHorizontal) {
            this.motorHorizontal = motorHorizontal;
        }

        public int getMotorVertical() {
            return this.motorVertical;
        }

        public void setMotorVertical(int motorVertical) {
            this.motorVertical = motorVertical;
        }

        public int getBattery() {
            return this.battery;
        }

        public void setBattery(int battery) {
            this.battery = battery;
        }

        public int getCharge() {
            return this.charge;
        }

        public void setCharge(int charge) {
            this.charge = charge;
        }

        public int getPowerPanel() {
            return this.powerPanel;
        }

        public void setPowerPanel(int powerPanel) {
            this.powerPanel = powerPanel;
        }

        public int getChargingPanel() {
            return this.chargingPanel;
        }

        public void setChargingPanel(int charginPanel) {
            this.chargingPanel = charginPanel;
        }

        public int getScramStatus() {
            return this.scramStatus;
        }

        public void setScramStatus(int scarmStatus) {
            this.scramStatus = scarmStatus;
        }

        public int getWheelLeft() {
            return this.wheelLeft;
        }

        public void setWheelLeft(int wheelLeft) {
            this.wheelLeft = wheelLeft;
        }

        public int getWheelRight() {
            return this.wheelRight;
        }

        public void setWheelRight(int wheelRight) {
            this.wheelRight = wheelRight;
        }

        public String toString() {
            return "Can{link=" + this.link + ", motorHorizontal=" + this.motorHorizontal + ", motorVertical=" + this.motorVertical + ", battery=" + this.battery + ", charge=" + this.charge + ", powerPanel=" + this.powerPanel + ", chargingPanel=" + this.chargingPanel + ", scramStatus=" + this.scramStatus + ", wheelLeft=" + this.wheelLeft + ", wheelRight=" + this.wheelRight + '}';
        }
    }

    public class Data821 {
        private int net = 1;
        private int camera = 1;
        private int bindStatus = 1;
        private int lightSensor = 1;

        public int getLightSensor() {
            return this.lightSensor;
        }

        public void setLightSensor(int lightSensor) {
            this.lightSensor = lightSensor;
        }

        public int getNet() {
            return this.net;
        }

        public void setNet(int net) {
            this.net = net;
        }

        public int getCamera() {
            return this.camera;
        }

        public void setCamera(int camera) {
            this.camera = camera;
        }

        public int getBindStatus() {
            return this.bindStatus;
        }

        public void setBindStatus(int bindStatus) {
            this.bindStatus = bindStatus;
        }

        public String toString() {
            return "Data821{net=" + this.net + ", camera=" + this.camera + ", bindStatus=" + this.bindStatus + ", lightSensor=" + this.lightSensor + '}';
        }
    }
}

