/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.actionbean;

import android.text.TextUtils;
import com.ainirobot.coreservice.client.actionbean.BaseBean;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GongFuBean
extends BaseBean {
    private int mGongFuTyep;
    private List<HeadAction> mHeadActionList;
    private List<FootAction> mFootActionList;
    private String footActionJson;
    private String headActionJson;

    public String getFootActionJson() {
        return this.footActionJson;
    }

    public void setFootActionJson(String footActionJson) {
        this.footActionJson = footActionJson;
    }

    public String getHeadActionJson() {
        return this.headActionJson;
    }

    public void setHeadActionJson(String headActionJson) {
        this.headActionJson = headActionJson;
    }

    public List<HeadAction> getHeadActionList() {
        if (TextUtils.isEmpty((CharSequence)this.headActionJson)) {
            return null;
        }
        this.mHeadActionList = new ArrayList<HeadAction>();
        try {
            JSONArray array = new JSONArray(this.headActionJson);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                HeadAction action = new HeadAction();
                action.setAngle_horizontal(object.optInt("angle_horizontal"));
                action.setAngle_vertical(object.optInt("angle_vertical"));
                action.setBeginTime(object.optLong("begin_time"));
                action.setSpeed_horizontal(object.optInt("speed_horizontal"));
                action.setSpeed_vertical(object.optInt("speed_vertical"));
                this.mHeadActionList.add(action);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.mHeadActionList;
    }

    public List<FootAction> getFootActionList() {
        if (TextUtils.isEmpty((CharSequence)this.footActionJson)) {
            return null;
        }
        this.mFootActionList = new ArrayList<FootAction>();
        try {
            JSONArray array = new JSONArray(this.footActionJson);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                FootAction action = new FootAction();
                action.setBeginTime(object.optLong("begin_time"));
                action.setAngle(Float.parseFloat(object.optString("angle")));
                action.setDistance(Float.parseFloat(object.optString("distance")));
                action.setSpeed(Float.parseFloat(object.optString("speed")));
                this.mFootActionList.add(action);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.mFootActionList;
    }

    public void setHeadActionList(ArrayList<HeadAction> headActionList) {
        this.mHeadActionList = headActionList;
        if (headActionList == null || headActionList.size() < 1) {
            this.headActionJson = "";
            return;
        }
        ArrayList<HeadAction> list = new ArrayList<HeadAction>(headActionList);
        JSONArray array = new JSONArray();
        for (HeadAction action : list) {
            array.put((Object)action.toJsonObject());
        }
        this.headActionJson = array.toString();
    }

    public void setFootActionList(ArrayList<FootAction> footActionList) {
        this.mFootActionList = footActionList;
        if (footActionList == null || footActionList.size() < 1) {
            this.headActionJson = "";
            return;
        }
        ArrayList<FootAction> list = new ArrayList<FootAction>(footActionList);
        JSONArray array = new JSONArray();
        for (FootAction action : list) {
            array.put((Object)action.toJsonObject());
        }
        this.footActionJson = array.toString();
    }

    public int getmGongFuTyep() {
        return this.mGongFuTyep;
    }

    public void setmGongFuTyep(int mGongFuTyep) {
        this.mGongFuTyep = mGongFuTyep;
    }

    public HeadAction obtainHeadAction(int angle_horizontal, int angle_vertical, int speed_horizontal, int speed_vertical, long beginTime) {
        return new HeadAction(angle_horizontal, angle_vertical, speed_horizontal, speed_vertical, beginTime);
    }

    public FootAction obtainFootAction(float angle, float speed, float distance, long beginTime) {
        return new FootAction(angle, speed, distance, beginTime);
    }

    public class FootAction {
        private Long beginTime;
        private float angle;
        private float speed;
        private float distance;

        FootAction() {
        }

        FootAction(float angle, float speed, float distance, long beginTime) {
            this.beginTime = beginTime;
            this.angle = angle;
            this.speed = speed;
            this.distance = distance;
        }

        public Long getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(Long beginTime) {
            this.beginTime = beginTime;
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public float getSpeed() {
            return this.speed;
        }

        public void setSpeed(float speed) {
            this.speed = speed;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("angle: " + this.angle);
            sb.append(" , distance: " + this.distance);
            sb.append(" , speed: " + this.speed);
            sb.append(" , begin time: " + this.beginTime);
            return sb.toString();
        }

        public JSONObject toJsonObject() {
            JSONObject object = new JSONObject();
            try {
                object.put("angle", (double)this.angle);
                object.put("distance", (double)this.distance);
                object.put("speed", (double)this.speed);
                object.put("begin_time", (Object)this.beginTime);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return object;
        }
    }

    public class HeadAction {
        private int headType;
        private int angle_horizontal;
        private int angle_vertical;
        private int speed_horizontal;
        private int speed_vertical;
        private Long beginTime;

        HeadAction() {
        }

        HeadAction(int angle_horizontal, int angle_vertical, int speed_horizontal, int speed_vertical, long beginTime) {
            this.angle_vertical = angle_vertical;
            this.angle_horizontal = angle_horizontal;
            this.speed_horizontal = speed_horizontal;
            this.speed_vertical = speed_vertical;
            this.beginTime = beginTime;
        }

        public int getHeadType() {
            return this.headType;
        }

        public void setHeadType(int headType) {
            this.headType = headType;
        }

        public int getAngle_horizontal() {
            return this.angle_horizontal;
        }

        public void setAngle_horizontal(int angle_horizontal) {
            this.angle_horizontal = angle_horizontal;
        }

        public int getAngle_vertical() {
            return this.angle_vertical;
        }

        public void setAngle_vertical(int angle_vertical) {
            this.angle_vertical = angle_vertical;
        }

        public int getSpeed_horizontal() {
            return this.speed_horizontal;
        }

        public void setSpeed_horizontal(int speed_horizontal) {
            this.speed_horizontal = speed_horizontal;
        }

        public int getSpeed_vertical() {
            return this.speed_vertical;
        }

        public void setSpeed_vertical(int speed_vertical) {
            this.speed_vertical = speed_vertical;
        }

        public Long getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(Long beginTime) {
            this.beginTime = beginTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("head type: " + this.headType);
            sb.append(" , angle_horizontal: " + this.angle_horizontal);
            sb.append(" , angle_vertical: " + this.angle_vertical);
            sb.append(" , speed_vertical: " + this.speed_vertical);
            sb.append(" , speed_h: " + this.speed_horizontal);
            sb.append(" , begin time: " + this.beginTime);
            return sb.toString();
        }

        public JSONObject toJsonObject() {
            JSONObject object = new JSONObject();
            try {
                object.put("angle_horizontal", this.angle_horizontal);
                object.put("angle_vertical", this.angle_vertical);
                object.put("speed_vertical", this.speed_vertical);
                object.put("speed_horizontal", this.speed_horizontal);
                object.put("begin_time", (Object)this.beginTime);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return object;
        }
    }
}

