/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.account;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.IAccountApi;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.client.account.AccountListener;
import com.ainirobot.coreservice.client.account.MemberBean;
import com.ainirobot.coreservice.client.listener.ActionListener;
import com.ainirobot.coreservice.client.listener.CommandListener;
import com.ainirobot.coreservice.client.messagedispatcher.AccountDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.ActionDispatcher;
import com.ainirobot.coreservice.client.person.FaceBean;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class AccountApi
extends BaseSubApi {
    private static final String TAG = AccountApi.class.getSimpleName();
    private static AccountApi instance;
    private IAccountApi mApi;
    private Gson mGson;
    private final ArrayList<AccountListener> mAccountListenerList = new ArrayList();
    private AccountListener mAccountListener;

    private AccountApi() {
        Log.i((String)TAG, (String)"AccountApi create");
        this.startNewThread(TAG);
        this.mGson = new Gson();
    }

    public static synchronized AccountApi getInstance() {
        if (null == instance) {
            instance = new AccountApi();
        }
        return instance;
    }

    @Override
    public void onConnect(IRobotBinderPool robotBinderPool, Context context) {
        Log.i((String)TAG, (String)"AccountApi start connect");
        try {
            this.mApi = IAccountApi.Stub.asInterface(robotBinderPool.queryBinder(7, null));
            Log.i((String)TAG, (String)"AccountApi connect success");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public List<MemberBean> getMemberList() {
        if (null == this.mApi) {
            return null;
        }
        try {
            return (List)this.mGson.fromJson(this.mApi.getMemberList(), new TypeToken<List<MemberBean>>(){}.getType());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<MemberBean> getWholeMemberList() {
        if (null == this.mApi) {
            return null;
        }
        try {
            return (List)this.mGson.fromJson(this.mApi.getWholeMemberList(), new TypeToken<List<MemberBean>>(){}.getType());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MemberBean getRecentMember() {
        if (null == this.mApi) {
            return null;
        }
        try {
            String recentMember = this.mApi.getRecentMember();
            if (TextUtils.isEmpty((CharSequence)recentMember)) {
                return null;
            }
            return (MemberBean)this.mGson.fromJson(recentMember, MemberBean.class);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSystemToken() {
        if (null == this.mApi) {
            return null;
        }
        try {
            return this.mApi.getSystemToken();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAccountListener(AccountListener listener) {
        if (this.mApi == null || listener == null) {
            return;
        }
        if (this.mAccountListener == null) {
            this.mAccountListener = new AccountListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memberUpdate() {
                    ArrayList arrayList = AccountApi.this.mAccountListenerList;
                    synchronized (arrayList) {
                        for (AccountListener listenerItem : AccountApi.this.mAccountListenerList) {
                            listenerItem.memberUpdate();
                        }
                    }
                }
            };
        }
        ArrayList<AccountListener> arrayList = this.mAccountListenerList;
        synchronized (arrayList) {
            if (!this.mAccountListenerList.contains(listener)) {
                this.mAccountListenerList.add(listener);
                try {
                    Log.d((String)TAG, (String)"register account listener");
                    AccountDispatcher accountDispatcher = this.mMessageDispatcher.obtainAccountDispatcher(this.mHandlerThread.getLooper(), this.mAccountListener);
                    this.mApi.registerAccountListener(accountDispatcher);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAccountListener(AccountListener listener) {
        if (this.mApi == null || listener == null) {
            return;
        }
        if (this.mAccountListener == null) {
            return;
        }
        ArrayList<AccountListener> arrayList = this.mAccountListenerList;
        synchronized (arrayList) {
            if (this.mAccountListenerList.remove(listener) && this.mAccountListenerList.size() == 0) {
                try {
                    Log.d((String)TAG, (String)"unregister account listener");
                    AccountDispatcher accountDispatcher = this.mMessageDispatcher.obtainAccountDispatcher(this.mHandlerThread.getLooper(), this.mAccountListener);
                    this.mApi.unregisterAccountListener(accountDispatcher);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean reRegisterWithUserIdById(int personId, String userId, CommandListener listener) {
        if (this.mApi == null) {
            return false;
        }
        try {
            ActionDispatcher dispatcher = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            return this.mApi.reRegisterWithUserIdById(personId, userId, dispatcher);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean reRegisterWithUserIdByPic(String picturePath, String userId, CommandListener listener) {
        if (this.mApi == null) {
            return false;
        }
        try {
            ActionDispatcher dispatcher = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            return this.mApi.reRegisterWithUserIdByPic(picturePath, userId, dispatcher);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void recoveryRobot(String userId, String userToken, ActionListener listener) {
        if (this.mApi == null) {
            return;
        }
        try {
            ActionDispatcher actionListener = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            this.mApi.recoveryRobot(userId, userToken, actionListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public List<FaceBean> getRegisteredFaceList() {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getFaceListFromString(this.mApi.getRegisteredFaceList());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<FaceBean> getFaceListFromString(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        return (List)this.mGson.fromJson(message, new TypeToken<List<FaceBean>>(){}.getType());
    }
}

