/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SettingsUtil {
    private static final String TAG = SettingsUtil.class.getSimpleName();
    private static final String AUTHORITY = "settings";
    private static final String TABLE = "global";
    private static final Uri CONTENT_URI = Uri.parse((String)"content://settings/global");
    private static final String CORE_SERVICE = "com.ainirobot.coreservice";
    private static final String HOME = "com.ainirobot.home";
    private static final String FIRST_CONFIG = "com.ainirobot.firstconfig";
    private static final String MODULE_APP = "com.ainirobot.moduleapp";
    private static final String MAP_TOOL = "com.ainirobot.maptool";
    private static final List<String> ACCEPT_PACKAGE_LIST = Collections.unmodifiableList(Arrays.asList("com.ainirobot.coreservice", "com.ainirobot.home", "com.ainirobot.firstconfig", "com.ainirobot.moduleapp", "com.ainirobot.maptool"));
    private static MyContentObserver myContentObserver;
    public static final String ROBOT_SETTING_SHUTDOWN_SWITCH = "robot_setting_shutdown_switch";
    public static final String ROBOT_SETTING_SHUTDOWN_TIMER = "robot_setting_shutdown_time";
    public static final String ROBOT_SETTING_SHUTDOWN_TIMER_DEF = "robot_setting_shutdown_time_def";
    public static final String ROBOT_SETTINGS_HCUSB_ENABLE = "robot_settings_hcusb_enable";
    public static final String ROBOT_FOCUS_FOLLOW_ANGLE = "robot_focus_follow_angle";
    public static final String ROBOT_SETTING_AUTO_CHARGE_INT = "robot_setting_auto_charge";
    public static final String ROBOT_SETTING_OTA_UPDATE_INT = "robot_setting_ota_update";
    public static final String ROBOT_SETTING_CHARGING_CHAT = "robot_usable_when_charging";
    public static final String ROBOT_SETTING_WAKE_ANSWER_INT = "robot_setting_wake_answer";
    public static final String ROBOT_SETTING_SOUND_ANGEL_CENTER_FLOAT = "robot_setting_sound_angel_center";
    public static final String ROBOT_SETTING_SOUND_ANGEL_RANGE_FLOAT = "robot_setting_sound_angel_range";
    public static final String ROBOT_SETTING_HOME_LAUNCHER_COMPONENT = "robot_setting_home_launcher_component";
    public static final String ROBOT_SETTING_SPEECH_VOLUME_INT = "robot_setting_speech_volume_int";
    public static final String ROBOT_SETTING_SPOKE_MAN_INT = "robot_setting_spoke_man";
    public static final String ROBOT_SETTING_SPEECH_RATE_INT = "robot_setting_speech_rate";
    public static final String ROBOT_SETTING_SPEECH_SPEED_INT = "robot_setting_speech_speed";
    public static final String ROBOT_SETTING_SPEECH_PIT_INT = "robot_setting_speech_pit";
    public static final String ROBOT_SETTING_IS_AUTO_LANG = "robot_setting_is_auto_lang";
    public static final String ROBOT_SETTING_LANGS_RANGE = "robot_setting_langs_range";
    public static final String ROBOT_SETTING_ASR_LANG = "robot_setting_asr_lang";
    public static final String ROBOT_SETTING_TTS_LANG = "robot_setting_tts_lang";
    public static final String ROBOT_SETTING_BAD_NETWORK_INT = "robot_setting_bad_network";
    public static final String ROBOT_SETTING_MULTI_MODEL_INT = "robot_setting_multi_model";
    public static final String ROBOT_SETTING_VAD_END_INT = "robot_setting_vad_end";
    public static final String ROBOT_SHIPPING_MODE = "robot_setting_shipping_mode";
    public static final String ROBOT_SMALL_ACTION = "robot_samll_action";
    public static final String ROBOT_OBSTACLES_AVOID = "robot_obstacles_avoid";
    public static final String ROBOT_CHECK_CLIFF = "robot_check_cliff";
    public static final String ROBOT_SOUND_TYPE = "robot_sound_type";
    public static final String ROBOT_SETTING_ORION_FACTORY_MMI = "com.android.orionfactorymmi";
    public static final String ROBOT_SETTING_RUNNING_TEST = "com.android.runningtest";
    public static final String ROBOT_SETTING_CRUISE_LINEAR_SPEED = "robot_setting_cruise_linear_speed";
    public static final String ROBOT_SETTING_NAV_LINEAR_SPEED = "robot_setting_nav_linear_speed";
    public static final String ROBOT_SETTING_LEAD_LINEAR_SPEED = "robot_setting_lead_linear_speed";
    public static final String ROBOT_SETTING_GUIDE_LINEAR_SPEED = "robot_setting_guide_linear_speed";
    public static final String ROBOT_SETTING_GREET_LINEAR_SPEED = "robot_setting_greet_linear_speed";
    public static final String ROBOT_SETTING_CRUISE_ANGULAR_SPEED = "robot_setting_cruise_angular_speed";
    public static final String ROBOT_SETTING_NAV_ANGULAR_SPEED = "robot_setting_nav_angular_speed";
    public static final String ROBOT_SETTING_LEAD_ANGULAR_SPEED = "robot_setting_lead_angular_speed";
    public static final String ROBOT_SETTING_GUIDE_ANGULAR_SPEED = "robot_setting_guide_angular_speed";
    public static final String ROBOT_SETTING_GREET_ANGULAR_SPEED = "robot_setting_greet_angular_speed";
    public static final float ROBOT_SETTING_DEFAULT_LINEAR_SPEED = 0.7f;
    public static final float ROBOT_SETTING_DEFAULT_ANGULAR_SPEED = 1.2f;
    public static final float ROBOT_SETTING_DEFAULT_GREET_LINEAR_SPEED = 0.3f;
    public static final double ROBOT_SETTING_FOLLOW_DISTANCE_TO_PERSON = 1.0;
    public static final double ROBOT_SETTING_FOLLOW_DISTANCE_TO_PERSON_MIN = 0.6;
    public static final float ROBOT_SETTING_DEFAULT_FOLLOW_LINEAR_SPEED = 1.0f;
    public static final float ROBOT_SETTING_DEFAULT_FOLLOW_ANGULAR_SPEED = 1.2f;
    public static final String ROBOT_SETTING_CHARGING_ENVIRONMENT = "robot_settings_charging_environment";
    public static final String ROBOT_SETTING_WAITING_TIME = "robot_setting_waiting_time";
    public static final String ROBOT_SETTING_AUTO_BACK_RECEPTION = "robot_auto_back_reception";
    public static final String ROBOT_SETTING_SITU_SERVICE_STATUS = "robot_setting_situ_service_status";
    public static final String ROBOT_SETTING_CURRENT_CHARACTER = "robot_setting_current_character";
    public static final String ROBOT_SETTING_OPK_INFO = "robot_setting_opk_info";
    public static final String ROBOT_SETTING_OPK_INSTALL_LIST = "robot_setting_opk_install_list";
    public static final String ROBOT_SETTING_SYSTEM_ENV = "robot_setting_system_environment";
    public static final String ROBOT_SETTINGS_OTA_INSTALLING_OS = "ota_installing_os";
    public static final String ROBOT_SETTING_PLATFORM_NAME = "robot_setting_platform_name";
    public static final String ROBOT_PREVENT_COLLISION = "robot_prevent_collision";
    public static final String ROBOT_SETTING_INSPECTION_RESULT = "robot_setting_inspection_result";
    public static final String ROBOT_SETTING_CHASSIS_MULTI_ID = "robot_setting_chassis_multi_id";
    public static final String ROBOT_SETTING_INSPECT_FAIL_AUTO_REBOOT = "robot_setting_inspect_fail_auto_reboot";

    public static Uri getUriFor(String name) {
        return SettingsUtil.getUriFor(CONTENT_URI, name);
    }

    private static Uri getUriFor(Uri contentUri, String name) {
        return Uri.withAppendedPath((Uri)contentUri, (String)name);
    }

    public static boolean putInt(Context context, String name, int value) {
        boolean result = false;
        if (!SettingsUtil.checkPermission(context)) {
            Log.e((String)TAG, (String)"Permission deny");
            return result;
        }
        try {
            result = Settings.Global.putInt((ContentResolver)context.getContentResolver(), (String)name, (int)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static int getInt(Context context, String name) throws Settings.SettingNotFoundException {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)name);
    }

    public static int getInt(Context context, String name, int def) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)name, (int)def);
    }

    public static boolean putLong(Context context, String name, long value) {
        boolean result = false;
        if (!SettingsUtil.checkPermission(context)) {
            Log.e((String)TAG, (String)"Permission deny");
            return result;
        }
        try {
            result = Settings.Global.putLong((ContentResolver)context.getContentResolver(), (String)name, (long)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static long getLong(Context context, String name) throws Settings.SettingNotFoundException {
        return Settings.Global.getLong((ContentResolver)context.getContentResolver(), (String)name);
    }

    public static long getLong(Context context, String name, long def) {
        return Settings.Global.getLong((ContentResolver)context.getContentResolver(), (String)name, (long)def);
    }

    public static boolean putFloat(Context context, String name, float value) {
        boolean result = false;
        if (!SettingsUtil.checkPermission(context)) {
            Log.e((String)TAG, (String)"Permission deny");
            return result;
        }
        try {
            result = Settings.Global.putFloat((ContentResolver)context.getContentResolver(), (String)name, (float)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static float getFloat(Context context, String name) throws Settings.SettingNotFoundException {
        return Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)name);
    }

    public static float getFloat(Context context, String name, float def) {
        return Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)name, (float)def);
    }

    public static boolean putString(Context context, String name, String value) {
        boolean result = false;
        if (!SettingsUtil.checkPermission(context)) {
            Log.e((String)TAG, (String)"Permission deny");
            return result;
        }
        try {
            result = Settings.Global.putString((ContentResolver)context.getContentResolver(), (String)name, (String)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static String getString(Context context, String name) {
        return Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)name);
    }

    private static boolean checkPermission(Context context) {
        return ACCEPT_PACKAGE_LIST.contains(context.getPackageName());
    }

    public static void registerSettingsListener(Context context, List<String> nameList, SettingsListener settingsListener) {
        Iterator<String> iterator = nameList.iterator();
        while (iterator.hasNext()) {
            SettingsUtil.registerSettingsListener(context, iterator.next(), settingsListener);
        }
    }

    public static void registerSettingsListener(Context context, String name, SettingsListener settingsListener) {
        myContentObserver = new MyContentObserver(settingsListener);
        context.getContentResolver().registerContentObserver(SettingsUtil.getUriFor(name), true, (ContentObserver)myContentObserver);
    }

    public static void unregisterSettingsListener(Context context) {
        if (myContentObserver != null) {
            context.getContentResolver().unregisterContentObserver((ContentObserver)myContentObserver);
        }
    }

    private static class MyContentObserver
    extends ContentObserver {
        private final SettingsListener settingsListener;

        public MyContentObserver(SettingsListener settingsListener) {
            super(new Handler());
            this.settingsListener = settingsListener;
        }

        public void onChange(boolean selfChange, Uri uri) {
            String name = uri.getLastPathSegment();
            this.settingsListener.onChange(selfChange, name);
            Log.d((String)TAG, (String)("CoreService SettingUtil onChange:" + name + " changed"));
        }
    }

    public static interface SettingsListener {
        public void onChange(boolean var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RobotSettingKey {
    }
}

