/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.ApplicationWrapper;
import com.ainirobot.coreservice.client.exception.InvalidArgumentException;
import com.ainirobot.coreservice.client.exception.NoSuchKeyException;
import com.ainirobot.coreservice.client.exception.ValueFormatException;
import com.ainirobot.coreservice.client.listener.CommandListener;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RobotSettings {
    private static final String TAG = RobotSettings.class.getSimpleName();
    public static final String SETTINGS_GLOBAL_ROBOT_PROFILE = "robot_profile";
    public static final String SETTINGS_GLOBAL_ROBOT_UUID = "robot_uuid";
    public static final String SETTINGS_GLOBAL_ROBOT_NAME = "robot_name";
    public static final String SETTINGS_GLOBAL_ROBOT_VERSION = "robot_version";
    public static final String SETTINGS_GLOBAL_ROBOT_MODEL = "robot_model";
    public static final String SETTINGS_GLOBAL_CORP_UUID = "corp_uuid";
    public static final String SETTINGS_GLOBAL_CORP_NAME = "corp_name";
    public static final String SETTINGS_GLOBAL_CORP_SCENARIO = "corp_scenario";
    public static final String SETTINGS_GLOBAL_CROP_CONTACTS_MOBILE = "crop_contacts_mobile";
    public static final String SETTINGS_GLOBAL_ROBOT_MODE = "robot_mode";
    public static final String SETTINGS_GLOBAL_ROBOT_SAMPLE = "robot_sample";
    public static final String SETTINGS_GLOBAL_ROBOT_COORDINATE = "robot_coordinate";
    public static final String SETTINGS_GLOBAL_VOICE_CLIENT_ID = "voice_client_id";
    public static final String SETTINGS_GLOBAL_VOICE_CORP_ID = "voice_corp_id";
    public static final String SETTINGS_GLOBAL_VOICE_GROUP_ID = "voice_group_id";
    public static final String SETTINGS_GLOBAL_GUIDE_WAIT = "guide_wait";
    public static final String SETTINGS_GLOBAL_NEED_VOICE_REPORT = "voice_report";
    public static final String SETTINGS_GLOBAL_NEED_SAY_HELLO = "need_say_hello";
    public static final String SETTINGS_GLOBAL_ENBALE_RGBD = "rgbd";
    public static final String SETTINGS_GLOBAL_ENABLE_RGBD_AVOID_OBS = "rgbd_avoid_obs";
    public static final String SETTINGS_GLOBAL_CHAT_TTS_PREVENT_BREAK = "chat_tts_prevent_break";
    public static final String SETTINGS_GLOBAL_INTERACTION_MODE = "interaction_mode";
    public static final String SETTINGS_BREAK_SPEED_THRESHOLD = "break_speed_threshold";
    private static final String SERIAL_NUM_KEY_ROBOT = "ro.serialno.robot";
    private static final String SERIAL_NUM_KEY_ROBOT_9 = "ro.robot.serialno";
    private static final String QUALCOMMSN_KEY_ROBOT = "devid.qualcommSN";
    private static final String SERIAL_NUM_KEY_CHIPSET = "ro.serialno";
    private static final String SERIAL_NUM_ERR_CONST = "Error";
    private static final String ROBOT_MODEL_NAME = "Meissa";
    private static final String SERIALNO_KEY_PRODUCTMODEL = "ro.product.model";
    private static final String ROBOT_BRAND_NAME = "Orion";
    private static final String SERIALNO_KEY_PRODUCTBRAND = "ro.product.brand";
    private static final String AUTO_TIME_ZONE = "auto_time_zone";
    private static final String SERIALNO_KEY_PRODUCTNAME = "ro.product.name";
    private static final String SERIALNO_KEY_PRODUCTVERSION = "ro.product.version";
    private static final String SERIALNO_KEY_RELEASENUM = "ro.product.releasenum";
    private static final String PROPERTY_ORIONSTAR_VERSION = "ro.product.orionstaros";
    private static final String AUDIO_APM_VERSION = "sys.audio.apm.version";
    private static final String AUDIO_ELEVOC_VERSION = "sys.audio.elevoc.version";
    private static final String AUTHORITY = "com.ainirobot.coreservice.robotsettingprovider";
    private static final Uri CONTENT_URI = Uri.parse((String)"content://com.ainirobot.coreservice.robotsettingprovider/setting");
    private static Map<RobotSettingListener, List<String>> mListenerAndKeysMap = new ConcurrentHashMap<RobotSettingListener, List<String>>();
    public static final String ROBOT_LOW_POWER_LEVEL = "robot_settings_battery_low_level";
    private static final String CORE_SERVICE = "com.ainirobot.coreservice";
    private static final String HOME = "com.ainirobot.home";
    private static final String FIRST_CONFIG = "com.ainirobot.firstconfig";
    private static final String MODULE_APP = "com.ainirobot.moduleapp";
    private static final String MAP_TOOL = "com.ainirobot.maptool";
    private static final List<String> ACCEPT_PACKAGE_LIST = Collections.unmodifiableList(Arrays.asList("com.ainirobot.coreservice", "com.ainirobot.home", "com.ainirobot.firstconfig", "com.ainirobot.moduleapp", "com.ainirobot.maptool"));
    static ContentObserver observer = new ContentObserver(null){

        public void onChange(boolean selfChange, Uri uri) {
            String key = uri.getLastPathSegment();
            Log.d((String)TAG, (String)("robots settings changed uri:" + uri + ", key: " + key));
            for (RobotSettingListener listener : mListenerAndKeysMap.keySet()) {
                List keyList = (List)mListenerAndKeysMap.get(listener);
                if (keyList == null || !keyList.contains(key)) continue;
                listener.onRobotSettingChanged(key);
            }
        }
    };

    static int getSystemSn(CommandListener listener) {
        boolean isSuccess;
        String serialNum = RobotSettings.getSystemSn();
        boolean bl = isSuccess = !TextUtils.isEmpty((CharSequence)serialNum);
        if (listener != null) {
            listener.onResult(isSuccess ? 1 : 2, serialNum);
            listener.onResult(isSuccess ? 1 : 2, serialNum, "");
        }
        return isSuccess ? 1 : -1;
    }

    public static String getSystemSn() {
        String serialNum;
        if (Build.VERSION.SDK_INT < 26) {
            serialNum = RobotSettings.getSystemProperties(SERIAL_NUM_KEY_ROBOT, "");
            if (TextUtils.isEmpty((CharSequence)serialNum) || serialNum.startsWith(SERIAL_NUM_ERR_CONST)) {
                serialNum = RobotSettings.getSystemProperties(SERIAL_NUM_KEY_CHIPSET, "");
            }
        } else {
            serialNum = RobotSettings.getSystemProperties(SERIAL_NUM_KEY_ROBOT_9, "");
            if (TextUtils.isEmpty((CharSequence)serialNum) || serialNum.startsWith(SERIAL_NUM_ERR_CONST)) {
                serialNum = Build.SERIAL;
            }
        }
        return serialNum;
    }

    public static String getProductModel() {
        return RobotSettings.getSystemProperties(SERIALNO_KEY_PRODUCTMODEL, ROBOT_MODEL_NAME);
    }

    public static String getBrand() {
        return RobotSettings.getSystemProperties(SERIALNO_KEY_PRODUCTBRAND, ROBOT_BRAND_NAME);
    }

    public static String getPlatform() {
        return RobotSettings.getSystemProperties(SERIALNO_KEY_PRODUCTNAME, "");
    }

    public static String getRomVersion() {
        String v = RobotSettings.getSystemProperties(SERIALNO_KEY_PRODUCTVERSION, "");
        if (!TextUtils.isEmpty((CharSequence)v)) {
            return v;
        }
        return "";
    }

    public static String getSysTimeZone() {
        return RobotSettings.getSystemProperties("persist.sys.timezone", "Asia/Shanghai");
    }

    public static String getAndroidVersion() {
        switch (Build.VERSION.SDK_INT) {
            case 19: 
            case 20: {
                return "Android 4.0";
            }
            case 21: 
            case 22: {
                return "Android 5.0";
            }
            case 23: {
                return "Android 6.0";
            }
            case 24: 
            case 25: {
                return "Android 7.0";
            }
        }
        return "Android XX";
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIMEI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getDeviceId() : null;
    }

    public static String getVersion() {
        return RobotSettings.getSystemProperties(SERIALNO_KEY_RELEASENUM, "1.100.0");
    }

    public static String getOrionStarPropertyVersion() {
        return RobotSettings.getSystemProperties(PROPERTY_ORIONSTAR_VERSION, "6.8");
    }

    public static String getQualcommSn() {
        return RobotSettings.getSystemProperties(QUALCOMMSN_KEY_ROBOT, "");
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getSystemProperties(String key, String defaultVal) {
        try {
            Method systemPropertiesGet = Class.forName("android.os.SystemProperties").getMethod("get", String.class);
            String ret = (String)systemPropertiesGet.invoke(null, key);
            if (ret != null) {
                return TextUtils.isEmpty((CharSequence)ret) ? defaultVal : ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultVal;
    }

    public static String getRobotUUID(Context ctx) {
        return RobotSettings.getGlobalSettings(ctx, SETTINGS_GLOBAL_ROBOT_UUID, "");
    }

    public static void putRobotUUID(Context ctx, String ruuid) {
        RobotSettings.storage2SystemSettings(ctx, SETTINGS_GLOBAL_ROBOT_UUID, ruuid);
    }

    public static void cleanRobotUUID(Context ctx) {
        RobotSettings.storage2SystemSettings(ctx, SETTINGS_GLOBAL_ROBOT_UUID, "");
    }

    public static String getRobotName(Context ctx) {
        return RobotSettings.getGlobalSettings(ctx, SETTINGS_GLOBAL_ROBOT_NAME, "");
    }

    public static String getCorpUUID(Context ctx) {
        return RobotSettings.getGlobalSettings(ctx, SETTINGS_GLOBAL_CORP_UUID, "");
    }

    public static String getVoiceCorpId(Context ctx) {
        return RobotSettings.getGlobalSettings(ctx, SETTINGS_GLOBAL_VOICE_CORP_ID, "");
    }

    public static void cleanCorpUUID(Context ctx) {
        RobotSettings.storage2SystemSettings(ctx, SETTINGS_GLOBAL_CORP_UUID, "");
    }

    public static String getCorpName(Context ctx) {
        return RobotSettings.getGlobalSettings(ctx, SETTINGS_GLOBAL_CORP_NAME, "");
    }

    public static String getApmVersion() {
        return RobotSettings.getSystemProperties(AUDIO_APM_VERSION, "apm");
    }

    public static String getElevocVersion() {
        return RobotSettings.getSystemProperties(AUDIO_ELEVOC_VERSION, "elevoc");
    }

    public static String getProfile(Context ctx) {
        return RobotSettings.getGlobalSettings(ctx, SETTINGS_GLOBAL_ROBOT_PROFILE, "");
    }

    public static void setProfile(Context ctx, String profile) {
        RobotSettings.storage2SystemSettings(ctx, SETTINGS_GLOBAL_ROBOT_PROFILE, profile);
    }

    public static void closeAutoTimeZone(Context ctx) {
        Settings.Global.putInt((ContentResolver)ctx.getContentResolver(), (String)AUTO_TIME_ZONE, (int)0);
    }

    public static void openAutoTiemZone(Context ctx) {
        Settings.Global.putInt((ContentResolver)ctx.getContentResolver(), (String)AUTO_TIME_ZONE, (int)1);
    }

    public static String getGlobalSettings(Context ctx, String key, String defValue) {
        String global = defValue;
        if (TextUtils.isEmpty((CharSequence)key) || null == ctx) {
            return global;
        }
        global = Settings.Global.getString((ContentResolver)ctx.getContentResolver(), (String)key);
        if (TextUtils.isEmpty((CharSequence)global)) {
            global = defValue;
        }
        return global;
    }

    public static void storage2SystemSettings(Context ctx, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || null == ctx) {
            Log.w((String)TAG, (String)"can't put system.settings a empty key or null context!");
            return;
        }
        int writePerm = ctx.checkCallingOrSelfPermission("android.permission.WRITE_SETTINGS");
        int writeSecurePerm = ctx.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS");
        if (0 != writePerm || 0 != writeSecurePerm) {
            Log.e((String)TAG, (String)"This app have no WRITE_SETTINGS or WRITE_SECURE_SETTINGS permission!");
            return;
        }
        if (!Settings.Global.putString((ContentResolver)ctx.getContentResolver(), (String)key, (String)value)) {
            Log.w((String)TAG, (String)("Settings.Global put error! key: " + key + ", value: " + value));
        }
    }

    public static int getRobotInt(Context context, String key) throws InvalidArgumentException, NoSuchKeyException, ValueFormatException {
        String value = RobotSettings.getRobotString(context, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(value);
        }
    }

    public static float getRobotFloat(Context context, String key) throws InvalidArgumentException, NoSuchKeyException, ValueFormatException {
        String value = RobotSettings.getRobotString(context, key);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(value);
        }
    }

    public static String getRobotString(Context context, String key) throws InvalidArgumentException, NoSuchKeyException {
        if (context == null) {
            throw new InvalidArgumentException("context null");
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new InvalidArgumentException("key null");
        }
        Cursor cursor = context.getContentResolver().query(CONTENT_URI, null, "id=?", new String[]{key}, null);
        if (cursor != null && cursor.moveToNext()) {
            String value = cursor.getString(cursor.getColumnIndex("value"));
            cursor.close();
            return value;
        }
        throw new NoSuchKeyException("not support");
    }

    public static boolean setRobotInt(Context context, String key, int value) throws InvalidArgumentException {
        return RobotSettings.setRobotString(context, key, String.valueOf(value));
    }

    public static boolean setRobotFloat(Context context, String key, float value) throws InvalidArgumentException {
        return RobotSettings.setRobotString(context, key, String.valueOf(value));
    }

    public static boolean setRobotString(Context context, String key, String value) throws InvalidArgumentException {
        if (context == null) {
            throw new InvalidArgumentException("context null");
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new InvalidArgumentException("key null");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("value", value);
        int rows = context.getContentResolver().update(CONTENT_URI, contentValues, "id=?", new String[]{key});
        return rows > 0;
    }

    public static void registerRobotSettingListener(Context context, RobotSettingListener listener, String ... key) throws InvalidArgumentException {
        if (context == null) {
            throw new InvalidArgumentException("context null");
        }
        if (null == listener) {
            throw new InvalidArgumentException("listener null");
        }
        if (key.length <= 0) {
            throw new InvalidArgumentException("key must has one at least");
        }
        ArrayList<String> keyList = new ArrayList<String>(Arrays.asList(key));
        if (keyList.size() <= 0) {
            throw new InvalidArgumentException("key must has one at least");
        }
        RobotSettings.addListener(context, listener, keyList);
    }

    public static void unRegisterRobotSettingListener(Context context, RobotSettingListener listener) throws InvalidArgumentException {
        if (context == null) {
            throw new InvalidArgumentException("context null");
        }
        if (null == listener) {
            throw new InvalidArgumentException("listener null");
        }
        RobotSettings.removeListener(context, listener);
    }

    private static void addListener(Context context, RobotSettingListener listener, List<String> keyList) {
        Log.d((String)TAG, (String)("robots settings add listener:" + listener.toString() + ", size: " + mListenerAndKeysMap.size()));
        if (mListenerAndKeysMap.size() <= 0) {
            context.getContentResolver().registerContentObserver(CONTENT_URI, true, observer);
        }
        mListenerAndKeysMap.put(listener, keyList);
    }

    private static void removeListener(Context context, RobotSettingListener listener) {
        Log.d((String)TAG, (String)("robots settings remove listener:" + listener.toString() + ", size: " + mListenerAndKeysMap.size()));
        mListenerAndKeysMap.remove(listener);
        if (mListenerAndKeysMap.size() <= 0) {
            context.getContentResolver().unregisterContentObserver(observer);
        }
    }

    public static boolean putGlobalInt(Context context, String name, int value) {
        boolean result = false;
        if (!RobotSettings.checkPermission(context)) {
            Log.e((String)TAG, (String)"Permission deny");
            return result;
        }
        try {
            result = Settings.Global.putInt((ContentResolver)context.getContentResolver(), (String)name, (int)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private static boolean checkPermission(Context context) {
        return ACCEPT_PACKAGE_LIST.contains(context.getPackageName());
    }

    public static int getGlobalInt(Context context, String key, int defaultValue) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)key, (int)defaultValue);
    }

    private static Uri getGlobalUriFor(String key) {
        return Settings.Global.getUriFor((String)key);
    }

    public static void registerGlobalContentObserver(String key, ContentObserver observer) {
        ApplicationWrapper.getContext().getContentResolver().registerContentObserver(RobotSettings.getGlobalUriFor(key), false, observer);
    }

    public static void unregisterGlobalContentObserver(ContentObserver observer) {
        ApplicationWrapper.getContext().getContentResolver().unregisterContentObserver(observer);
    }
}

