/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.OrionBase;
import com.ainirobot.coreservice.IModuleRegistry;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.bean.LoadMapBean;
import com.ainirobot.coreservice.bean.Task;
import com.ainirobot.coreservice.client.ApiListener;
import com.ainirobot.coreservice.client.BaseApi;
import com.ainirobot.coreservice.client.Definition;
import com.ainirobot.coreservice.client.IntentUtil;
import com.ainirobot.coreservice.client.ProductInfo;
import com.ainirobot.coreservice.client.RobotApiReport;
import com.ainirobot.coreservice.client.RobotSettings;
import com.ainirobot.coreservice.client.StatusListener;
import com.ainirobot.coreservice.client.TaskEventProxy;
import com.ainirobot.coreservice.client.TaskProxy;
import com.ainirobot.coreservice.client.account.AccountApi;
import com.ainirobot.coreservice.client.actionbean.AngleResetBean;
import com.ainirobot.coreservice.client.actionbean.AutoChargeBean;
import com.ainirobot.coreservice.client.actionbean.BodyFollowBean;
import com.ainirobot.coreservice.client.actionbean.CheckObstacleBean;
import com.ainirobot.coreservice.client.actionbean.CommandBean;
import com.ainirobot.coreservice.client.actionbean.CruiseParams;
import com.ainirobot.coreservice.client.actionbean.CruiseRouteBean;
import com.ainirobot.coreservice.client.actionbean.FaceTrackBean;
import com.ainirobot.coreservice.client.actionbean.FocusFollowBean;
import com.ainirobot.coreservice.client.actionbean.GoPositionBean;
import com.ainirobot.coreservice.client.actionbean.GongFuBean;
import com.ainirobot.coreservice.client.actionbean.HeadTurnBean;
import com.ainirobot.coreservice.client.actionbean.InspectActionBean;
import com.ainirobot.coreservice.client.actionbean.LeadingParams;
import com.ainirobot.coreservice.client.actionbean.LedLightBean;
import com.ainirobot.coreservice.client.actionbean.NaviCmdTimeOutBean;
import com.ainirobot.coreservice.client.actionbean.NavigationAdvancedBean;
import com.ainirobot.coreservice.client.actionbean.NavigationBean;
import com.ainirobot.coreservice.client.actionbean.PictureInfo;
import com.ainirobot.coreservice.client.actionbean.PlaceBean;
import com.ainirobot.coreservice.client.actionbean.Pose;
import com.ainirobot.coreservice.client.actionbean.PushReportBean;
import com.ainirobot.coreservice.client.actionbean.RegisterBean;
import com.ainirobot.coreservice.client.actionbean.ResetEstimateParams;
import com.ainirobot.coreservice.client.actionbean.RobotStandbyBean;
import com.ainirobot.coreservice.client.actionbean.SearchPersonBean;
import com.ainirobot.coreservice.client.actionbean.StartCreateMapBean;
import com.ainirobot.coreservice.client.actionbean.StopCreateMapBean;
import com.ainirobot.coreservice.client.actionbean.UnRegisterBean;
import com.ainirobot.coreservice.client.actionbean.WakeUpBean;
import com.ainirobot.coreservice.client.ashmem.ShareMemoryApi;
import com.ainirobot.coreservice.client.listener.ActionListener;
import com.ainirobot.coreservice.client.listener.CommandListener;
import com.ainirobot.coreservice.client.listener.Person;
import com.ainirobot.coreservice.client.listener.PersonInfoListener;
import com.ainirobot.coreservice.client.log.RLog;
import com.ainirobot.coreservice.client.messagedispatcher.ActionDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.StatusDispatcher;
import com.ainirobot.coreservice.client.module.ModuleCallbackApi;
import com.ainirobot.coreservice.client.permission.PermissionApi;
import com.ainirobot.coreservice.client.person.PersonApi;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingApi;
import com.ainirobot.coreservice.client.surfaceshare.SurfaceShareApi;
import com.ainirobot.coreservice.utils.SettingDataHelper;
import com.ainirobot.coreservice.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RobotApi
extends BaseApi {
    private static final String TAG = "RobotApi";
    public static final int ERROR_REMOTE_VISITOR = -101;
    private static final String DETECT_BODY = "body";
    private static final String DETECT_FACE = "face";
    private static final String DETECT = "detect";
    private static final String FILE_BACK = "file_back";
    private static RobotApi instance = new RobotApi();
    private IModuleRegistry mModuleRegistry = null;
    private ModuleCallbackApi mCallback;
    private static Gson mGson = new Gson();
    private final ArrayList<PersonInfoListener> mAllPersonInfoListener = new ArrayList();
    private ActionListener mPersonListener;
    private ApiListener apiListener = null;
    private String pkgName = null;
    private HandlerThread mResponseThread;
    protected ServiceConnection apiConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            RobotApi.this.mRobotBinderPool = IRobotBinderPool.Stub.asInterface(service);
            try {
                if (SettingDataHelper.getInstance().getRobotInt("current_pkg_acl") == 1) {
                    RobotApi.this.mModuleRegistry = IModuleRegistry.Stub.asInterface(RobotApi.this.mRobotBinderPool.queryBinder(13, RobotApi.this.ctx.getPackageName()));
                } else {
                    RobotApi.this.mModuleRegistry = IModuleRegistry.Stub.asInterface(RobotApi.this.mRobotBinderPool.queryBinder(1, RobotApi.this.ctx.getPackageName()));
                }
                RobotApi.this.mIsServiceConnected = true;
                RobotApi.this.notifyEventApiConnected();
                RobotApiReport rap = new RobotApiReport(RobotApi.this.isApiConnectedService());
                rap.action("connectServer").report();
                if (RobotApi.this.mCallback != null) {
                    RobotApi.this.setCallback(RobotApi.this.mCallback);
                }
            }
            catch (RemoteException | NullPointerException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            RobotApi.this.mIsServiceConnected = false;
            RobotApi.this.notifyEventApiDisconnected();
            RobotApi.this.mModuleRegistry = null;
        }
    };

    private RobotApi() {
        this.mSubApiList.add(PersonApi.getInstance());
        this.mSubApiList.add(RobotSettingApi.getInstance());
        this.mSubApiList.add(AccountApi.getInstance());
        this.mSubApiList.add(PermissionApi.getInstance());
        this.mSubApiList.add(SurfaceShareApi.getInstance());
        this.mSubApiList.add(ShareMemoryApi.getInstance());
    }

    @Override
    public boolean isApiConnectedService() {
        return super.isApiConnectedService();
    }

    public static RobotApi getInstance() {
        if (instance == null) {
            instance = new RobotApi();
        }
        return instance;
    }

    public void startAuthorization(Context ctx, @NonNull String packageName, String appId) {
        SettingDataHelper.getInstance().setContext(ctx);
        RobotApiReport.setBaseInfo(packageName, ctx.getApplicationInfo().processName);
        if (!packageName.equals(this.pkgName)) {
            SettingDataHelper.getInstance().setCurrentApp(packageName);
            this.pkgName = packageName;
        }
        String signMd5 = Utils.getPackageSign(ctx, packageName);
        SettingDataHelper.getInstance().setAuthInfo(packageName, signMd5, appId);
    }

    public boolean queryAuthorizationResult() {
        return SettingDataHelper.getInstance().getRobotInt("current_pkg_acl") == 1;
    }

    public void connectServer(Context ctx, ApiListener listener) {
        this.apiListener = listener;
        this.ctx = ctx;
        RobotApiReport.setBaseInfo(ctx.getPackageName(), ctx.getApplicationInfo().processName);
        SettingDataHelper.getInstance().setContext(ctx);
        String zone = SettingDataHelper.getInstance().getCloudServerZone();
        Log.d((String)TAG, (String)("RobotApi connectServer zone: " + zone));
        OrionBase.setDomainEnv(ProductInfo.isOverSea(), zone, RobotSettingApi.getInstance().getRobotInt("robot_setting_system_environment") == 1);
        OrionBase.start(ctx, null);
        RLog.initRLog(ctx);
        RobotApiReport rap = new RobotApiReport(this.isApiConnectedService());
        rap.action("connectServer").report();
        this.addApiEventListener(listener);
        Intent intent = IntentUtil.createExplicitIntent("com.ainirobot.coreservice.service.CoreService", IRobotBinderPool.class.getName());
        intent.putExtra("client_package_name", ctx.getPackageName());
        ctx.bindService(intent, this.apiConnection, 1);
    }

    @Override
    public void disconnectApi() {
        try {
            boolean isRemove = this.removeApiEventListener(this.apiListener);
            Log.d((String)TAG, (String)("disconnectApi removeApiEventListener : " + isRemove));
            if (this.ctx != null) {
                Log.d((String)TAG, (String)"unbindService apiConnection ");
                this.ctx.unbindService(this.apiConnection);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setCallback(ModuleCallbackApi callback) {
        if (this.mModuleRegistry == null) {
            this.mCallback = callback;
            return;
        }
        try {
            this.mModuleRegistry.setCallback(callback);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isActive() {
        if (this.mModuleRegistry != null) {
            try {
                return this.mModuleRegistry.isActive();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void disableEmergency() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"Disable emergency failed, mModuleRegistry is null");
                return;
            }
            RobotApiReport rap = new RobotApiReport(this.isApiConnectedService());
            rap.action("disableEmergency").report();
            this.mModuleRegistry.disableEmergency();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void enableEmergency() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"enable emergency failed, mModuleRegistry is null");
                return;
            }
            RobotApiReport rap = new RobotApiReport(this.isApiConnectedService());
            rap.action("enableEmergency").report();
            this.mModuleRegistry.enableEmergency();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void disableBattery() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"Disable battery failed, mModuleRegistry is null");
                return;
            }
            RobotApiReport rap = new RobotApiReport(this.isApiConnectedService());
            rap.action("disableBattery").report();
            this.mModuleRegistry.disableBattery();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void enableBattery() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"Disable battery failed, mModuleRegistry is null");
                return;
            }
            RobotApiReport rap = new RobotApiReport(this.isApiConnectedService());
            rap.action("enableBattery").report();
            this.mModuleRegistry.enableBattery();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void resetSystemStatus() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"Reset system status failed, mModuleRegistry is null");
                return;
            }
            this.mModuleRegistry.resetSystemStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int startPlayAction(int reqId, GongFuBean params, ActionListener listener) {
        if (params == null) {
            return -1;
        }
        params.setReqId(reqId);
        String jsonStr = mGson.toJson((Object)params);
        return this.startAction(reqId, 27, jsonStr, listener);
    }

    public int stopPlayAction(int reqId) {
        return this.stopAction(reqId, 27, true);
    }

    public int startHeadAction(int reqId, GongFuBean params, ActionListener listener) {
        if (params == null) {
            return -1;
        }
        params.setReqId(reqId);
        String jsonStr = mGson.toJson((Object)params);
        return this.startAction(reqId, 324, jsonStr, listener);
    }

    public int stopHeadAction(int reqId) {
        return this.stopAction(reqId, 324, true);
    }

    public int startLead(int reqId, LeadingParams params, ActionListener listener) {
        if (params == null) {
            return -1;
        }
        params.setReqId(reqId);
        String jsonStr = mGson.toJson((Object)params);
        return this.startAction(reqId, 12, jsonStr, listener);
    }

    public int stopLead(int reqId, boolean isResetHW) {
        return this.stopAction(reqId, 12, isResetHW);
    }

    public int startBodyFollowAction(int reqId, int personId, ActionListener listener) {
        return this.startBodyFollowAction(reqId, personId, 0L, 0L, 0.7f, 1.2f, 1.0, listener);
    }

    public int startBodyFollowAction(int reqId, int personId, long lostTimer, long trackTimer, double linearSpeed, double angularSpeed, double distancePerson, ActionListener listener) {
        BodyFollowBean bean = new BodyFollowBean();
        bean.setReqId(reqId);
        bean.setPersonID(personId);
        bean.setLostTime(lostTimer);
        bean.setSetTrackTime(trackTimer);
        bean.setLinearSpeed(linearSpeed);
        bean.setAngularSpeed(angularSpeed);
        bean.setDistanceR2P(distancePerson);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 35, jsonStr, listener);
    }

    public int stopBodyFollowAction(int reqId) {
        return this.stopAction(reqId, 35, true);
    }

    @Deprecated
    public int startFocusFollow(int reqId, int personId, long lostTimer, float maxDistance, ActionListener listener) {
        return this.startFocusFollow(reqId, personId, lostTimer, maxDistance, true, listener);
    }

    @Deprecated
    public int startFocusFollow(int reqId, int personId, long lostTimer, float maxDistance, boolean isAllowMoveBody, ActionListener listener) {
        FocusFollowBean bean = new FocusFollowBean();
        bean.setReqId(reqId);
        bean.setPersonId(personId);
        bean.setLostTimer(lostTimer);
        bean.setMaxDistance(maxDistance);
        bean.setAllowMoveBody(isAllowMoveBody);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 17, jsonStr, listener);
    }

    @Deprecated
    public int stopFocusFollow(int reqId) {
        return this.stopAction(reqId, 17, false);
    }

    @Deprecated
    public int stopFocusFollow(int reqId, boolean isResetHW) {
        return this.stopAction(reqId, 17, isResetHW);
    }

    public int startFaceTrack(int reqId, FaceTrackBean bean, ActionListener listener) {
        if (bean == null) {
            bean = new FaceTrackBean();
        }
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 43, jsonStr, listener);
    }

    public int stopFaceTrack(int reqId) {
        return this.stopAction(reqId, 43, false);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, (double)0.7f, (double)1.2f, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, false, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, 0.0, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, destinationRange, 0, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, destinationRange, wheelOverCurrentRetryCount, 0L, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, long multipleWaitTime, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, destinationRange, wheelOverCurrentRetryCount, multipleWaitTime, 0, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, long multipleWaitTime, int priority, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, destinationRange, wheelOverCurrentRetryCount, multipleWaitTime, 0, 0.0, 0.0, 0, 0, 0, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, long multipleWaitTime, int priority, int startModeLevel, int brakeModeLevel, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, destinationRange, wheelOverCurrentRetryCount, multipleWaitTime, 0, 0.0, 0.0, 0, startModeLevel, brakeModeLevel, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, long multipleWaitTime, int priority, double linearAcceleration, double angularAcceleration, int runStopCmdParam, ActionListener listener) {
        return this.startNavigation(reqId, destination, coordinateDeviation, time, linearSpeed, angularSpeed, isAdjustAngle, destinationRange, wheelOverCurrentRetryCount, multipleWaitTime, priority, linearAcceleration, angularAcceleration, runStopCmdParam, 0, 0, listener);
    }

    public int startNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, long multipleWaitTime, int priority, double linearAcceleration, double angularAcceleration, int runStopCmdParam, int startModeLevel, int brakeModeLevel, ActionListener listener) {
        NavigationBean bean = new NavigationBean();
        bean.setReqId(reqId);
        bean.setDestination(destination);
        bean.setTime(time);
        bean.setCoordinateDeviation(coordinateDeviation);
        bean.setLinearSpeed(linearSpeed);
        bean.setAngularSpeed(angularSpeed);
        bean.setAdjustAngle(isAdjustAngle);
        bean.setDestinationRange(destinationRange);
        bean.setWheelOverCurrentRetryCount(wheelOverCurrentRetryCount);
        bean.setMultipleWaitTime(multipleWaitTime);
        bean.setPriority(priority);
        bean.setLinearAcceleration(linearAcceleration);
        bean.setAngularAcceleration(angularAcceleration);
        bean.setRunStopCmdParam(runStopCmdParam);
        bean.setStartModeLevel(startModeLevel);
        bean.setBrakeModeLevel(brakeModeLevel);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 14, jsonStr, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, long time, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, false, time, (double)0.7f, 1.2f, 0, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, false, time, linearSpeed, angularSpeed, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, boolean isAdjustAngle, long time, double linearSpeed, double angularSpeed, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, isAdjustAngle, time, linearSpeed, angularSpeed, 0, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, boolean isAdjustAngle, long time, double linearSpeed, double angularSpeed, int wheelOverCurrentRetryCount, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, isAdjustAngle, time, linearSpeed, angularSpeed, wheelOverCurrentRetryCount, 0, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, boolean isAdjustAngle, long time, double linearSpeed, double angularSpeed, int wheelOverCurrentRetryCount, int priority, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, isAdjustAngle, time, linearSpeed, angularSpeed, wheelOverCurrentRetryCount, priority, 0.0, 0.0, 0, 0, 0, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, boolean isAdjustAngle, long time, double linearSpeed, double angularSpeed, int wheelOverCurrentRetryCount, int priority, int startModeLevel, int brakeModeLevel, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, isAdjustAngle, time, linearSpeed, angularSpeed, wheelOverCurrentRetryCount, priority, 0.0, 0.0, 0, startModeLevel, brakeModeLevel, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, boolean isAdjustAngle, long time, double linearSpeed, double angularSpeed, int wheelOverCurrentRetryCount, int priority, double linearAcceleration, double angularAcceleration, int runStopCmdParam, ActionListener listener) {
        return this.startNavigation(reqId, pose, coordinateDeviation, isAdjustAngle, time, linearSpeed, angularSpeed, wheelOverCurrentRetryCount, priority, linearAcceleration, angularAcceleration, runStopCmdParam, 0, 0, listener);
    }

    public int startNavigation(int reqId, Pose pose, double coordinateDeviation, boolean isAdjustAngle, long time, double linearSpeed, double angularSpeed, int wheelOverCurrentRetryCount, int priority, double linearAcceleration, double angularAcceleration, int runStopCmdParam, int startModeLevel, int brakeModeLevel, ActionListener listener) {
        GoPositionBean bean = new GoPositionBean();
        bean.setReqId(reqId);
        bean.setPose(pose);
        bean.setTime(time);
        bean.setCoordinateDeviation(coordinateDeviation);
        bean.setIsAdjustAngle(isAdjustAngle);
        bean.setLinearSpeed(linearSpeed);
        bean.setAngularSpeed(angularSpeed);
        bean.setWheelOverCurrentRetryCount(wheelOverCurrentRetryCount);
        bean.setPriority(priority);
        bean.setLinearAcceleration(linearAcceleration);
        bean.setAngularAcceleration(angularAcceleration);
        bean.setRunStopCmdParam(runStopCmdParam);
        bean.setStartModeLevel(startModeLevel);
        bean.setBrakeModeLevel(brakeModeLevel);
        return this.startAction(reqId, 34, mGson.toJson((Object)bean), listener);
    }

    public int startPoseNavigation(int reqId, String destination, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean needRotate, ActionListener listener) {
        NavigationBean bean = new NavigationBean();
        bean.setReqId(reqId);
        bean.setDestination(destination);
        bean.setTime(time);
        bean.setCoordinateDeviation(coordinateDeviation);
        bean.setLinearSpeed(linearSpeed);
        bean.setAngularSpeed(angularSpeed);
        bean.setmNeedRotate(needRotate);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 31, jsonStr, listener);
    }

    public int stopPoseNavigation(int reqId) {
        return this.stopAction(reqId, 31, true);
    }

    public int stopNavigation(int reqId) {
        this.stopAction(reqId, 34, true);
        return this.stopAction(reqId, 14, true, false);
    }

    public int stopNavigation(int reqId, boolean isCancelStopCommand) {
        this.stopAction(reqId, 34, true);
        return this.stopAction(reqId, 14, true, isCancelStopCommand);
    }

    public int startCruise(int reqId, List<Pose> route, int startPoint, List<Integer> dockingPoints, ActionListener listener) {
        return this.startCruise(reqId, route, startPoint, dockingPoints, 0.7f, 1.2f, listener);
    }

    public int startCruise(int reqId, List<Pose> route, int startPoint, List<Integer> dockingPoints, double linearSpeed, double angularSpeed, ActionListener listener) {
        return this.startCruise(reqId, route, startPoint, dockingPoints, linearSpeed, angularSpeed, 0L, listener);
    }

    public int startCruise(int reqId, List<Pose> route, int startPoint, List<Integer> dockingPoints, double linearSpeed, double angularSpeed, long multiTimeout, ActionListener listener) {
        CruiseParams params = new CruiseParams();
        params.setReqId(reqId);
        params.setDockingPoints(dockingPoints);
        params.setRoute(route);
        params.setStartPoint(startPoint);
        params.setLinearSpeed(linearSpeed);
        params.setAngularSpeed(angularSpeed);
        params.setMultipleWaitTime(multiTimeout);
        return this.startAction(reqId, 23, mGson.toJson((Object)params), listener);
    }

    public int stopCruise(int reqId) {
        return this.stopAction(reqId, 23, true);
    }

    public int startRegister(int reqId, @NonNull String personName, long timeout, int tryCount, long secondDelay, ActionListener listener) {
        Log.d((String)TAG, (String)("startRegister reqID : " + reqId + ", personName : " + personName));
        RegisterBean bean = new RegisterBean();
        bean.setReqId(reqId);
        bean.setPersonName(personName);
        bean.setTime(timeout);
        bean.setCount(tryCount);
        bean.setSecondDelay(secondDelay);
        bean.setRemoteType(1);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 15, jsonStr, listener);
    }

    public int startDetect(int reqId, long timeout, int tryCount, long secondDelay, ActionListener listener) {
        Log.d((String)TAG, (String)("startDetect reqId : " + reqId + ", timeout : " + timeout + ", tryCount : " + tryCount + ", secondDelay : " + secondDelay + ", ActionListener : " + listener));
        RegisterBean bean = new RegisterBean();
        bean.setReqId(reqId);
        bean.setPersonName("");
        bean.setTime(timeout);
        bean.setCount(tryCount);
        bean.setSecondDelay(secondDelay);
        bean.setRemoteType(2);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 15, jsonStr, listener);
    }

    public int stopRegister(int reqId) {
        return this.stopAction(reqId, 15, true);
    }

    public int startUnRegister(int reqId, String name, ActionListener listener) {
        UnRegisterBean bean = new UnRegisterBean();
        bean.setReqId(reqId);
        bean.setName(name);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 16, jsonStr, listener);
    }

    public int wakeUp(int reqId, float angle, ActionListener listener) {
        return this.wakeUp(reqId, angle, true, listener);
    }

    public int wakeUp(int reqId, float angle, boolean moveHead, ActionListener listener) {
        WakeUpBean bean = new WakeUpBean();
        bean.setReqId(reqId);
        bean.setAngle(angle);
        bean.setNeedMoveHead(moveHead);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 18, jsonStr, listener);
    }

    public int stopWakeUp(int reqId) {
        return this.stopAction(reqId, 18, true);
    }

    public int startSearchPerson(int reqId, int cameraType, String personName, long timeout, ActionListener listener) {
        SearchPersonBean bean = new SearchPersonBean();
        bean.setReqId(reqId);
        bean.setCameraType(cameraType);
        bean.setPersonName(personName);
        bean.setSearchTimeout(timeout);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 19, jsonStr, listener);
    }

    public int stopSearchPerson(int reqId) {
        return this.stopAction(reqId, 19, true);
    }

    @Deprecated
    public int startGetAllPersonInfo(int reqId, PersonInfoListener listener) {
        return this.startGetAllPersonInfo(reqId, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int startGetAllPersonInfo(final int reqId, PersonInfoListener listener, boolean isNeedInvalidPerson) {
        String params;
        ArrayList<PersonInfoListener> arrayList = this.mAllPersonInfoListener;
        synchronized (arrayList) {
            if (!this.mAllPersonInfoListener.contains(listener)) {
                this.mAllPersonInfoListener.add(listener);
            }
        }
        try {
            JSONObject param = new JSONObject();
            param.put("looper", (Object)"continuous");
            param.put("isNeedInvalidPerson", isNeedInvalidPerson ? 1 : 0);
            params = param.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -101;
        }
        CommandBean bean = new CommandBean();
        bean.setCmdType("cmd_head_get_all_person_infos");
        bean.setReqId(reqId);
        bean.setParams(params);
        bean.setContinue(true);
        final String jsonParams = mGson.toJson((Object)bean);
        final Type type = new TypeToken<List<Person>>(){}.getType();
        if (this.mPersonListener != null) {
            return this.startAction(reqId, 141, jsonParams, this.mPersonListener);
        }
        this.mPersonListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(int status, String responseString) throws RemoteException {
                if (status == -1) {
                    return;
                }
                ArrayList arrayList = RobotApi.this.mAllPersonInfoListener;
                synchronized (arrayList) {
                    for (PersonInfoListener p : RobotApi.this.mAllPersonInfoListener) {
                        p.onResult(status, responseString);
                    }
                }
                super.onResult(status, responseString);
            }

            @Override
            public void onError(int errorCode, String errorString) throws RemoteException {
                Log.e((String)RobotApi.TAG, (String)("Get all person onError errorCode: " + errorCode + ", errorString: " + errorString));
                if (errorCode == -119 && RobotApi.this.mAllPersonInfoListener.size() > 0) {
                    Log.d((String)RobotApi.TAG, (String)"Get all person restart");
                    RobotApi.this.startAction(reqId, 141, jsonParams, RobotApi.this.mPersonListener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusUpdate(int status, String data) throws RemoteException {
                List result;
                try {
                    result = (List)mGson.fromJson(data, type);
                }
                catch (Exception e) {
                    result = new ArrayList();
                }
                ArrayList<Person> personList = new ArrayList<Person>();
                if (result != null) {
                    for (Person person : result) {
                        person.setTimestamp(System.currentTimeMillis());
                        personList.add(person);
                    }
                }
                ArrayList arrayList = RobotApi.this.mAllPersonInfoListener;
                synchronized (arrayList) {
                    for (PersonInfoListener p : RobotApi.this.mAllPersonInfoListener) {
                        p.onData(status, personList);
                    }
                }
                super.onStatusUpdate(status, data);
            }
        };
        return this.startAction(reqId, 141, jsonParams, this.mPersonListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int stopGetAllPersonInfo(int reqId, PersonInfoListener listener) {
        Log.d((String)TAG, (String)("Stop all person info : " + this.mAllPersonInfoListener.size()));
        ArrayList<PersonInfoListener> arrayList = this.mAllPersonInfoListener;
        synchronized (arrayList) {
            if (this.mAllPersonInfoListener.contains(listener)) {
                this.mAllPersonInfoListener.remove(listener);
            }
            if (this.mAllPersonInfoListener.size() > 0) {
                return this.mAllPersonInfoListener.size();
            }
        }
        Log.d((String)TAG, (String)"Stop all person info ###");
        return this.stopAction(reqId, 141, true);
    }

    private int stopAction(int reqId, int actionId, boolean isResetHW) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("reqId", reqId);
            param.put("isResetHW", isResetHW);
            param.put("stopAction", true);
            this.logApi(actionId, RobotApi.getParamJsonObjectString(param));
            if (this.mModuleRegistry != null) {
                return this.mModuleRegistry.stopAction(reqId, actionId, isResetHW);
            }
            Log.d((String)TAG, (String)("Stop action failed : " + actionId));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private int stopAction(int reqId, int actionId, boolean isResetHW, boolean isCancelStopCommand) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("reqId", reqId);
            param.put("isResetHW", isResetHW);
            param.put("stopAction", true);
            this.logApi(actionId, RobotApi.getParamJsonObjectString(param));
            if (this.mModuleRegistry != null) {
                return this.mModuleRegistry.stopActionCancelCmd(reqId, actionId, isResetHW, isCancelStopCommand);
            }
            Log.d((String)TAG, (String)("Stop action failed : " + actionId));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private void logApi(int actionId, String params) {
        try {
            RobotApiReport rap = new RobotApiReport(this.isApiConnectedService());
            rap.action("action:" + actionId).report();
            OrionBase.logApi(1, String.valueOf(actionId), params);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"OrionBase not initialize");
        }
    }

    public boolean finishModuleParser(int reqId, boolean ifParsedSucc) {
        if (this.mModuleRegistry == null) {
            return false;
        }
        try {
            return this.mModuleRegistry.finishModuleParser(reqId, ifParsedSucc);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean finishModuleParser(int reqId, boolean ifParsedSucc, String response) {
        if (this.mModuleRegistry == null) {
            return false;
        }
        try {
            return this.mModuleRegistry.finishModuleWithResponse(reqId, ifParsedSucc, response);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int goBackward(int reqId, float speed, CommandListener listener) {
        return this.goBackward(reqId, speed, Float.MAX_VALUE, listener);
    }

    public int goBackward(int reqId, float speed, float distance, CommandListener listener) {
        return this.motionLine(reqId, "backward", speed, distance, listener);
    }

    public int goForward(int reqId, float speed, CommandListener listener) {
        return this.goForward(reqId, speed, Float.MAX_VALUE, listener);
    }

    public int goForward(int reqId, float speed, float distance, CommandListener listener) {
        return this.goForward(reqId, speed, distance, false, listener);
    }

    public int goForward(int reqId, float speed, float distance, boolean avoid, CommandListener listener) {
        return this.motionLine(reqId, "forward", speed, distance, avoid, listener);
    }

    public int turnLeft(int reqId, float speed, CommandListener listener) {
        return this.turnLeft(reqId, speed, Float.MAX_VALUE, listener);
    }

    public int turnLeft(int reqId, float speed, float angle, CommandListener listener) {
        return this.motionAngle(reqId, "turn_left", speed, angle, listener);
    }

    public int turnRight(int reqId, float speed, CommandListener listener) {
        return this.turnRight(reqId, speed, Float.MAX_VALUE, listener);
    }

    public int turnRight(int reqId, float speed, float angle, CommandListener listener) {
        return this.motionAngle(reqId, "turn_right", speed, angle, listener);
    }

    public int turnBack(int reqId, float speed, CommandListener listener) {
        return this.motionAngle(reqId, "turn_back", speed, 180.0f, listener);
    }

    public int rotate(int reqId, float speed, CommandListener listener) {
        return this.motionAngle(reqId, "rotate", speed, Float.MAX_VALUE, listener);
    }

    private int motionAngle(int reqId, String direction, float speed, float angle, CommandListener listener) {
        float radianspeed = (float)Math.toRadians(speed);
        float distance = angle == Float.MAX_VALUE ? Float.MAX_VALUE : (float)Math.toRadians(angle);
        return this.motionLine(reqId, direction, radianspeed, distance, listener);
    }

    private int motionLine(int reqId, String direction, float speed, float distance, CommandListener listener) {
        return this.motionLine(reqId, direction, speed, distance, false, listener);
    }

    private int motionLine(int reqId, String direction, float speed, float distance, boolean forwardAvoid, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("direction", (Object)direction);
            param.put("distance", (double)distance);
            param.put("linear_speed", (double)speed);
            param.put("json_navi_forward_avoid", forwardAvoid);
            CommandBean bean = new CommandBean();
            bean.setContinue(false);
            bean.setParams(param.toString());
            bean.setCmdType("cmd_navi_move_direction");
            String params = mGson.toJson((Object)bean);
            ActionListener al = this.parseCommand(listener);
            return this.startAction(reqId, 110, params, al);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int motionArc(int reqId, float lineSpeed, float angularSpeed, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("linear_speed", (double)lineSpeed);
            param.put("angular_speed", (double)angularSpeed);
            CommandBean bean = new CommandBean();
            bean.setContinue(false);
            bean.setCmdType("cmd_navi_move_direction_angle");
            bean.setParams(param.toString());
            return this.startAction(reqId, 111, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int motionArcWithObstacles(int reqId, float lineSpeed, float angularSpeed, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("linear_speed", (double)lineSpeed);
            param.put("angular_speed", (double)angularSpeed);
            CommandBean bean = new CommandBean();
            bean.setContinue(false);
            bean.setCmdType("cmd_navi_move_direction_angle_obstacles");
            bean.setParams(param.toString());
            return this.startAction(reqId, 345, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int stopMove(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_stop_move", "", false);
        return this.startAction(reqId, 113, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setLocation(int reqId, String placeName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_location", placeName, false);
        return this.startAction(reqId, 107, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setPoseLocation(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_pose_location", param, false);
        return this.startAction(reqId, 123, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getFullCheckStatus(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_full_check_status", "", false);
        return this.startAction(reqId, 28, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setPoseEstimate(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_pose_estimate", param, false);
        return this.startAction(reqId, 124, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setFixedEstimate(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_fixed_estimate", param, false);
        return this.startAction(reqId, 234, mGson.toJson((Object)bean), listener);
    }

    public int setForceEstimate(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_force_estimate", param, false);
        return this.startAction(reqId, 339, mGson.toJson((Object)bean), listener);
    }

    public int setNavigationConfig(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_config", param, false);
        return this.startAction(reqId, 207, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getNavigationConfig(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_config", "", false);
        return this.startAction(reqId, 208, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int startCreatingMap(int reqId, StartCreateMapBean startCreateMapBean, CommandListener listener) {
        if (startCreateMapBean == null) {
            return -8;
        }
        String jsonStr = mGson.toJson((Object)startCreateMapBean);
        CommandBean bean = new CommandBean("cmd_navi_start_creating_map", jsonStr, false);
        return this.startAction(reqId, 125, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopCreatingMap(int reqId, String mapName, CommandListener listener) {
        StopCreateMapBean bean = new StopCreateMapBean();
        bean.setReqId(reqId);
        bean.setMapName(mapName);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 126, jsonStr, this.parseCommand(listener));
    }

    public int stopCreatingMap(int reqId, StopCreateMapBean stopCreateMapBean, CommandListener listener) {
        String jsonStr = mGson.toJson((Object)stopCreateMapBean);
        return this.startAction(reqId, 126, jsonStr, this.parseCommand(listener));
    }

    public int switchMap(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_switch_map", mapName, false);
        return this.startAction(reqId, 127, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int loadCurrentMap(int reqId, CommandListener listener) {
        return this.loadCurrentMap(reqId, false, false, listener);
    }

    public int loadCurrentMap(int reqId, boolean keepPose, CommandListener listener) {
        return this.loadCurrentMap(reqId, true, keepPose, listener);
    }

    private int loadCurrentMap(int reqId, boolean useCustomKeepPose, boolean keepPose, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_load_current_map", mGson.toJson((Object)new LoadMapBean(useCustomKeepPose, keepPose)), false);
        return this.startAction(reqId, 225, mGson.toJson((Object)bean), listener);
    }

    public int removeMap(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_remove_map", mapName, false);
        return this.startAction(reqId, 165, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    @Deprecated
    public int refreshMd5(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_refresh_md5", mapName, false);
        return this.startAction(reqId, 219, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int removeLocation(int reqId, String positionName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_remove_location", positionName, false);
        return this.startAction(reqId, 166, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPlaceList(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_place_list", "", false);
        return this.startAction(reqId, 129, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPlaceListWithName(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_place_list_with_name", "", false);
        return this.startAction(reqId, 211, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPlaceListByMapName(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_placelist_by_mapname", mapName, false);
        return this.startAction(reqId, 240, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPlaceListWithNameList(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_placelist_with_namelist", param, false);
        return this.startAction(reqId, 212, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getInternationalPlaceList(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_international_place_list", mapName, false);
        return this.startAction(reqId, 332, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPlace(int reqId, String positionName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_place_name", positionName, false);
        return this.startAction(reqId, 128, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int goPosition(int reqId, String postionName, boolean isAdjustAngle, CommandListener listener) {
        return this.goPosition(reqId, postionName, null, isAdjustAngle, listener);
    }

    public int goPosition(int reqId, String position, String velocity, CommandListener listener) {
        return this.goPosition(reqId, position, velocity, false, listener);
    }

    public int goPosition(int reqId, String position, String velocity, boolean isAdjustAngle, CommandListener listener) {
        return this.goPosition(reqId, position, velocity, isAdjustAngle, 0.0, listener);
    }

    public int goPosition(int reqId, String position, String velocity, boolean isAdjustAngle, double destinationRange, CommandListener listener) {
        return this.goPosition(reqId, position, velocity, isAdjustAngle, destinationRange, 0, listener);
    }

    public int goPosition(int reqId, String position, String velocity, boolean isAdjustAngle, double destinationRange, int priority, CommandListener listener) {
        String params = null;
        if (TextUtils.isEmpty((CharSequence)position)) {
            params = null;
        } else {
            try {
                JSONObject positionJson = new JSONObject(position);
                double linearSpeed = 0.7f;
                double angularSpeed = 1.2f;
                if (!TextUtils.isEmpty((CharSequence)velocity)) {
                    JSONObject velocityJson = new JSONObject(velocity);
                    linearSpeed = velocityJson.has("linear_speed") ? velocityJson.optDouble("linear_speed") : (double)0.7f;
                    angularSpeed = velocityJson.has("angular_speed") ? velocityJson.optDouble("angular_speed") : (double)1.2f;
                }
                positionJson.put("linear_speed", linearSpeed);
                positionJson.put("angular_speed", angularSpeed);
                positionJson.put("adjust_angle", isAdjustAngle);
                positionJson.put("destination_range", destinationRange);
                positionJson.put("taskPriority", priority);
                params = positionJson.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        CommandBean bean = new CommandBean("cmd_navi_go_position", params, false);
        return this.startAction(reqId, 131, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int turnToTargetDirection(int reqId, Pose position, double linearSpeed, double angularSpeed, boolean turnLeft, CommandListener listener) {
        String params = null;
        if (position == null) {
            params = null;
        } else {
            try {
                JSONObject positionJson = new JSONObject();
                positionJson.put("px", (double)position.getX());
                positionJson.put("py", (double)position.getY());
                positionJson.put("theta", (double)position.getTheta());
                positionJson.put("linear_speed", linearSpeed == 0.0 ? (double)0.7f : linearSpeed);
                positionJson.put("angular_speed", angularSpeed == 0.0 ? (double)1.2f : angularSpeed);
                positionJson.put("left_or_right", turnLeft);
                params = positionJson.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        CommandBean bean = new CommandBean("cmd_navi_turn_by_navigation", params, false);
        return this.startAction(reqId, 315, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopTurnToTargetDirection(int reqId) {
        return this.stopAction(reqId, 315, true);
    }

    public int goPosition(int reqId, String postion, CommandListener listener) {
        return this.goPosition(reqId, postion, null, listener);
    }

    public int goPosition(int reqId, String position, double linearSpeed, double angularSpeed, CommandListener listener) {
        return this.goPosition(reqId, position, linearSpeed, angularSpeed, 0.0, listener);
    }

    public int goPosition(int reqId, String position, double linearSpeed, double angularSpeed, double destinationRange, CommandListener listener) {
        String params = null;
        if (TextUtils.isEmpty((CharSequence)position)) {
            params = null;
        } else {
            try {
                JSONObject positionJson = new JSONObject(position);
                positionJson.put("linear_speed", linearSpeed);
                positionJson.put("angular_speed", angularSpeed);
                positionJson.put("destination_range", destinationRange);
                params = positionJson.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        CommandBean bean = new CommandBean("cmd_navi_go_position", params, false);
        return this.startAction(reqId, 131, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopGoPosition(int reqId) {
        this.stopAction(reqId, 131, true);
        CommandBean bean = new CommandBean("cmd_navi_stop_navigation", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
    }

    public int getLocation(int reqId, String placeName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_location_high_frequency", placeName, false);
        return this.startAction(reqId, 108, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int isRobotInlocations(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_is_in_location", param, false);
        return this.startAction(reqId, 109, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int isRobotEstimate(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_is_estimate", "", false);
        return this.startAction(reqId, 133, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int saveRobotEstimate(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_save_estimate", "", false);
        return this.startAction(reqId, 134, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public boolean isNavigationReady() {
        return true;
    }

    public int isInNavigation(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_is_in_navigation", null, false);
        return this.startAction(reqId, 106, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int switchChargeMode(int reqId) {
        CommandBean bean = new CommandBean("cmd_navi_switch_auto_charge_mode", null, false);
        return this.startAction(reqId, 175, mGson.toJson((Object)bean), null);
    }

    public int navMoveRotation(int reqId, String text, String params, CommandListener listener) {
        String direction = null;
        try {
            JSONObject json = new JSONObject(params);
            float angle = Float.valueOf(json.get("angle").toString()).floatValue();
            direction = angle > 0.0f ? "turn_right" : "turn_left";
            JSONObject param = new JSONObject();
            param.put("direction", (Object)direction);
            param.put("distance", (double)((float)Math.toRadians(Math.abs(angle))));
            param.put("linear_speed", (double)0.8f);
            param.put("no_need_acceleration", true);
            CommandBean bean = new CommandBean();
            bean.setContinue(false);
            bean.setParams(param.toString());
            bean.setCmdType("cmd_navi_move_direction");
            String jsonParams = mGson.toJson((Object)bean);
            ActionListener al = this.parseCommand(listener);
            return this.startAction(reqId, 110, jsonParams, al);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int switchCamera(int reqId, String mode, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("location", (Object)mode);
            CommandBean bean = new CommandBean("cmd_head_switch_camera", param.toString(), false);
            return this.startAction(reqId, 139, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int startRecordFaceData() {
        CommandBean bean = new CommandBean("cmd_head_record_face_start", "", false);
        return this.startAction(0, 222, mGson.toJson((Object)bean), null);
    }

    private int stopRecordFaceData() {
        CommandBean bean = new CommandBean("cmd_head_record_face_stop", "", false);
        return this.startAction(0, 222, mGson.toJson((Object)bean), null);
    }

    private int enableAvatarFaceData() {
        CommandBean bean = new CommandBean("cmd_head_enable_avatar_face", "", false);
        return this.startAction(0, 316, mGson.toJson((Object)bean), null);
    }

    private int disableAvatarFaceData() {
        CommandBean bean = new CommandBean("cmd_head_disable_avatar_face", "", false);
        return this.startAction(0, 316, mGson.toJson((Object)bean), null);
    }

    public int resetHead(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_reset_head", "", false);
        return this.startAction(reqId, 354, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int resetHeadAngle(int reqId, String text, String params, CommandListener listener) {
        int vertical = 0;
        int horizontal = 0;
        try {
            JSONObject json = new JSONObject(params);
            vertical = json.optInt("vertical");
            horizontal = json.optInt("horizontal");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.moveHead(reqId, "absolute", "absolute", horizontal, vertical, listener);
    }

    public int moveHead(int reqId, String hmode, String vmode, int hangle, int vangle, CommandListener listener) {
        HeadTurnBean bean = new HeadTurnBean();
        bean.setVerticalMode("relative".equals(vmode) ? HeadTurnBean.HeadTurnMode.relative : HeadTurnBean.HeadTurnMode.absolute);
        bean.setHorizontalMode("relative".equals(hmode) ? HeadTurnBean.HeadTurnMode.relative : HeadTurnBean.HeadTurnMode.absolute);
        bean.setVerticalAngle(vangle);
        bean.setHorizontalAngle(hangle);
        return this.turnHead(reqId, bean, listener);
    }

    public int moveHead(int reqId, String hmode, String vmode, int hangle, int vangle, int hMaxSpeed, int vMaxSpeed, CommandListener listener) {
        HeadTurnBean bean = new HeadTurnBean();
        bean.setVerticalMode("relative".equals(vmode) ? HeadTurnBean.HeadTurnMode.relative : HeadTurnBean.HeadTurnMode.absolute);
        bean.setHorizontalMode("relative".equals(hmode) ? HeadTurnBean.HeadTurnMode.relative : HeadTurnBean.HeadTurnMode.absolute);
        bean.setVerticalAngle(vangle);
        bean.setHorizontalAngle(hangle);
        bean.setHorizontalMaxSpeed(hMaxSpeed);
        bean.setVerticalMaxSpeed(vMaxSpeed);
        return this.turnHead(reqId, bean, listener);
    }

    public int turnHead(int reqId, HeadTurnBean bean, CommandListener listener) {
        return this.startAction(reqId, 266, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopTurnHead(int reqId, CommandListener listener) {
        return this.startAction(reqId, 266, mGson.toJson((Object)new HeadTurnBean()), this.parseCommand(listener));
    }

    public int getHeadStatus(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_get_status", null, false);
        return this.startAction(reqId, 162, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setTrackTarget(int reqId, String name, int id, Definition.TrackMode mode, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("name", (Object)name);
            param.put("id", id);
            param.put("mode", mode.getValue());
            param.put("control", (Object)"start");
            CommandBean bean = new CommandBean("cmd_head_set_track_target", param.toString(), false);
            return this.startAction(reqId, 140, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int switchTrackTarget(int reqId, int angle, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("angle", angle);
            CommandBean bean = new CommandBean("cmd_head_switch_track_target", param.toString(), false);
            return this.startAction(reqId, 251, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int stopTrack(int reqId, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("control", (Object)"stop");
            param.put("name", (Object)"");
            param.put("id", -1);
            param.put("mode", 3);
            CommandBean bean = new CommandBean("cmd_head_stop_track_target", param.toString(), false);
            return this.startAction(reqId, 169, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startGetHeadCount(int reqId, double intervalTime, CommandListener listener) {
        String params;
        try {
            JSONObject param = new JSONObject();
            param.put("interval", intervalTime);
            params = param.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -101;
        }
        CommandBean bean = new CommandBean();
        bean.setCmdType("cmd_head_start_head_count");
        bean.setReqId(reqId);
        bean.setParams(params);
        bean.setContinue(false);
        return this.startAction(reqId, 306, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopGetHeadCount(int reqId, CommandListener listener) {
        Log.d((String)TAG, (String)"Stop all head count ###");
        JSONObject param = new JSONObject();
        String params = param.toString();
        CommandBean bean = new CommandBean();
        bean.setCmdType("cmd_head_stop_head_count");
        bean.setReqId(reqId);
        bean.setParams(params);
        bean.setContinue(false);
        return this.startAction(reqId, 307, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getHeadCount(int reqId, CommandListener listener) {
        Log.d((String)TAG, (String)"get head count ###");
        JSONObject param = new JSONObject();
        String params = param.toString();
        CommandBean bean = new CommandBean();
        bean.setCmdType("cmd_head_get_head_count");
        bean.setReqId(reqId);
        bean.setParams(params);
        bean.setContinue(false);
        return this.startAction(reqId, 329, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int updatePictureReportConfig(int reqId, String config, CommandListener listener) {
        Log.d((String)TAG, (String)("updatePictureReportConfig config: " + config));
        JSONObject param = new JSONObject();
        try {
            param.put("config", (Object)config);
            String params = param.toString();
            CommandBean bean = new CommandBean();
            bean.setCmdType("cmd_head_picture_report_config");
            bean.setReqId(reqId);
            bean.setParams(params);
            bean.setContinue(false);
            return this.startAction(reqId, 326, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int isHeaderConnected(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_is_header_connected", null, false);
        return this.startAction(reqId, 148, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPictureById(int reqId, int id, int count, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("id", id);
            param.put("count", count);
            CommandBean bean = new CommandBean("cmd_head_get_picture_by_id", param.toString(), false);
            return this.startAction(reqId, 145, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getGestureInfos(int reqId, String mode, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("looper", (Object)mode);
            CommandBean bean = new CommandBean("cmd_head_get_gesture_infos", param.toString(), false);
            return this.startAction(reqId, 157, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int stopGestureInfos(int reqId, CommandListener listener) {
        return this.stopAction(reqId, 157, true);
    }

    public int getSpeechToken(int reqId, CommandListener listener) {
        new RuntimeException("\u5408\u5e76\u63a5\u53e3\uff0c\u7a7a\u5b9e\u73b0").printStackTrace();
        try {
            listener.onError(-1, "\u4e0d\u652f\u6301");
            listener.onError(-1, "\u4e0d\u652f\u6301", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private int startAction(int reqId, int actionId, String params, ActionListener listener) {
        this.logApi(actionId, params);
        try {
            ActionDispatcher actionListener = null;
            if (listener != null) {
                if (this.mResponseThread != null) {
                    Looper looper = this.mResponseThread.getLooper();
                    actionListener = this.mMessageDispatcher.obtainActionDispatcher(looper, listener);
                } else {
                    actionListener = this.mMessageDispatcher.obtainActionDispatcher(listener);
                }
            }
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)("Start action failed : " + actionId + "  " + params));
                return -1;
            }
            return this.mModuleRegistry.startAction(reqId, actionId, params, actionListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startPptControlPipe(int reqId, CommandListener listener) {
        Log.d((String)"FC_", (String)"RobotApi getPptMqttPipe");
        JsonObject obj = new JsonObject();
        CommandBean bean = new CommandBean("cmd_remote_ppt_mqtt_pipe", obj.toString(), false);
        return this.startAction(reqId, 130, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int sendPptControlAction(int reqId, String param, String commandIndex) {
        JsonObject obj = new JsonObject();
        obj.addProperty("action", param);
        obj.addProperty("command_index", commandIndex);
        CommandBean bean = new CommandBean("cmd_remote_ppt_mqtt_action", obj.toString(), false);
        return this.startAction(reqId, 132, mGson.toJson((Object)bean), null);
    }

    public int remoteRegister(int reqId, String name, List<String> pictures, CommandListener listener) {
        PictureInfo info = new PictureInfo();
        info.setName(name);
        info.setPictures(pictures);
        CommandBean bean = new CommandBean("cmd_remote_register", mGson.toJson((Object)info), false);
        return this.startAction(reqId, 167, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteDetect(int reqId, String personId, List<String> pictures, CommandListener listener) {
        PictureInfo info = new PictureInfo();
        info.setId(personId);
        info.setPictures(pictures);
        CommandBean bean = new CommandBean("cmd_remote_detect", mGson.toJson((Object)info), false);
        return this.startAction(reqId, 168, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteModifyDetectName(int reqId, String userId, String modifiedName, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("user_id", (Object)userId);
            jsonObject.put("full_name", (Object)modifiedName);
            CommandBean bean = new CommandBean("cmd_remote_modify_detect_name", jsonObject.toString(), false);
            Log.d((String)"RegisterRemote", (String)("remoteModifyDetectName json : " + jsonObject.toString() + ", mGson toString : " + mGson.toJson((Object)bean)));
            return this.startAction(reqId, 241, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getPersonInfoFromNet(int reqId, String personId, List<String> pictures, CommandListener listener) {
        PictureInfo info = new PictureInfo();
        info.setId(personId);
        info.setPictures(pictures);
        CommandBean bean = new CommandBean("cmd_remote_get_person_info", mGson.toJson((Object)info), false);
        return this.startAction(reqId, 224, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    @Deprecated
    public int uploadMapToServer(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_upload_map_to_server", mapName, false);
        return this.startAction(reqId, 218, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int clearCurNaviMap(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_clear_cur_navi_map", null, false);
        return this.startAction(reqId, 238, mGson.toJson((Object)bean), listener);
    }

    public int checkIfHasObstacle(int reqId, double startAngle, double endAngle, double distance, CommandListener listener) {
        CheckObstacleBean beanParam = new CheckObstacleBean(startAngle, endAngle, distance);
        beanParam.setReqId(reqId);
        CommandBean bean = new CommandBean("cmd_navi_check_obstacle", mGson.toJson((Object)beanParam), false);
        return this.startAction(reqId, 317, mGson.toJson((Object)bean), listener);
    }

    public int editPlace(int reqId, String operParam, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_edit_place", operParam, false);
        return this.startAction(reqId, 239, mGson.toJson((Object)bean), listener);
    }

    public int textToMp3(int reqId, String text, String fullFile, String fileName, CommandListener listener) {
        String fullFilePathAndName = fullFile + File.separator + fileName;
        File file = new File(fullFilePathAndName);
        if (file.exists() && !file.canWrite()) {
            return -1;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("text", (Object)text);
            jsonObject.put("fileName", (Object)fullFilePathAndName);
            CommandBean bean = new CommandBean("cmd_remote_text_to_mp3", jsonObject.toString(), false);
            Log.d((String)TAG, (String)("text to mp3 json is " + jsonObject.toString()));
            return this.startAction(reqId, 253, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean installApk(int reqId, String fullPathName, String taskID) {
        try {
            Bundle bundle = new Bundle();
            bundle.putString("filePath", fullPathName);
            bundle.putString("task_id", taskID);
            if (this.mModuleRegistry == null) {
                return false;
            }
            return this.mModuleRegistry.installPatch(bundle);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    private ActionListener parseCommand(CommandListener listener) {
        if (listener == null) {
            return null;
        }
        return listener;
    }

    public int startCharge(int reqId) {
        CommandBean bean = new CommandBean("cmd_can_auto_charge_start", null, false);
        return this.startAction(reqId, 172, mGson.toJson((Object)bean), null);
    }

    public int stopCharge(int reqId) {
        CommandBean bean = new CommandBean("cmd_can_auto_charge_end", null, false);
        return this.startAction(reqId, 173, mGson.toJson((Object)bean), null);
    }

    public int getChargeStatus(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_charge_status", null, false);
        return this.startAction(reqId, 174, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    @Deprecated
    public int setStartChargePoseAction(int reqId, long timeout, int chargeMode, String language, ActionListener listener) {
        return this.setStartChargePoseAction(reqId, timeout, chargeMode, "", language, listener);
    }

    public int setStartChargePoseAction(int reqId, long timeout, int chargeMode, String setStartChargePoseType, String language, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        bean.setChargeMode(chargeMode);
        bean.setMapLanguage(language);
        bean.setSetStartChargePoseType(setStartChargePoseType);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 22, toJson, listener);
    }

    @Deprecated
    public int setStartChargePoseAction(int reqId, long timeout, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 22, toJson, listener);
    }

    public int startNaviToAutoChargeAction(int reqId, long timeout, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        bean.setChargeType(0);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 21, toJson, listener);
    }

    public int startNaviToAutoChargeAction(int reqId, long timeout, double distance, long avoidTime, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        bean.setAvoidDistance(distance);
        bean.setAvoidTimeout(avoidTime);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 21, toJson, listener);
    }

    public int startNaviToAutoChargeAction(int reqId, long timeout, double distance, long avoidTime, long multiWaitTime, ActionListener listener) {
        AutoChargeBean bean = new AutoChargeBean();
        bean.setReqId(reqId);
        bean.setTimeout(timeout);
        bean.setAvoidDistance(distance);
        bean.setAvoidTimeout(avoidTime);
        bean.setMultipleWaitTime(multiWaitTime);
        String toJson = mGson.toJson((Object)bean);
        return this.startAction(reqId, 21, toJson, listener);
    }

    public int stopAutoChargeAction(int reqId, boolean isResetHW) {
        return this.stopAction(reqId, 21, isResetHW);
    }

    public int stopSetChargePileAction(int reqId, boolean isResetHW) {
        return this.stopAction(reqId, 22, isResetHW);
    }

    public int stopChargingByApp() {
        if (this.ctx != null) {
            this.ctx.sendBroadcast(new Intent("action_stop_charging_by_app"));
            return 0;
        }
        return -101;
    }

    public int getEmergencyStatus(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_emergency_status", null, false);
        return this.startAction(reqId, 184, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    @Deprecated
    public int setLambColor(int reqId, int target, int color) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)"Set lamb color failed");
            return -1;
        }
        try {
            return this.mModuleRegistry.setLambColor(reqId, target, color);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int setLambAnimation(int reqId, int target, int start, int end, int startTime, int endTime, int repeat, int onTime, int freeze) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)"Set lamb animation failed");
            return -1;
        }
        JSONObject params = new JSONObject();
        try {
            return this.mModuleRegistry.setLambAnimation(reqId, target, start, end, startTime, endTime, repeat, onTime, freeze);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public void registerModule(String appName, List<String> parsePattern, ModuleCallbackApi cb) {
        this.setCallback(cb);
    }

    public void unregisterModule(String appName) {
    }

    public String registerStatusListener(String type, StatusListener listener) {
        try {
            if (listener == null || this.mModuleRegistry == null) {
                return null;
            }
            StatusDispatcher statusListener = null;
            if (this.mResponseThread != null) {
                Looper looper = this.mResponseThread.getLooper();
                statusListener = this.mMessageDispatcher.obtainStatusDispatcher(looper, listener);
            } else {
                statusListener = this.mMessageDispatcher.obtainStatusDispatcher(listener);
            }
            String id = this.mModuleRegistry.registerStatusListener(type, statusListener);
            statusListener.register(id);
            return id;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean unregisterStatusListener(StatusListener listener) {
        try {
            if (listener == null || this.mModuleRegistry == null) {
                return false;
            }
            boolean result = this.mModuleRegistry.unregisterStatusListener(listener.getId());
            this.mMessageDispatcher.unregisterStatusDispatcher(listener.getId());
            return result;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean startStatusSocket(String type, int socketPort) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)("Start status socket failed : " + type + "  " + socketPort));
            return false;
        }
        try {
            return this.mModuleRegistry.startStatusSocket(type, socketPort);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean closeStatusSocket(String type, int socketPort) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)("Close status socket failed : " + type + "  " + socketPort));
            return false;
        }
        try {
            return this.mModuleRegistry.closeStatusSocket(type, socketPort);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void sendStatusReport(String type, String data) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)("Send status report failed : " + type + "  " + data));
            return;
        }
        try {
            this.mModuleRegistry.sendStatusReport(type, data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public int startInspection(int reqId, long time, boolean isReInspection, ActionListener listener) {
        String result = this.getInspectResult();
        if (!isReInspection && result != null) {
            try {
                listener.onResult(0, result);
                listener.onResult(0, result, "");
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
        return this.startInspection(reqId, time, listener);
    }

    public int startInspection(int reqId, long time, ActionListener listener) {
        InspectActionBean bean = new InspectActionBean();
        bean.setReqId(reqId);
        bean.setTimeOut(time);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 20, jsonStr, listener);
    }

    public int stopInspection(int reqId, boolean isResetHW) {
        return this.stopAction(reqId, 20, isResetHW);
    }

    public int getHWStatus(int function) throws RemoteException {
        return this.mModuleRegistry.getHWStatus(function);
    }

    public int getHeadVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_get_version", null, false);
        return this.startAction(reqId, 155, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getNavigationVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_version", null, false);
        return this.startAction(reqId, 103, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getNavigationUpdateParams(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_update_params", null, false);
        return this.startAction(reqId, 195, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getNavigationSerialNumber(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_serial_number", null, false);
        return this.startAction(reqId, 205, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getHeadUpdateParams(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_get_update_params", null, false);
        return this.startAction(reqId, 156, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getHeadSerialNumber(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_get_serial_number", null, false);
        return this.startAction(reqId, 204, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanWheelLeftVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_wheel_l_version", null, false);
        return this.startAction(reqId, 246, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanWheelRightVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_wheel_r_version", null, false);
        return this.startAction(reqId, 247, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanMotorHorizontalVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_motor_h_version", null, false);
        return this.startAction(reqId, 196, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanMotorVerticalVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_motor_v_version", null, false);
        return this.startAction(reqId, 197, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanPsbVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_psb_version", null, false);
        return this.startAction(reqId, 198, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanAutoChargeVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_auto_charge_version", null, false);
        return this.startAction(reqId, 214, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanBatteryVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_battery_version", null, false);
        return this.startAction(reqId, 215, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int resumeSpecialPlaceTheta(int reqId, String placeName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_resume_special_place_theta", placeName, false);
        return this.startAction(reqId, 216, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopResumeSpecialPlaceThetaAction(int reqId) {
        this.stopAction(reqId, 216, true);
        CommandBean bean = new CommandBean("cmd_navi_stop_navigation", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
    }

    public int canRobotReboot(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_robot_reboot", null, false);
        return this.startAction(reqId, 199, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getHeadCameraStatus(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_get_camera_status", null, false);
        return this.startAction(reqId, 164, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getMapName(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_map_name", null, false);
        return this.startAction(reqId, 170, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getPosition(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_position", null, false);
        return this.startAction(reqId, 171, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setMapInfo(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_map_info", param, false);
        return this.startAction(reqId, 176, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteRequestQrcode(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_qrcode", null, false);
        return this.startAction(reqId, 177, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteCheckVerify(int reqId, String code, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_verify", code, false);
        return this.startAction(reqId, 178, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteCheckPhoneVerify(int reqId, String code, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_phone_verify", code, false);
        return this.startAction(reqId, 178, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteRequestSkill(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_skill", null, false);
        return this.startAction(reqId, 179, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remotePostMsg(int reqId, String taskId, String status, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("taskId", taskId);
        obj.addProperty("status", status);
        CommandBean bean = new CommandBean("cmd_remote_postmsg", obj.toString(), false);
        return this.startAction(reqId, 180, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remotePostEmergencyMsg(int reqId, String status) {
        JsonObject obj = new JsonObject();
        obj.addProperty("emergency", status);
        CommandBean bean = new CommandBean("cmd_remote_post_emergency_msg", obj.toString(), false);
        return this.startAction(reqId, 187, mGson.toJson((Object)bean), null);
    }

    public int remoteRequestGuestInfo(int reqId, String id, String type, String startTime, String endTime, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("visitor_id", id);
        obj.addProperty("type", type);
        obj.addProperty("btime", startTime);
        obj.addProperty("etime", endTime);
        CommandBean bean = new CommandBean("cmd_remote_guestinfo", obj.toString(), false);
        return this.startAction(reqId, 181, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteRegister(int reqId, String name, String id, List<String> pictures, CommandListener listener) {
        PictureInfo info = new PictureInfo();
        try {
            info.setId(id);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        info.setName(name);
        info.setPictures(pictures);
        CommandBean bean = new CommandBean("cmd_remote_register_tempid", mGson.toJson((Object)info), false);
        return this.startAction(reqId, 182, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteBindStatus(int reqId, CommandListener listener) {
        JsonObject obj = new JsonObject();
        CommandBean bean = new CommandBean("cmd_remote_check_bind_status", obj.toString(), false);
        return this.startAction(reqId, 183, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteGetMapId(int reqId, CommandListener listener) {
        JsonObject obj = new JsonObject();
        CommandBean bean = new CommandBean("cmd_remote_get_map_id", obj.toString(), false);
        Log.d((String)"FC_", (String)"RobotApi remoteGetMapId ");
        return this.startAction(reqId, 221, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteWakeUpTimes(int reqId, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("wakeup", (Number)1);
        CommandBean bean = new CommandBean("cmd_remote_wakeup_times", obj.toString(), false);
        return this.startAction(reqId, 188, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getBatteryTimeRemaining(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_battery_time_remain", null, false);
        return this.startAction(reqId, 189, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getChargeTimeRemaining(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_charge_time_remain", null, false);
        return this.startAction(reqId, 190, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int sendBatteryTimeRemaining(int reqId, String msg) {
        JsonObject obj = new JsonObject();
        obj.addProperty("battery", (Number)Long.valueOf(msg));
        CommandBean bean = new CommandBean("cmd_remote_post_battery_time_remain", obj.toString(), false);
        return this.startAction(reqId, 191, mGson.toJson((Object)bean), null);
    }

    public int sendChargingTimeRemaining(int reqId, String msg) {
        JsonObject obj = new JsonObject();
        obj.addProperty("charging", (Number)Long.valueOf(msg));
        CommandBean bean = new CommandBean("cmd_remote_post_charge_time_remain", obj.toString(), false);
        return this.startAction(reqId, 192, mGson.toJson((Object)bean), null);
    }

    public int getDepthCameraStatus(int reqId, int id, int count, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("id", id);
            param.put("count", count);
            CommandBean bean = new CommandBean();
            bean.setCmdType("cmd_head_get_depth_status");
            bean.setParams(param.toString());
            bean.setContinue(false);
            return this.startAction(reqId, 193, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int postCruiseStatus(int reqId, String params) {
        CommandBean bean = new CommandBean("cmd_remote_post_cruise_status", params, false);
        return this.startAction(reqId, 220, mGson.toJson((Object)bean), null);
    }

    public int getFovCameraStatus(int reqId, int id, int count, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("id", id);
            param.put("count", count);
            CommandBean bean = new CommandBean();
            bean.setCmdType("cmd_head_get_fov_status");
            bean.setParams(param.toString());
            bean.setContinue(false);
            return this.startAction(reqId, 194, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int locateVision(int reqId, int retryCount, CommandListener listener) {
        ResetEstimateParams params = new ResetEstimateParams();
        params.setReqId(reqId);
        params.setRetryCount(retryCount);
        return this.startAction(reqId, 25, mGson.toJson((Object)params), this.parseCommand(listener));
    }

    public int resetEstimate(int reqId, int retryCount, CommandListener listener) {
        ResetEstimateParams params = new ResetEstimateParams();
        params.setReqId(reqId);
        params.setRetryCount(retryCount);
        return this.startAction(reqId, 24, mGson.toJson((Object)params), this.parseCommand(listener));
    }

    public int remotePostPrepared(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_post_prepared", null, false);
        return this.startAction(reqId, 203, mGson.toJson((Object)bean), null);
    }

    public int postSetPlaceToServer(int reqId, String params) {
        CommandBean bean = new CommandBean("cmd_remote_post_set_place", params, false);
        return this.startAction(reqId, 206, mGson.toJson((Object)bean), null);
    }

    public int enableTX1(int reqId, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("switch_type", 1);
            CommandBean bean = new CommandBean("cmd_head_master_switch", param.toString(), false);
            return this.startAction(reqId, 213, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int disableTX1(int reqId, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("switch_type", 0);
            CommandBean bean = new CommandBean("cmd_head_master_switch", param.toString(), false);
            return this.startAction(reqId, 213, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int remoteChargePile(int reqId, String status, String msg, boolean result, CommandListener listener) {
        Log.d((String)"FC_core", (String)("remote setChargePile status : " + status + ", msg : " + msg + " , result : " + result));
        try {
            JsonObject value = new JsonObject();
            value.addProperty("status", status);
            value.addProperty("name", "\u56de\u5145\u70b9");
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                JsonElement msgJson = new JsonParser().parse(msg);
                if (msgJson != null && msgJson.isJsonObject()) {
                    value.add("position", msgJson);
                } else {
                    value.addProperty("msg", msg);
                }
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "set_charging_pile");
            obj.add("value", (JsonElement)value);
            obj.addProperty("result", Boolean.valueOf(result));
            CommandBean bean = new CommandBean("cmd_remote_charge_pile", mGson.toJson((JsonElement)obj), false);
            Log.d((String)"FC_core", (String)("FCApi remoteChargePile\u3000reqId = " + reqId));
            return this.startAction(reqId, 202, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Throwable e) {
            Log.e((String)"FC_core", (String)("FCApi remoteChargePile e : " + e.getLocalizedMessage()));
            return 0;
        }
    }

    public int remoteFirstCharge(int reqId, String status, boolean result, CommandListener listener) {
        Log.d((String)"FC_core", (String)("remote first charge status : " + status + " , result : " + result));
        try {
            JsonObject value = new JsonObject();
            value.addProperty("status", status);
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "first_recharging");
            obj.add("value", (JsonElement)value);
            obj.addProperty("result", Boolean.valueOf(result));
            CommandBean bean = new CommandBean("cmd_remote_first_charging", mGson.toJson((JsonElement)obj), false);
            Log.d((String)"FC_core", (String)("FCApi remoteFirstCharge\u3000reqId = " + reqId));
            return this.startAction(reqId, 201, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Throwable e) {
            Log.e((String)"FC_core", (String)("remoteFirstCharge e : " + e.getLocalizedMessage()));
            return 0;
        }
    }

    public int setShippingMode(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_shipping_mode", null, false);
        return this.startAction(reqId, 217, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int receptionRegister(int reqId, int detection, String imageSrc, String name, String taskId, int has_image, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("detection", (Number)detection);
        obj.addProperty("image", imageSrc);
        obj.addProperty("name", name);
        obj.addProperty("task_id", taskId);
        obj.addProperty("has_image", (Number)has_image);
        CommandBean bean = new CommandBean("cmd_remote_register_tempid", mGson.toJson((JsonElement)obj), false);
        return this.startAction(reqId, 182, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanRotateSupport(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_rotate_support", null, false);
        return this.startAction(reqId, 223, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int uploadMapPkg(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_upload_map_pkg", mapName, false);
        return this.startAction(reqId, 226, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int uploadMapPlaceList(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_upload_place_list", mapName, false);
        return this.startAction(reqId, 227, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int deleteCloudMapPlaceList(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_delete_place_list", mapName, false);
        return this.startAction(reqId, 354, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCloudMapPlaceList(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_get_place_list", mapName, false);
        return this.startAction(reqId, 355, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int deleteCloudMap(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_delete_map", mapName, false);
        return this.startAction(reqId, 228, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int uploadSwitchInfo(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_switch_map_info", mapName, false);
        return this.startAction(reqId, 229, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCloudMapListInfo(int reqId, final CommandListener listener) {
        CommandListener proxyListener = new CommandListener(){

            @Override
            public void onResult(int result, String message) {
                String msg = Utils.getFileContent(message);
                Utils.removeFileFromSDCard(message);
                listener.onResult(result, msg);
                listener.onResult(result, msg, "");
            }
        };
        CommandBean bean = new CommandBean("cmd_remote_get_map_list_info", FILE_BACK, false);
        return this.startAction(reqId, 230, mGson.toJson((Object)bean), this.parseCommand(proxyListener));
    }

    public int getCloudMapListInfo(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_get_map_list_info", mapName, false);
        return this.startAction(reqId, 230, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int parseDownloadMapPlaceListToNaviProp(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_parse_place_list", mapName, false);
        return this.startAction(reqId, 232, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int saveRoadData(int reqId, String mapName, String roadJson, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("mapName", mapName);
        obj.addProperty("roadJson", roadJson);
        CommandBean bean = new CommandBean("cmd_navi_save_road_data", mGson.toJson((JsonElement)obj), false);
        return this.startAction(reqId, 377, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int autoDrawRoad(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_auto_draw_road", mapName, false);
        return this.startAction(reqId, 378, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopExpansionMap(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_stop_expansion_map", mapName, false);
        return this.startAction(reqId, 390, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int savePlaceListToPlaceFile(int reqId, String mapName, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_save_place_list", mapName, false);
        return this.startAction(reqId, 331, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int uploadOperationLog(int reqId, String module, String oper, String state, String msg, String mapName, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("module", module);
        obj.addProperty("operation", oper);
        obj.addProperty("state", state);
        obj.addProperty("msg", msg);
        obj.addProperty("name", mapName);
        CommandBean bean = new CommandBean("cmd_remote_upload_oper_log", mGson.toJson((JsonElement)obj), false);
        return this.startAction(reqId, 233, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setNaviCruiseRoute(int reqId, String params, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_set_cruise_route", params, false);
        return this.startAction(reqId, 236, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getNaviCruiseRoute(int reqId, String params, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_cruise_route", params, false);
        return this.startAction(reqId, 237, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public void setResponseThread(HandlerThread thread) {
        this.mResponseThread = thread;
    }

    public int naviTimeOutCmdReport(int reqId, long timestamp, String cacheId, String type, String params, CommandListener listener) {
        Log.i((String)TAG, (String)("tag_navi_log_report  type : " + type));
        NaviCmdTimeOutBean naviCmd = new NaviCmdTimeOutBean(timestamp, cacheId, reqId, type, params);
        CommandBean bean = new CommandBean("cmd_navi_time_out_report", new Gson().toJson((Object)naviCmd), false);
        return this.startAction(reqId, 256, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int scoreRecordingTask(int reqId, String params, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_guide_score", params, false);
        return this.startAction(reqId, 260, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setLight(int reqId, String params, ActionListener listener) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)"set light, mModuleRegistry is null");
            return -1;
        }
        try {
            return this.mModuleRegistry.setLight(reqId, params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setLedLight(int reqId, LedLightBean ledLightBean) {
        if (this.mModuleRegistry == null) {
            Log.d((String)TAG, (String)"Set led light failed");
            return -1;
        }
        if (ledLightBean == null) {
            return -2;
        }
        try {
            return this.mModuleRegistry.setLedLight(reqId, mGson.toJson((Object)ledLightBean));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int robotReboot(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_robot_reboot", null, false);
        return this.startAction(reqId, 199, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getRobotSn(CommandListener listener) {
        return RobotSettings.getSystemSn(listener);
    }

    public String getRobotVersion() {
        return RobotSettings.getVersion();
    }

    public int renameMap(int reqId, String oldName, String newName, CommandListener listener) {
        JsonObject obj = new JsonObject();
        obj.addProperty("old_map_name", oldName);
        obj.addProperty("new_map_name", newName);
        CommandBean bean = new CommandBean("cmd_navi_rename_map", mGson.toJson((JsonElement)obj), false);
        return this.startAction(reqId, 261, mGson.toJson((Object)bean), listener);
    }

    public int clearNaviCruiseRoute(int reqId, String params, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_clear_cruise_route", params, false);
        return this.startAction(reqId, 262, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int checkRobotPosePosition(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_check_pose_position", param, false);
        return this.startAction(reqId, 265, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int startNavigationBack(int reqId, String destination, ActionListener listener) {
        return this.startNavigationBack(reqId, destination, 0.7f, 1.2f, listener);
    }

    public int startNavigationBack(int reqId, String destinationJson, double linearSpeed, double angularSpeed, ActionListener listener) {
        NavigationBean bean = new NavigationBean();
        bean.setReqId(reqId);
        bean.setDestination(destinationJson);
        bean.setLinearSpeed(linearSpeed);
        bean.setAngularSpeed(angularSpeed);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 32, jsonStr, listener);
    }

    public int stopNavigationBack(int reqId) {
        return this.stopAction(reqId, 32, true);
    }

    public int stopAllAction(int reqId) {
        return this.stopAction(reqId, 65535, true);
    }

    public int startAngleResetAction(int reqId, String destination, String poseJson, ActionListener listener) {
        AngleResetBean bean = new AngleResetBean();
        bean.setReqId(reqId);
        if (!TextUtils.isEmpty((CharSequence)destination)) {
            bean.setDestination(destination);
        }
        if (!TextUtils.isEmpty((CharSequence)poseJson)) {
            bean.setPoseJson(poseJson);
        }
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 33, jsonStr, listener);
    }

    public int stopAngleResetAction(int reqId) {
        return this.stopAction(reqId, 33, true);
    }

    public int getAskWayList(int reqId, CommandListener listener) {
        CommandBean commandBean = new CommandBean("cmd_remote_get_ask_way_list", null, false);
        return this.startAction(reqId, 267, mGson.toJson((Object)commandBean), this.parseCommand(listener));
    }

    private static String getParamJsonObjectString(Map<String, Object> map) {
        try {
            JSONObject param = new JSONObject();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                param.put(entry.getKey(), entry.getValue());
            }
            return param.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int updateRnInstallStatus(int reqId, String installId, int status, String message, CommandListener listener) {
        JSONObject params = new JSONObject();
        try {
            params.put("json_rn_install_id", (Object)installId);
            params.put("json_rn_install_status", status);
            params.put("json_rn_install_message", (Object)message);
            CommandBean bean = new CommandBean("cmd_remote_rn_install_status", params.toString(), false);
            return this.startAction(reqId, 268, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startPictureReport(int reqId, double intervalTime, CommandListener listener) {
        new RuntimeException("\u5408\u5e76\u63a5\u53e3\uff0c\u7a7a\u5b9e\u73b0").printStackTrace();
        try {
            listener.onError(-1, "\u4e0d\u652f\u6301");
            listener.onError(-1, "\u4e0d\u652f\u6301", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public int stopPictureReport(int reqId, CommandListener listener) {
        new RuntimeException("\u5408\u5e76\u63a5\u53e3\uff0c\u7a7a\u5b9e\u73b0").printStackTrace();
        try {
            listener.onError(-1, "\u4e0d\u652f\u6301");
            listener.onError(-1, "\u4e0d\u652f\u6301", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public int startBodyReport(int reqId, double intervalTime, CommandListener listener) {
        new RuntimeException("\u5408\u5e76\u63a5\u53e3\uff0c\u7a7a\u5b9e\u73b0").printStackTrace();
        try {
            listener.onError(-1, "\u4e0d\u652f\u6301");
            listener.onError(-1, "\u4e0d\u652f\u6301", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public int stopBodyReport(int reqId, CommandListener listener) {
        new RuntimeException("\u5408\u5e76\u63a5\u53e3\uff0c\u7a7a\u5b9e\u73b0").printStackTrace();
        try {
            listener.onError(-1, "\u4e0d\u652f\u6301");
            listener.onError(-1, "\u4e0d\u652f\u6301", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public int startVision(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_start_vision", null, false);
        return this.startAction(reqId, 304, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int stopVision(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_stop_vision", null, false);
        return this.startAction(reqId, 305, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    @Deprecated
    public int startBackupVision(int reqId, CommandListener listener) {
        Log.d((String)TAG, (String)"startBackupVision");
        CommandBean bean = new CommandBean("cmd_backup_start_vision", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    @Deprecated
    public int stopBackupVision(int reqId, CommandListener listener) {
        Log.d((String)TAG, (String)"stopBackupVision");
        CommandBean bean = new CommandBean("cmd_backup_stop_vision", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public boolean updateStandbyStatus(boolean standbyStart, String jsonData) {
        try {
            HashMap<String, String> robotHashMap = (HashMap<String, String>)mGson.fromJson(jsonData, new TypeToken<Map<String, Object>>(){}.getType());
            if (null == robotHashMap) {
                robotHashMap = new HashMap<String, String>();
            }
            String standbyStatus = standbyStart ? "start" : "stop";
            robotHashMap.put("standby_status", standbyStatus);
            return this.mModuleRegistry.updateSystemStatus("system_standby", mGson.toJson(robotHashMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int robotStandby(int reqId, CommandListener listener) {
        RobotStandbyBean bean = new RobotStandbyBean();
        return this.robotStandby(reqId, bean, listener);
    }

    public int robotStandby(int reqId, RobotStandbyBean bean, CommandListener listener) {
        bean.setReqId(reqId);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 42, jsonStr, listener);
    }

    public int robotStandbyEnd(int reqId) {
        return this.stopAction(reqId, 42, false);
    }

    public int stopHorizontalTurnHead(int reqId) {
        try {
            return this.mModuleRegistry.stopAction(reqId, 40, true);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -101;
        }
    }

    public int skillDataReport(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_skill_data_report", param, false);
        return this.startAction(reqId, 314, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public boolean getChargeStatus() {
        boolean isCharging = false;
        try {
            String result = this.mModuleRegistry.getRobotInfo(101, null);
            isCharging = Boolean.parseBoolean(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return isCharging;
    }

    public int getBatteryLevel() {
        String batteryLevel = "";
        try {
            batteryLevel = this.mModuleRegistry.getRobotInfo(102, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)batteryLevel)) {
            return Integer.parseInt(batteryLevel);
        }
        return 0;
    }

    public int setLockEnable(int reqId, int type, int bord, boolean enable) {
        try {
            JSONObject param = new JSONObject();
            param.put("door_type", type);
            param.put("board", bord);
            param.put("lock_enable", enable);
            CommandBean bean = new CommandBean("cmd_can_set_lock_enable", param.toString(), false);
            return this.startAction(reqId, 321, mGson.toJson((Object)bean), null);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int getDoorStatus(int reqId, int type, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("door_type", type);
            CommandBean bean = new CommandBean("cmd_can_get_door_status", param.toString(), false);
            return this.startAction(reqId, 322, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int getLanguageList(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_get_language_list", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public String getInspectResult() {
        String inspectionResult = null;
        try {
            inspectionResult = this.mModuleRegistry.getRobotInfo(103, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return inspectionResult;
    }

    public String getVersion() {
        return RobotSettings.getVersion();
    }

    public boolean isRobotEstimate() {
        boolean estimate = false;
        try {
            String result = this.mModuleRegistry.getRobotInfo(105, null);
            estimate = Boolean.parseBoolean(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return estimate;
    }

    public boolean isChargePileExits() {
        boolean exits = false;
        try {
            String result = this.mModuleRegistry.getRobotInfo(106, null);
            exits = Boolean.parseBoolean(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return exits;
    }

    public boolean isSupportHeadReverse() {
        boolean support = false;
        try {
            String result = this.mModuleRegistry.getRobotInfo(107, null);
            support = Boolean.parseBoolean(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return support;
    }

    public boolean isRobotInlocations(@NonNull String name, double range) {
        boolean inLocation = false;
        try {
            JSONObject params = new JSONObject();
            params.put("name", (Object)name);
            params.put("range", range);
            String result = this.mModuleRegistry.getRobotInfo(108, params.toString());
            inLocation = Boolean.parseBoolean(result);
        }
        catch (RemoteException | JSONException e) {
            e.printStackTrace();
        }
        return inLocation;
    }

    public boolean isInReceptionLocation() {
        boolean inLocation = false;
        try {
            String result = this.mModuleRegistry.getRobotInfo(109, null);
            inLocation = Boolean.parseBoolean(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return inLocation;
    }

    public double getPlaceDistance(String placeName) {
        double distance = 0.0;
        try {
            String result = this.mModuleRegistry.getRobotInfo(110, placeName);
            distance = Double.parseDouble(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return distance;
    }

    public List<Pose> getPlaceList() {
        List list = null;
        try {
            String result = this.mModuleRegistry.getRobotInfo(115, null);
            list = (List)mGson.fromJson(result, new TypeToken<List<Pose>>(){}.getType());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return list;
    }

    public Pose getSpecialPose(String placeName) {
        Pose pose = null;
        try {
            String result = this.mModuleRegistry.getRobotInfo(111, placeName);
            pose = (Pose)mGson.fromJson(result, Pose.class);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return pose;
    }

    public Pose getCurrentPose() {
        Pose pose = null;
        try {
            String result = this.mModuleRegistry.getRobotInfo(112, null);
            pose = (Pose)mGson.fromJson(result, Pose.class);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return pose;
    }

    public CruiseRouteBean getNaviCruiseRoute() {
        CruiseRouteBean route = null;
        try {
            String result = this.mModuleRegistry.getRobotInfo(113, null);
            route = (CruiseRouteBean)mGson.fromJson(result, CruiseRouteBean.class);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return route;
    }

    public String getMapName() {
        try {
            return this.mModuleRegistry.getRobotInfo(114, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void getRobotStatus(String type, StatusListener listener) {
        try {
            if (listener == null || this.mModuleRegistry == null) {
                return;
            }
            StatusDispatcher statusListener = null;
            if (this.mResponseThread != null) {
                Looper looper = this.mResponseThread.getLooper();
                statusListener = this.mMessageDispatcher.obtainStatusDispatcher(looper, listener);
            } else {
                statusListener = this.mMessageDispatcher.obtainStatusDispatcher(listener);
            }
            this.mModuleRegistry.getRobotStatus(type, statusListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int capScreen(int reqId, int screenType, CommandListener listener) {
        JSONObject params = new JSONObject();
        try {
            params.put("screen_display_type", screenType);
            CommandBean bean = new CommandBean("cmd_can_cap_screen", params.toString(), false);
            return this.startAction(reqId, 325, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getCpuTemperature(int reqId, CommandListener listener) {
        JSONObject params = new JSONObject();
        CommandBean bean = new CommandBean("cmd_can_get_cpu_temperature", params.toString(), false);
        return this.startAction(reqId, 330, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public String getPipeInfo() {
        String pipeInfo = null;
        try {
            pipeInfo = this.mModuleRegistry.getRobotInfo(116, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return pipeInfo;
    }

    public String getMqttInfo() {
        String pipeInfo = null;
        try {
            pipeInfo = this.mModuleRegistry.getRobotInfo(117, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return pipeInfo;
    }

    public int getSensorStatus(int reqId, CommandListener listener) {
        JSONObject params = new JSONObject();
        CommandBean bean = new CommandBean("cmd_navi_get_sensor_status", params.toString(), false);
        return this.startAction(reqId, 341, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int updateRadarStatus(int reqId, boolean openRadar, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("openRadar", openRadar);
            CommandBean bean = new CommandBean("cmd_navi_set_radar_status", param.toString(), false);
            return this.startAction(reqId, 263, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int queryRadarStatus(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_query_radar_status", "", false);
            return this.startAction(reqId, 264, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getNaviConnectStatus(int reqId, CommandListener listener) {
        JSONObject params = new JSONObject();
        CommandBean bean = new CommandBean("cmd_navi_connect_status", params.toString(), false);
        return this.startAction(reqId, 342, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteRequestQrcodeMini(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_qrcode_mini", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int remoteBindStatusMini(int reqId, String sid, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_check_bind_status_mini", sid, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setObstaclesSafeDistance(int reqId, double distance, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("min_obstacles_distance", distance);
            CommandBean bean = new CommandBean();
            bean.setContinue(false);
            bean.setCmdType("cmd_navi_set_min_obstacles_distance");
            bean.setParams(param.toString());
            return this.startAction(reqId, 344, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int executeCardCmd(int reqId, String params, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_card_indicate_cmd_channel", params, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int resetObstaclesSafeDistance(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_reset_min_obstacles_distance", "", false);
            return this.startAction(reqId, 346, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean updateRobotStatus(int status) {
        try {
            return this.mModuleRegistry.updateRobotStatus(status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean switchScreen(boolean onOff) {
        try {
            return this.mModuleRegistry.switchScreen(onOff);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setLanguage(String language) {
        try {
            this.mModuleRegistry.setLanguage(language);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getFovCameraInfo(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_head_get_fov_camera_info", null, false);
        return this.startAction(reqId, 334, mGson.toJson((Object)bean), listener);
    }

    public int updatePlaceList(int reqId, List<PlaceBean> placeList, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_update_place_list", mGson.toJson(placeList), false);
        return this.startAction(reqId, 333, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int saveMappingPose(int reqId, Pose pose, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_add_mapping_pose", pose.toJson(), false);
        return this.startAction(reqId, 336, mGson.toJson((Object)bean), listener);
    }

    public int deleteMappingPose(int reqId, String name, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_delete_mapping_pose", name, false);
        return this.startAction(reqId, 337, mGson.toJson((Object)bean), listener);
    }

    public int renameMappingPose(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_rename_mapping_pose", param, false);
        return this.startAction(reqId, 340, mGson.toJson((Object)bean), listener);
    }

    public int renameMappingPose(int reqId, String newPoseName, String oldPoseName, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("old_posename", (Object)oldPoseName);
            param.put("new_posename", (Object)newPoseName);
            CommandBean bean = new CommandBean("cmd_navi_rename_mapping_pose", param.toString(), false);
            return this.startAction(reqId, 340, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int answerAppResult(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_video_app_answer", param, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
    }

    public int getUserListWithVideo(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_video_user_list", param, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
    }

    public int inviteCallApp(int reqId, String param, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_video_invite_call", param, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
    }

    public int startExtendMap(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_start_extend_map", "", false);
        return this.startAction(reqId, 349, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int cancelCreateMap(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_cancel_create_map", "", false);
        return this.startAction(reqId, 352, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getVisionResolution(int reqId, CommandListener listener) {
        JSONObject params = new JSONObject();
        CommandBean bean = new CommandBean("cmd_vision_get_resolution", params.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int leaveChargingPile(int reqId, float speed, float distance, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("distance", (Object)(distance + ""));
            jsonObject.put("speed", (Object)(speed + ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.startAction(reqId, 50, jsonObject.toString(), listener);
    }

    public int getVisionMode(int reqId, CommandListener listener) {
        JSONObject params = new JSONObject();
        CommandBean bean = new CommandBean("cmd_vision_get_vision_mode", params.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int judgeInChargingPile(int reqId, float coordinateDeviation, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("coordinateDeviation", (Object)String.valueOf(coordinateDeviation));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.startAction(reqId, 51, jsonObject.toString(), listener);
    }

    public int setChassisRelocation(int reqId, int mode, Pose pose, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            if (pose != null) {
                param.put("relocation_pose", (Object)pose.toJsonObject());
            }
            param.put("relocation_type", mode);
            CommandBean bean = new CommandBean("cmd_navi_set_relocation", param.toString(), false);
            return this.startAction(reqId, 353, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getDefWelcomeTTS(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_remote_get_default_welcome_tts", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int taskModeReport(int reqId, String taskId, String taskMode, int taskResult, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("task_id", (Object)taskId);
            jsonObject.put("task_mode", (Object)taskMode);
            jsonObject.put("task_result", taskResult);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CommandBean bean = new CommandBean("cmd_remote_task_mode_report", jsonObject.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int taskExecReport(int reqId, String taskId, String taskType, String execResult, String execData, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("task_id", (Object)taskId);
            jsonObject.put("task_type", (Object)taskType);
            jsonObject.put("exec_result", (Object)execResult);
            jsonObject.put("exec_data", (Object)execData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CommandBean bean = new CommandBean("cmd_remote_task_exec_report", jsonObject.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int taskCommandReport(int reqId, String cmdId, String cmdType, String execResult, String execData, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("cmd_id", (Object)cmdId);
            jsonObject.put("cmd_type", (Object)cmdType);
            jsonObject.put("exec_result", (Object)execResult);
            jsonObject.put("exec_data", (Object)execData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CommandBean bean = new CommandBean("cmd_remote_command_exec_report", jsonObject.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getSpecialDishLabels(int reqId, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        CommandBean bean = new CommandBean("cmd_remote_get_special_dish_labels", jsonObject.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getAppToken(int reqId, String app_type, String app_name, String app_version, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("app_type", (Object)app_type);
            jsonObject.put("app_name", (Object)app_name);
            jsonObject.put("app_version", (Object)app_version);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CommandBean bean = new CommandBean("cmd_remote_get_app_token", jsonObject.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int isRobotHasVision(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_is_has_vision", "", false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
    }

    public int resetPoseEstimate(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_reset_estimate", "", false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
    }

    public int getMultiFunctionSwitchState(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_multi_func_switch_state", "", false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int takePicture(int reqId, String params, CommandListener listener) {
        return this.getFovCameraStatus(reqId, -1, 0, listener);
    }

    public int uploadCruisePicture(int reqId, String params, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_upload_cruise_picture", params, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int queryMultipleMapMatchStatus(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_query_multiple_map_status", null, false);
            return this.startAction(reqId, 356, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int getMapInfo(int reqId, String mapName, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            CommandBean bean = new CommandBean("cmd_navi_get_map_info", param.toString(), false);
            return this.startAction(reqId, 365, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setMapSyncState(int reqId, String mapName, int syncState, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            param.put("syncState", syncState);
            CommandBean bean = new CommandBean("cmd_navi_set_map_sync_state", param.toString(), false);
            return this.startAction(reqId, 366, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setMapFinishState(int reqId, String mapName, int finishState, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            param.put("finishState", finishState);
            CommandBean bean = new CommandBean("cmd_navi_set_map_finish_state", param.toString(), false);
            return this.startAction(reqId, 368, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setMapForbidLineFlag(int reqId, String mapName, int forbidFlag, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            param.put("forbidLine", forbidFlag);
            CommandBean bean = new CommandBean("cmd_navi_set_map_forbid_line", param.toString(), false);
            return this.startAction(reqId, 370, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setMapUpdateTime(int reqId, String mapName, long updateTime, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            param.put("updateTime", updateTime);
            CommandBean bean = new CommandBean("cmd_navi_set_map_update_time", param.toString(), false);
            return this.startAction(reqId, 369, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void disableFunctionKey() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"Disable function key failed, mModuleRegistry is null");
                return;
            }
            this.mModuleRegistry.disableFunctionKey();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void enableFunctionKey() {
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"enable function key failed, mModuleRegistry is null");
                return;
            }
            this.mModuleRegistry.enableFunctionKey();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String reportTask(TaskProxy task) {
        if (task == null) {
            return null;
        }
        try {
            return this.mModuleRegistry.reportTask(task.generateTask());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reportTaskEvent(TaskEventProxy taskEvent) {
        if (taskEvent == null) {
            return;
        }
        try {
            this.mModuleRegistry.reportTaskEvent(taskEvent.generateTaskEvent());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public List<Task> getCurrentTasks() {
        try {
            return this.mModuleRegistry.getCurrentTask();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new ArrayList<Task>();
        }
    }

    public int moduleCodeConfigUpload(int reqId, String moduleCode, String description, String configName, String configJson, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("module_code", (Object)moduleCode);
            jsonObject.put("description", (Object)description);
            jsonObject.put("config_name", (Object)configName);
            jsonObject.put("config_json", (Object)configJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CommandBean bean = new CommandBean("cmd_remote_module_code_config_upload", jsonObject.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int getCanPsbMotorVersion(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_can_get_psb_s_version", null, false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
    }

    public int setPowerLpm(int reqId, String params) {
        try {
            CommandBean bean = new CommandBean("cmd_can_set_power_lpm", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int pushTaskReport(int reqId, List<PushReportBean> pushReportBeans, CommandListener listener) {
        if (pushReportBeans == null || pushReportBeans.size() <= 0) {
            return -1;
        }
        try {
            CommandBean bean = new CommandBean("cmd_remote_push_task_report", mGson.toJson(pushReportBeans), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int parseChassisMapData(int reqId, String mapName, String dataType, CommandListener listener) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mapName", (Object)mapName);
            jsonObject.put("dataType", (Object)dataType);
            CommandBean bean = new CommandBean("cmd_navi_parse_map_data", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setMultiRobotSettingConfig(int reqId, String params, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_set_multi_robot_config", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getLocalAndServerSupportLanguageList() {
        String languageList = "";
        try {
            if (this.mModuleRegistry == null) {
                Log.d((String)TAG, (String)"Get language failed, mModuleRegistry is null");
                return languageList;
            }
            languageList = this.mModuleRegistry.getRobotInfo(120, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return languageList;
    }

    public int floorPositionList(int reqId, String floorId, String posName, String padZcbPlateBackTableTaskStatus, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("floor_id", (Object)floorId);
            jsonObject.put("pos_name", (Object)posName);
            jsonObject.put("pad_zcb_plate_back_table_task_status", (Object)padZcbPlateBackTableTaskStatus);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_floor_position_list", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskGroupQueue(int reqId, String allowTaskType, String taskGroupTypeList, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("allow_task_type", (Object)allowTaskType);
            jsonObject.put("task_group_type_list", (Object)taskGroupTypeList);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_group_queue", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskCreate(int reqId, String parentTaskOutId, String taskType, String taskList, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("parent_task_outid", (Object)parentTaskOutId);
            jsonObject.put("task_type", (Object)taskType);
            jsonObject.put("task_list", (Object)taskList);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_create", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskTake(int reqId, String taskId, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("task_id", (Object)taskId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_take", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskManual(int reqId, String taskId, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("task_id", (Object)taskId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_manual", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getMultiRobotSettingConfig(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_get_multiRobot_config", null, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskCancel(int reqId, String taskId, String cancelResult, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("task_id", (Object)taskId);
            jsonObject.put("cancel_result", (Object)cancelResult);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_cancel", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskSucc(int reqId, String taskId, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("task_id", (Object)taskId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_succ", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int sendMultiRobotMessage(int reqId, String params, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_send_multiRobot_message", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int taskPosQrcode(int reqId, String qrcodeType, String posName, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("qrcode_type", (Object)qrcodeType);
            jsonObject.put("pos_name", (Object)posName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            CommandBean bean = new CommandBean("remote_task_pos_qrcode", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int switchWheelControlMode(int reqId, Definition.WheelControlMode controlMode) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("wheel_mode", controlMode.getValue());
            CommandBean bean = new CommandBean("cmd_navi_set_wheel_control_mode", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getNaviPathInfo(int reqId, Pose startPose, Pose endPose, CommandListener listener) {
        JSONObject jsonObject = new JSONObject();
        JSONObject startPoseJson = new JSONObject();
        JSONObject endPoseJson = new JSONObject();
        try {
            startPoseJson.put("x", (double)startPose.getX());
            startPoseJson.put("y", (double)startPose.getY());
            startPoseJson.put("theta", (double)startPose.getTheta());
            endPoseJson.put("x", (double)endPose.getX());
            endPoseJson.put("y", (double)endPose.getY());
            endPoseJson.put("theta", (double)endPose.getTheta());
            jsonObject.put("start_pose", (Object)startPoseJson);
            jsonObject.put("end_pose", (Object)endPoseJson);
            CommandBean bean = new CommandBean("cmd_navi_get_navi_path_info", jsonObject.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getNaviPathInfoToGoals(int reqId, List<String> goalsName, CommandListener listener) {
        if (goalsName == null || goalsName.size() == 0) {
            return -1;
        }
        JSONArray array = new JSONArray();
        for (String goalName : goalsName) {
            JSONObject object = new JSONObject();
            try {
                object.put("name", (Object)goalName);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return -1;
            }
            array.put((Object)object);
        }
        CommandBean bean = new CommandBean("cmd_navi_get_navi_path_info_to_goals", array.toString(), false);
        return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
    }

    public int getMaskInfoById(int reqId, int id, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("id", id);
            param.put("count", 1);
            CommandBean bean = new CommandBean("cmd_head_get_mask_info_by_id", param.toString(), false);
            return this.startAction(reqId, 376, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getAdditionalDevices(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_get_additional_devices", "", false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setMappingPlace(int reqId, String mapName, int placeType, String placeCnName, String placeId, String mappingPlaceId, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            param.put("place_type", placeType);
            param.put("place_cn_name", (Object)placeCnName);
            param.put("place_id", (Object)placeId);
            param.put("mapping_place_id", (Object)mappingPlaceId);
            CommandBean bean = new CommandBean("cmd_navi_set_mapping_place", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getMappingInfo(int reqId, String mapName, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapName", (Object)mapName);
            CommandBean bean = new CommandBean("cmd_navi_get_mapping_info", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setNavigationLineData(int reqId, boolean enabled) {
        try {
            JSONObject param = new JSONObject();
            param.put("json_navi_enalbe_line_data", enabled);
            CommandBean bean = new CommandBean("cmd_navi_enable_report_line_data", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setNavigationRgbdDepthImage(int reqId, boolean enabled) {
        try {
            JSONObject param = new JSONObject();
            param.put("json_navi_enalbe_rgbd_depth_image", enabled);
            CommandBean bean = new CommandBean("cmd_navi_enable_rgbd_depth_image", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setNavigationTopIRImage(int reqId, boolean enabled) {
        try {
            JSONObject param = new JSONObject();
            param.put("json_navi_enalbe_top_ir_image", enabled);
            CommandBean bean = new CommandBean("cmd_navi_enable_top_ir_image", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setXDPowerEnable(int reqId, boolean enabled, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("param_xd_power", enabled);
            CommandBean bean = new CommandBean("cmd_can_set_xd_power_enable", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setXDFanEnable(int reqId, boolean enable, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("param_xd_fan", enable);
            CommandBean bean = new CommandBean("cmd_can_set_xd_fan_enable", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setXDRank(int reqId, int rank, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("param_xd_rank", rank);
            CommandBean bean = new CommandBean("cmd_can_set_xd_rank", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int goCharging(int reqId) {
        this.ctx.sendBroadcast(new Intent("com.ainirobot.moduleapp.action.ui.low_power_auto_charge_start"));
        return 1;
    }

    public int startDataSetRecord(int reqId, String sensor) {
        try {
            JSONObject param = new JSONObject();
            param.put("navi_data_type", (Object)sensor);
            CommandBean bean = new CommandBean("cmd_navi_start_data_set_record", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int stopDataSetRecord(int reqId, boolean isLocalData) {
        try {
            JSONObject param = new JSONObject();
            param.put("json_navi_save_loacal_sensor_data", isLocalData);
            CommandBean bean = new CommandBean("cmd_navi_stop_data_set_record", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int uploadNaviDataSet(int reqId, String sensor) {
        try {
            JSONObject param = new JSONObject();
            param.put("navi_data_type", (Object)sensor);
            CommandBean bean = new CommandBean("cmd_navi_upload_navi_data_set", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int queryMultiFloorConfig(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_query_multi_floor_config", null, false);
            return this.startAction(reqId, 379, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getMultiFloorConfigAndPose(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_get_multi_floor_config_and_pose", null, false);
            return this.startAction(reqId, 383, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getMultiFloorConfigAndCommonPose(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_get_multi_floor_config_and_common_pose", null, false);
            return this.startAction(reqId, 389, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int insertMultiFloorConfig(int reqId, String param, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_insert_multi_floor_config", param, false);
            return this.startAction(reqId, 380, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateMultiFloorConfigFloorState(int reqId, int floorId, String mapName, int floorState, CommandListener listener) {
        try {
            JSONObject valueObj = new JSONObject();
            valueObj.put("floorId", floorId);
            valueObj.put("mapName", (Object)mapName);
            valueObj.put("floorState", floorState);
            JSONObject param = new JSONObject();
            param.put("type", (Object)"json_navi_multi_floor_update_floor_state");
            param.put("value", (Object)valueObj.toString());
            return this.updateMultiFloorConfig(reqId, param.toString(), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateMultiFloorConfigFloorIndex(int reqId, int floorId, String mapName, int floorIndex, CommandListener listener) {
        try {
            JSONObject valueObj = new JSONObject();
            valueObj.put("floorId", floorId);
            valueObj.put("mapName", (Object)mapName);
            valueObj.put("floorIndex", floorIndex);
            JSONObject param = new JSONObject();
            param.put("type", (Object)"json_navi_multi_floor_update_floor_index");
            param.put("value", (Object)valueObj.toString());
            return this.updateMultiFloorConfig(reqId, param.toString(), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateMultiFloorConfigFloorAlias(int reqId, int floorId, String mapName, String floorAlias, CommandListener listener) {
        try {
            JSONObject valueObj = new JSONObject();
            JSONObject param = new JSONObject();
            valueObj.put("floorId", floorId);
            valueObj.put("mapName", (Object)mapName);
            valueObj.put("floorAlias", (Object)floorAlias);
            param.put("type", (Object)"json_navi_multi_floor_update_floor_alias");
            param.put("value", (Object)valueObj.toString());
            return this.updateMultiFloorConfig(reqId, param.toString(), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateMultiFloorConfigElevators(int reqId, int floorId, String mapName, List<String> availableElevators, CommandListener listener) {
        try {
            JSONObject valueObj = new JSONObject();
            JSONObject param = new JSONObject();
            valueObj.put("floorId", floorId);
            valueObj.put("mapName", (Object)mapName);
            valueObj.put("availableElevators", availableElevators);
            param.put("type", (Object)"json_navi_multi_floor_update_elevators");
            param.put("value", (Object)valueObj.toString());
            return this.updateMultiFloorConfig(reqId, param.toString(), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateMultiFloorConfig(int reqId, String param, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_update_multi_floor_config", param, false);
            return this.startAction(reqId, 381, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int removeMultiFloorConfigById(int reqId, int floorId, String mapName, CommandListener listener) {
        try {
            JSONObject valueObj = new JSONObject();
            valueObj.put("floorId", floorId);
            valueObj.put("mapName", (Object)mapName);
            CommandBean bean = new CommandBean("cmd_navi_remove_multi_floor_config", valueObj.toString(), false);
            return this.startAction(reqId, 382, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int openElevatorDoor(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_control_open_elevator_door", null, false);
            return this.startAction(reqId, 384, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int closeElevatorDoor(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_control_close_elevator_door", null, false);
            return this.startAction(reqId, 385, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int releaseElevator(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_control_release_elevator", null, false);
            return this.startAction(reqId, 386, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int callElevatorToTargetFloor(int reqId, int currentFloor, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("target_floor", currentFloor);
            CommandBean bean = new CommandBean("cmd_control_call_elevator", param.toString(), false);
            return this.startAction(reqId, 387, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getElevatorStatus(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_control_get_elevator_status", null, false);
            return this.startAction(reqId, 388, mGson.toJson((Object)bean), this.parseCommand(listener));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int startElevatorNavigation(int reqId, String destination, int floor, ActionListener listener) {
        NavigationAdvancedBean bean = new NavigationAdvancedBean();
        bean.setReqId(reqId);
        bean.setDestination(destination);
        bean.setTargetFloor(floor);
        bean.setNaviStrategy(Definition.AdvNaviStrategy.ELEVATOR);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 52, jsonStr, listener);
    }

    public int startMultiRobotNavigation(int reqId, String destination, Definition.AdvNaviStrategy advNaviStrategy, List<String> standbyDesList, String navigationParams, ActionListener listener) {
        NavigationAdvancedBean bean = new NavigationAdvancedBean();
        bean.setReqId(reqId);
        bean.setDestination(destination);
        bean.setNaviStrategy(advNaviStrategy);
        bean.setStandbyDesList(standbyDesList);
        bean.setNavigationParams(navigationParams);
        String jsonStr = mGson.toJson((Object)bean);
        return this.startAction(reqId, 52, jsonStr, listener);
    }

    public int startElevatorNavigation(int reqId, String destination, int floor, double coordinateDeviation, long time, double linearSpeed, double angularSpeed, boolean isAdjustAngle, double destinationRange, int wheelOverCurrentRetryCount, long multipleWaitTime, int priority, double linearAcceleration, double angularAcceleration, ActionListener listener) {
        NavigationAdvancedBean bean = new NavigationAdvancedBean();
        bean.setReqId(reqId);
        bean.setDestination(destination);
        bean.setTargetFloor(floor);
        bean.setTime(time);
        bean.setCoordinateDeviation(coordinateDeviation);
        bean.setLinearSpeed(linearSpeed);
        bean.setAngularSpeed(angularSpeed);
        bean.setAdjustAngle(isAdjustAngle);
        bean.setDestinationRange(destinationRange);
        bean.setWheelOverCurrentRetryCount(wheelOverCurrentRetryCount);
        bean.setMultipleWaitTime(multipleWaitTime);
        bean.setPriority(priority);
        bean.setLinearAcceleration(linearAcceleration);
        bean.setAngularAcceleration(angularAcceleration);
        String jsonStr = mGson.toJson((Object)bean);
        bean.setNaviStrategy(Definition.AdvNaviStrategy.ELEVATOR);
        return this.startAction(reqId, 52, jsonStr, listener);
    }

    public int stopAdvanceNavigation(int reqId) {
        return this.stopAction(reqId, 52, true);
    }

    public boolean hasTopIR() {
        try {
            return this.mModuleRegistry != null && this.mModuleRegistry.hasTopIR();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int uvcSingleClassify(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_uvc_camera_single_classify", "", false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int uvcContinueClassify(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_uvc_camera_continue_classify", "", false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int uvcStopContinueClassify(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_uvc_camera_continue_classify_stop", "", false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int queryUvcCameraConnectedStatus(int reqId, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_query_uvc_camera_connected_status", "", false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean hasChargeIR() {
        try {
            return this.mModuleRegistry != null && this.mModuleRegistry.hasChargeIR();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isUseProZcbLed() {
        try {
            return this.mModuleRegistry != null && this.mModuleRegistry.isUseProZcbLed();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int setProZcbLedEffect(int reqId, int proZcbEffect, CommandListener listener) {
        if (!this.isUseProZcbLed()) {
            if (listener != null) {
                listener.onResult(-6, "failed", "");
            }
            return -6;
        }
        try {
            JSONObject param = new JSONObject();
            param.put("json_can_pro_zcb_effect", proZcbEffect);
            CommandBean bean = new CommandBean("cmd_zcb_led_effect", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean isHasProTrayLED() {
        try {
            return this.mModuleRegistry != null && this.mModuleRegistry.isHasProTrayLED();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int setProTrayLedEffect(int reqId, int trayLedEffect, CommandListener listener) {
        if (!this.isHasProTrayLED()) {
            if (listener != null) {
                listener.onResult(-6, "failed", "");
            }
            return -6;
        }
        try {
            JSONObject param = new JSONObject();
            param.put("JSON_CAN_TRAY_LED_EFFECT", trayLedEffect);
            CommandBean bean = new CommandBean("cmd_tray_led_effect", param.toString(), false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int isMapHasVision(int reqId, int mapType, CommandListener listener) {
        try {
            JSONObject param = new JSONObject();
            param.put("mapType", mapType);
            CommandBean bean = new CommandBean("cmd_navi_map_has_vision", param.toString(), false);
            return this.startAction(reqId, 392, mGson.toJson((Object)bean), listener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int uploadExtraFilePkg(int reqId, String mapName, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_remote_upload_extra_file_pkg", mapName, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int downloadExtraFilePkg(int reqId, String params, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_remote_download_extra_file_pkg", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setExtraFileData(int reqId, String params, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_set_extra_file_data", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int zipMapFile(int reqId, String params, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_zip_map_file", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int unzipMapFile(int reqId, String params, CommandListener listener) {
        try {
            CommandBean bean = new CommandBean("cmd_navi_unzip_map_file", params, false);
            return this.startAction(reqId, 100, mGson.toJson((Object)bean), listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int downLoadWholeMapPkg(int reqId, String params, CommandListener listener) {
        try {
            return this.startAction(reqId, 231, params, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int stopDownLoadWholeMapPkg(int reqId) {
        try {
            return this.stopAction(reqId, 231, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getLocalMapNameList(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_local_map_name_list", "", false);
        return this.startAction(reqId, 393, mGson.toJson((Object)bean), listener);
    }

    public int getLocalMapInfoList(int reqId, CommandListener listener) {
        CommandBean bean = new CommandBean("cmd_navi_get_local_map_info_list", "", false);
        return this.startAction(reqId, 394, mGson.toJson((Object)bean), listener);
    }

    public boolean hasMono() {
        try {
            return this.mModuleRegistry.hasMono();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

