/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client;

import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.client.RobotSettings;
import com.ainirobot.coreservice.utils.FileUtils;
import com.ainirobot.coreservice.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ProductInfo {
    private static final String TAG = "ProductInfo";
    public static final String SWIPE_THERMAL_PRODUCT_ID = "\u4ea7\u54c1ID";
    public static final String HEXIN_ID = "1";
    public static final String JUGE_ID = "2";
    private static final String DEVICE_PROPERTIES = "device.properties";
    private static final String DEVICE_CONFIG_DIR = "/persist/orionoem/";
    private static final String PRODUCT_MODEL = RobotSettings.getProductModel();

    public static boolean isMiniProduct() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOB.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOB_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOC.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOC_OLD.model);
    }

    public static boolean isDeliveryProduct() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BASE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BASE_LANDSCAPE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS_LANDSCAPE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_XD.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BIG_SCREEN.model);
    }

    public static boolean isOverSea() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS_LANDSCAPE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOB_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_XIAOMI_PLUS_OVERSEAS.model);
    }

    public static boolean isDeliveryOverSea() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS_LANDSCAPE.model);
    }

    public static boolean isLaraForSale() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_BIGSCREEN_COSTDOWN.model);
    }

    public static boolean isMeissa1P5() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_XIAOMI_1P5.model);
    }

    public static boolean isMeissaPlus() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_XIAOMI_PLUS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_XIAOMI_PLUS_OVERSEAS.model);
    }

    public static boolean isSaiphXD() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_XD.model);
    }

    public static boolean isSaiphBigScreen() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BIG_SCREEN.model);
    }

    public static boolean isSaiphXdOrBigScreen() {
        return ProductInfo.isSaiphXD() || ProductInfo.isSaiphBigScreen();
    }

    public static boolean isMiniOverSea() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOB_OVERSEAS.model);
    }

    public static boolean isSaiphChargeIr() {
        return (TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BASE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS.model)) && FileUtils.hasChargeIR();
    }

    public static boolean isSaiphRgbdFm1() {
        return (TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BASE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS_LANDSCAPE.model)) && FileUtils.hasRgbdFm1();
    }

    public static boolean isSaiphPro() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_BASE_LANDSCAPE.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_OVERSEAS_LANDSCAPE.model);
    }

    public static boolean isChargeIrProduct() {
        return ProductInfo.isSaiphChargeIr() || ProductInfo.isSaiphPro();
    }

    public static boolean isElevatorCtrlProduct() {
        return TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_DELIVERY_XD.model);
    }

    public static boolean isMiniProductSupportMultiRobot() {
        return (TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOB.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOB_OVERSEAS.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOC.model) || TextUtils.equals((CharSequence)PRODUCT_MODEL, (CharSequence)ProductModel.CM_MINI_TOC_OLD.model)) && FileUtils.hasEsp32();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDeviceProperties() {
        File file = new File(DEVICE_CONFIG_DIR, DEVICE_PROPERTIES);
        if (!file.exists()) {
            Log.d((String)TAG, (String)"getDeviceProperties file is not exists.");
            return null;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        catch (IOException e) {
            Properties properties2;
            try {
                e.printStackTrace();
                properties2 = properties;
            }
            catch (Throwable throwable) {
                IOUtils.close(fis);
                throw throwable;
            }
            IOUtils.close(fis);
            return properties2;
        }
        IOUtils.close(fis);
        Log.d((String)TAG, (String)"getDeviceProperties: start --->>>");
        ProductInfo.printProperty(properties);
        Log.d((String)TAG, (String)"getDeviceProperties: end <<<---");
        return properties;
    }

    private static void printProperty(Properties properties) {
        if (properties == null) {
            Log.d((String)TAG, (String)"printProperty properties is null");
            return;
        }
        for (Map.Entry<Object, Object> objectObjectEntry : properties.entrySet()) {
            Object key = objectObjectEntry.getKey();
            Object value = objectObjectEntry.getValue();
            Log.d((String)TAG, (String)("key=" + key + " value=" + value));
        }
    }

    public static enum ProductModel {
        CM_XIAOMI_BASE("CM-GB01N"),
        CM_XIAOMI_TW("CM-GB01NTW"),
        CM_XIAOMI_SWIPE_CARD("CM-GB02N"),
        CM_XIAOMI_MEIDI("CM-GB01M"),
        CM_XIAOMI_COSTDOWN("CM-GB02C"),
        CM_XIAOMI_HEXIN("CM-GB01R"),
        CM_XIAOMI_JUGE("CM-GB02R"),
        CM_XIAOMI_1p1("CM-GB01C"),
        CM_XIAOMI_MINI("CM-GB01T"),
        CM_XIAOMI_1P5("OS-R-SG02S"),
        CM_XIAOMI_PLUS("OS-R-DP01S"),
        CM_VASE_BASE("CM-GB01L"),
        CM_VASE_845("CM-GB02L"),
        CM_VASE_COSTDOWN("OS-R-SA03S"),
        CM_BIGSCREEN_821("CM-GB01D"),
        CM_BIGSCREEN_845("CM-GB02D"),
        CM_BIGSCREEN_COSTDOWN("CM-GB03D"),
        CM_KTV_BASE("CM-GB01K"),
        CM_POSTER_BIGSCREEN("CM-GB02K"),
        CM_KTV_845("OS-R-DG02S"),
        CM_CONVEYING_BASE("CM-GB01J"),
        CM_CONVEYING_HUAZHU("CM-GB02J"),
        CM_DATOU_BASE("CM-GB01H"),
        CM_DELIVERY_BASE("OS-R-DR01S"),
        CM_DELIVERY_BASE_LANDSCAPE("OS-R-DR02S"),
        CM_DELIVERY_XD("OS-R-XD01"),
        CM_DELIVERY_BIG_SCREEN("OS-R-AD01S"),
        CM_DELIVERY_OVERSEAS("OS-R-DR01"),
        CM_DELIVERY_OVERSEAS_LANDSCAPE("OS-R-DR02"),
        CM_MINI_TOB_OVERSEAS("OS-R-SD03"),
        CM_XIAOMI_PLUS_OVERSEAS("OS-R-DP01"),
        CM_MINI_TOB("OS-R-SD01B"),
        CM_MINI_TOC("OS-R-SD01S"),
        CM_MINI_TOC_OLD("OS-DB01D");

        private static String TAG;
        public final String model;

        private ProductModel(String model) {
            this.model = model;
        }

        static {
            TAG = ProductModel.class.getSimpleName();
        }
    }
}

