/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client;

import android.content.Context;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.client.ApiListener;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.client.messagedispatcher.MessageDispatcher;
import java.util.ArrayList;
import java.util.Vector;

public abstract class BaseApi {
    public Vector<ApiListener> listeners = new Vector();
    protected Context ctx;
    public volatile boolean mIsServiceConnected = false;
    protected MessageDispatcher mMessageDispatcher = new MessageDispatcher();
    protected ArrayList<BaseSubApi> mSubApiList = new ArrayList();
    protected IRobotBinderPool mRobotBinderPool = null;

    public BaseApi(Context ctx) {
        this.ctx = ctx;
    }

    public BaseApi() {
    }

    public void connectApi() {
    }

    public void disconnectApi() {
    }

    public void addApiEventListener(ApiListener listener) {
        this.listeners.addElement(listener);
    }

    public boolean removeApiEventListener(ApiListener listener) {
        return this.listeners.removeElement(listener);
    }

    public void removeAllApiEventListeners() {
        this.listeners.removeAllElements();
    }

    protected void notifyEventApiDisabled() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ApiListener listener = this.listeners.elementAt(i);
            listener.handleApiDisabled();
        }
    }

    protected void notifyEventApiConnected() {
        this.mIsServiceConnected = true;
        for (BaseSubApi subApi : this.mSubApiList) {
            subApi.onConnect(this.mRobotBinderPool, this.ctx);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ApiListener listener = this.listeners.elementAt(i);
            listener.handleApiConnected();
        }
    }

    protected void notifyEventApiDisconnected() {
        this.mIsServiceConnected = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ApiListener listener = this.listeners.elementAt(i);
            listener.handleApiDisconnected();
        }
        for (BaseSubApi subApi : this.mSubApiList) {
            subApi.onDisconnect();
        }
    }

    public boolean isApiConnectedService() {
        return this.mIsServiceConnected;
    }
}

