/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.ainirobot.coreservice.bean.TaskEvent;
import java.util.Arrays;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Task
implements Cloneable,
Parcelable {
    public static final int TASK_STATUS_START = 1;
    public static final int TASK_STATUS_CANCEL = 2;
    public static final int TASK_STATUS_FAIL = 3;
    public static final int TASK_STATUS_FINISH = 4;
    public static final int TASK_MODE_BACKGROUND = 2;
    public static final int TASK_MODE_FOREGROUND = 1;
    private int status = 1;
    private int mode = 1;
    private String type = "";
    private String name = "";
    private String taskId = "";
    private TaskEvent[] subTaskList = null;
    private TaskEvent taskEvent = null;
    public static final Parcelable.Creator<Task> CREATOR = new Parcelable.Creator<Task>(){

        public Task createFromParcel(Parcel in) {
            return new Task(in);
        }

        public Task[] newArray(int size) {
            return new Task[size];
        }
    };

    public Task() {
    }

    protected Task(Parcel in) {
        this.status = in.readInt();
        this.mode = in.readInt();
        this.type = in.readString();
        this.name = in.readString();
        this.taskId = in.readString();
        this.subTaskList = (TaskEvent[])in.createTypedArray(TaskEvent.CREATOR);
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.status);
        dest.writeInt(this.mode);
        dest.writeString(this.type);
        dest.writeString(this.name);
        dest.writeString(this.taskId);
        dest.writeTypedArray((Parcelable[])this.subTaskList, 0);
    }

    public int describeContents() {
        return 0;
    }

    public void readFromParcel(Parcel reply) {
        this.status = reply.readInt();
        this.mode = reply.readInt();
        this.type = reply.readString();
        this.name = reply.readString();
        this.taskId = reply.readString();
        this.subTaskList = (TaskEvent[])reply.createTypedArray(TaskEvent.CREATOR);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public TaskEvent[] getSubTaskList() {
        return this.subTaskList;
    }

    public void setSubTaskList(TaskEvent[] subTaskList) {
        this.subTaskList = subTaskList;
    }

    public TaskEvent getTaskEvent() {
        return this.taskEvent;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        this.taskEvent = taskEvent;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return this.status == task.status && this.mode == task.mode && Objects.equals(this.type, task.type) && Objects.equals(this.name, task.name) && Arrays.equals(this.subTaskList, task.subTaskList);
    }

    public String toJson() {
        JSONObject object = new JSONObject();
        String task_status = "";
        switch (this.status) {
            case 2: {
                task_status = "task_status_cancel";
                break;
            }
            case 3: {
                task_status = "task_status_fail";
                break;
            }
            case 4: {
                task_status = "task_status_finish";
                break;
            }
            case 1: {
                task_status = "task_status_start";
                break;
            }
            default: {
                task_status = "task_status_start";
            }
        }
        try {
            object.put("task_status", (Object)task_status);
            object.put("task_id", (Object)this.taskId);
            object.put("task_name", (Object)this.name);
            object.put("task_type", (Object)this.type);
            object.put("task_mode", (Object)(this.mode == 2 ? "mode_background" : "mode_foreground"));
            if (this.subTaskList != null) {
                JSONArray subTaskArray = new JSONArray();
                for (TaskEvent event : this.subTaskList) {
                    subTaskArray.put((Object)event);
                }
                object.put("sub_task_list", (Object)subTaskArray);
            }
            object.put("event_info", (Object)(this.taskEvent == null ? "" : this.taskEvent.toJson()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    public String toString() {
        return this.toJson();
    }
}

