/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.ainirobot.coreservice.IInspectCallBack;
import com.ainirobot.coreservice.bean.Command;
import com.ainirobot.coreservice.config.ServiceConfig;
import java.util.ArrayList;
import java.util.List;

public interface IHWService
extends IInterface {
    public int getHWStatus() throws RemoteException;

    public List<Command> mount(String var1, ServiceConfig var2) throws RemoteException;

    public String getBoardName() throws RemoteException;

    public String getVersion(String var1) throws RemoteException;

    public void startUpgrade(String var1, String var2) throws RemoteException;

    public boolean isNeedUpgrade(String var1, String var2) throws RemoteException;

    public String exeSyncCommand(String var1, String var2, String var3) throws RemoteException;

    public void exeAsyncCommand(String var1, String var2, String var3) throws RemoteException;

    public boolean startStatusSocket(String var1, int var2) throws RemoteException;

    public boolean closeStatusSocket(String var1, int var2) throws RemoteException;

    public void startInspect(IInspectCallBack var1) throws RemoteException;

    public void reset() throws RemoteException;

    public void switchAppControl(String var1, String var2) throws RemoteException;

    public void setLanguage(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHWService {
        private static final String DESCRIPTOR = "com.ainirobot.coreservice.IHWService";
        static final int TRANSACTION_getHWStatus = 1;
        static final int TRANSACTION_mount = 2;
        static final int TRANSACTION_getBoardName = 3;
        static final int TRANSACTION_getVersion = 4;
        static final int TRANSACTION_startUpgrade = 5;
        static final int TRANSACTION_isNeedUpgrade = 6;
        static final int TRANSACTION_exeSyncCommand = 7;
        static final int TRANSACTION_exeAsyncCommand = 8;
        static final int TRANSACTION_startStatusSocket = 9;
        static final int TRANSACTION_closeStatusSocket = 10;
        static final int TRANSACTION_startInspect = 11;
        static final int TRANSACTION_reset = 12;
        static final int TRANSACTION_switchAppControl = 13;
        static final int TRANSACTION_setLanguage = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IHWService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IHWService) {
                return (IHWService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getHWStatus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ServiceConfig _arg1 = 0 != data.readInt() ? (ServiceConfig)ServiceConfig.CREATOR.createFromParcel(data) : null;
                    List _result = this.mount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getBoardName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _result = this.getVersion(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.startUpgrade(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.isNeedUpgrade(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _result = this.exeSyncCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.exeAsyncCommand(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.startStatusSocket(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.closeStatusSocket(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    IInspectCallBack _arg0 = IInspectCallBack.Stub.asInterface(data.readStrongBinder());
                    this.startInspect(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    this.reset();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.switchAppControl(_arg0, _arg1);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.setLanguage(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IHWService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getHWStatus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Command> mount(String name, ServiceConfig config) throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Command.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getBoardName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getVersion(String subsystem) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subsystem);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startUpgrade(String subsystem, String params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subsystem);
                    _data.writeString(params);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNeedUpgrade(String subsystem, String version) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subsystem);
                    _data.writeString(version);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String exeSyncCommand(String cmdType, String params, String language) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cmdType);
                    _data.writeString(params);
                    _data.writeString(language);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exeAsyncCommand(String cmdType, String params, String language) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cmdType);
                    _data.writeString(params);
                    _data.writeString(language);
                    this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startStatusSocket(String type, int socketPort) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(type);
                    _data.writeInt(socketPort);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean closeStatusSocket(String type, int socketPort) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(type);
                    _data.writeInt(socketPort);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void startInspect(IInspectCallBack callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void reset() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchAppControl(String packageName, String lastPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(lastPackageName);
                    this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void setLanguage(String language) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(language);
                    this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

