/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.ainirobot.coreservice.listener.IAccountListener;
import com.ainirobot.coreservice.listener.IActionListener;

public interface IAccountApi
extends IInterface {
    public String getMemberList() throws RemoteException;

    public void syncServerDataToLocale(IActionListener var1) throws RemoteException;

    public String getSystemToken() throws RemoteException;

    public String getRecentMember() throws RemoteException;

    public String getWholeMemberList() throws RemoteException;

    public void registerAccountListener(IAccountListener var1) throws RemoteException;

    public void unregisterAccountListener(IAccountListener var1) throws RemoteException;

    public void recoveryRobot(String var1, String var2, IActionListener var3) throws RemoteException;

    public String getRegisteredFaceList() throws RemoteException;

    public boolean reRegisterWithUserIdById(int var1, String var2, IActionListener var3) throws RemoteException;

    public boolean reRegisterWithUserIdByPic(String var1, String var2, IActionListener var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccountApi {
        private static final String DESCRIPTOR = "com.ainirobot.coreservice.IAccountApi";
        static final int TRANSACTION_getMemberList = 1;
        static final int TRANSACTION_syncServerDataToLocale = 2;
        static final int TRANSACTION_getSystemToken = 3;
        static final int TRANSACTION_getRecentMember = 4;
        static final int TRANSACTION_getWholeMemberList = 5;
        static final int TRANSACTION_registerAccountListener = 6;
        static final int TRANSACTION_unregisterAccountListener = 7;
        static final int TRANSACTION_recoveryRobot = 8;
        static final int TRANSACTION_getRegisteredFaceList = 9;
        static final int TRANSACTION_reRegisterWithUserIdById = 10;
        static final int TRANSACTION_reRegisterWithUserIdByPic = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAccountApi asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAccountApi) {
                return (IAccountApi)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getMemberList();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    IActionListener _arg0 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    this.syncServerDataToLocale(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getSystemToken();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getRecentMember();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getWholeMemberList();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    IAccountListener _arg0 = IAccountListener.Stub.asInterface(data.readStrongBinder());
                    this.registerAccountListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    IAccountListener _arg0 = IAccountListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterAccountListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    this.recoveryRobot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getRegisteredFaceList();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.reRegisterWithUserIdById(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.reRegisterWithUserIdByPic(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IAccountApi {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getMemberList() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncServerDataToLocale(IActionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSystemToken() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRecentMember() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getWholeMemberList() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAccountListener(IAccountListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAccountListener(IAccountListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoveryRobot(String userId, String userToken, IActionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(userId);
                    _data.writeString(userToken);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRegisteredFaceList() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reRegisterWithUserIdById(int personId, String userId, IActionListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(personId);
                    _data.writeString(userId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reRegisterWithUserIdByPic(String picturePath, String userId, IActionListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(picturePath);
                    _data.writeString(userId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

