/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.writer;

import android.content.Context;
import android.text.TextUtils;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.protocol.nano.DataManager;
import com.ainirobot.base.util.CommonUtils;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.util.SystemUtils;
import org.json.JSONObject;

public class PublicWriter {
    public static final int EXCEPTION_TYPE_CRASH = 1;
    public static final int EXCEPTION_TYPE_ANR = 2;
    public static final int EXCEPTION_TYPE_API = 3;
    public static final int EXCEPTION_TYPE_PERFORMANCE = 4;
    public static final int EXCEPTION_TYPE_FPS = 5;
    public static final int EXCEPTION_TYPE_CPU = 6;
    public static final int EXCEPTION_TYPE_MEMORY = 7;
    public static final int EXCEPTION_TYPE_TEMPERATURE = 8;
    public static final int EXCEPTION_TYPE_STORAGE = 9;
    public static final int EXCEPTION_TYPE_CPU_FRE = 10;
    public static final int EXCEPTION_TYPE_GPU_USAGE = 11;
    public static final int COLLAPSE_TYPE_NONE = 0;
    public static final int COLLAPSE_TYPE_JAVA = 1;
    public static final int COLLAPSE_TYPE_NATIVE = 2;
    public static final int COLLAPSE_TYPE_JS = 3;
    public static final int SOURCE_TYPE_SDK = 1;
    public static final int SOURCE_TYPE_SYS = 2;
    public static final String SOURCE_821 = "821";
    public static final String SOURCE_TK1 = "Tk1";
    public static final String SOURCE_TX1 = "TX1";

    public static DataManager.ReportData writePublic(String sessionId, String appName, String packageName, String appVersion, String className, String msg, int exceptionType, int platformType, String source, int sourceType) {
        return PublicWriter.writePublic(sessionId, appName, packageName, appVersion, className, msg, exceptionType, platformType, source, sourceType, System.currentTimeMillis(), "", "");
    }

    public static DataManager.ReportData writePublic(String sessionId, String appName, String packageName, String appVersion, String className, String msg, int exceptionType, int platformType, String source, int sourceType, long cTime, String cosAnrUrl, String cosLogUrl) {
        Context ctx = ApplicationWrapper.getApplicationContext();
        DataManager.ReportData reportData = new DataManager.ReportData();
        reportData.sessionId = PublicWriter.getSafeString(sessionId);
        reportData.brand = PublicWriter.getSafeString(SystemUtils.getSystemBrand());
        if (Constants.OPEN_SDK) {
            reportData.model = PublicWriter.getSafeString(LocalUtils.getModel());
            reportData.deviceID = PublicWriter.getSafeString(SystemUtils.getAndroidID(ctx));
            reportData.appPackage = PublicWriter.getSafeString(LocalUtils.getPackageName(ctx));
            reportData.appName = PublicWriter.getSafeString(LocalUtils.getAppName(ctx));
            reportData.appVersion = PublicWriter.getSafeString(LocalUtils.getVersionCode(ctx));
        } else {
            reportData.model = PublicWriter.getSafeString(SystemUtils.getSystemModel());
            reportData.deviceID = PublicWriter.getSafeString(SystemUtils.getSystemSerialNo());
            reportData.appVersion = PublicWriter.getSafeString(appVersion);
            reportData.appName = PublicWriter.getSafeString(appName);
            reportData.appPackage = PublicWriter.getSafeString(packageName);
        }
        reportData.ruid = PublicWriter.getSafeString(LocalUtils.getRobotUUID(ctx));
        reportData.corpid = PublicWriter.getSafeString(LocalUtils.getCorpUUID(ctx));
        reportData.clientId = PublicWriter.getSafeString(TextUtils.isEmpty((CharSequence)LocalUtils.getClientId()) ? Constants.CLIENT_ID : LocalUtils.getClientId());
        reportData.version = PublicWriter.getSafeString(SystemUtils.getSystemVersion());
        reportData.osType = LocalUtils.getOsType(ctx);
        reportData.androidVersion = PublicWriter.getSafeString(LocalUtils.getAndroidVersion());
        reportData.className = PublicWriter.getSafeString(className);
        reportData.stackMsg = PublicWriter.getSafeString(msg);
        reportData.env = CommonUtils.getDeviceState(ctx);
        reportData.appModuleName = "";
        reportData.netType = CommonUtils.getNetworkState(ApplicationWrapper.getApplicationContext());
        reportData.ctime = cTime;
        reportData.stackMsgType = exceptionType;
        reportData.errorPlatformType = platformType;
        reportData.sdkVersion = LocalUtils.getSDKVersion();
        reportData.duration = LocalUtils.getUseTime();
        reportData.jsRole = PublicWriter.getSafeString(LocalUtils.getJsRole());
        reportData.jsScene = PublicWriter.getSafeString(LocalUtils.getJsScene());
        reportData.source = PublicWriter.getSafeString(source);
        reportData.errorSourceType = sourceType;
        reportData.optJson = PublicWriter.getSafeString(LocalUtils.getOptJson());
        reportData.ovCorpId = PublicWriter.getSafeString(LocalUtils.getVoiceCorpId(ctx));
        reportData.cpu = PublicWriter.getSafeString(SystemUtils.getNumberOfCPUCores());
        reportData.memory = PublicWriter.getSafeString(SystemUtils.getTotalMemory());
        reportData.storage = PublicWriter.getSafeString(SystemUtils.getTotalStorage());
        if (!TextUtils.isEmpty((CharSequence)cosAnrUrl)) {
            reportData.stackMsgDetail = PublicWriter.getSafeString(cosAnrUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)cosLogUrl)) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("b_stack_msg_log", (Object)cosLogUrl);
                reportData.definedKv = jsonObject.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Constants.OPEN_SDK) {
            reportData.mcc = PublicWriter.getSafeString(SystemUtils.getMCC(ctx));
            reportData.cn = PublicWriter.getSafeString(LocalUtils.getChannelNumber());
            reportData.cl = PublicWriter.getSafeString(SystemUtils.getLanguage());
            reportData.mobileModel = PublicWriter.getSafeString(SystemUtils.getMobileModel());
            reportData.mnc = PublicWriter.getSafeString(SystemUtils.getMnc(ctx));
            reportData.vga = PublicWriter.getSafeString(SystemUtils.getResolution(ctx));
            reportData.dpi = PublicWriter.getSafeString(SystemUtils.getDensity(ctx));
            reportData.country = PublicWriter.getSafeString(SystemUtils.getCountry());
        }
        if (!Constants.OPEN_SDK) {
            reportData.cpuAbi = PublicWriter.getSafeString(SystemUtils.getCPUAbiList());
            reportData.platform = PublicWriter.getSafeString(LocalUtils.getRobotPlatform());
        }
        return reportData;
    }

    private static String getSafeString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

