/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.ShellUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;

public class SystemUtils {
    private static final String MODEL_KEY_ROBOT = "ro.product.model";
    private static final String BRAND_KEY_ROBOT = "ro.product.brand";
    private static final String CONFIG_FILE = "/robot/config/remote.properties";
    private static final String PLATFORM_KEY_ROBOT = "ro.product.name";
    private static final String QUALCOMMSN_KEY_ROBOT = "devid.qualcommSN";
    private static final String SYSTEM_RELEASE_VERSION = "ro.product.releasenum";
    private static final String BUILD_TYPE = "ro.build.type";
    public static final String RELEASE_BUILD_TYPE = "user";
    private static String mSerialNo = null;
    private static String mQualcommSN = null;
    private static String mSystemModel = null;
    private static String mSystemBrand = null;
    private static String mSystemPlatform = null;
    private static String mSystemVersion = null;
    private static String mMCC = null;
    private static String mMNC = null;
    private static String sAndroidID = null;
    private static String sTotalMemory = null;
    private static String sTotalStorage = null;
    public static final int DEVICEINFO_UNKNOWN = -1;
    public static String sCpuCores = null;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static String getSystemSerialNo() {
        if (mSerialNo == null) {
            mSerialNo = SystemUtils.getSystemSn();
        }
        return mSerialNo;
    }

    public static String getSystemQualcommSN() {
        if (mQualcommSN == null) {
            mQualcommSN = SystemUtils.getQualcommSN();
        }
        return mQualcommSN;
    }

    public static String getSystemModel() {
        if (mSystemModel == null) {
            mSystemModel = SystemUtils.getModel();
        }
        return mSystemModel;
    }

    public static String getSystemPlatform() {
        if (mSystemPlatform == null) {
            mSystemPlatform = SystemUtils.getPlatform();
        }
        return mSystemPlatform;
    }

    public static String getSystemBrand() {
        if (mSystemBrand == null) {
            mSystemBrand = SystemUtils.getBrand();
        }
        return mSystemBrand;
    }

    public static String getSystemVersion() {
        if (mSystemVersion == null) {
            mSystemVersion = SystemUtils.getSystemVer();
        }
        return mSystemVersion;
    }

    private static String getProperty(String key) {
        return SystemUtils.getProperty(key, CONFIG_FILE);
    }

    public static String getProperty(String key, String path) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        File root = Environment.getExternalStorageDirectory();
        File file = new File(root, path);
        Properties props = SystemUtils.loadProperty(file.getPath());
        if (props != null) {
            return props.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperty(String path) {
        FileInputStream in = null;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            in = new FileInputStream(path);
            properties.load(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            Properties properties2 = null;
            return properties2;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private static String getSystemSn() {
        String serialNum = "";
        try {
            Class<?> classz = Class.forName("com.ainirobot.coreservice.client.RobotSettings");
            Method method = classz.getMethod("getSystemSn", new Class[0]);
            serialNum = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.d("serialNum err, use old serial" + e.getLocalizedMessage(), new Object[0]);
        }
        Logger.d("serialNum is " + serialNum, new Object[0]);
        return serialNum;
    }

    private static String getQualcommSN() {
        String qualcommSN = SystemUtils.getSystemProperties(QUALCOMMSN_KEY_ROBOT);
        if (!TextUtils.isEmpty((CharSequence)qualcommSN)) {
            Logger.d("qualcommSN is " + qualcommSN, new Object[0]);
            return qualcommSN;
        }
        Logger.d("qualcommSN err, use default:00000000", new Object[0]);
        return "00000000";
    }

    private static String getModel() {
        String model = SystemUtils.getSystemProperties(MODEL_KEY_ROBOT);
        if (!TextUtils.isEmpty((CharSequence)model)) {
            Logger.d("model is " + model, new Object[0]);
            return model;
        }
        Logger.d("model err, use default:Meissa", new Object[0]);
        return "Meissa";
    }

    private static String getBrand() {
        String brand = SystemUtils.getSystemProperties(BRAND_KEY_ROBOT);
        if (!TextUtils.isEmpty((CharSequence)brand)) {
            Logger.d("brand is " + brand, new Object[0]);
            return brand;
        }
        Logger.d("brand err, use default:Orion", new Object[0]);
        return "Orion";
    }

    private static String getPlatform() {
        String platform = SystemUtils.getSystemProperties(PLATFORM_KEY_ROBOT);
        if (!TextUtils.isEmpty((CharSequence)platform)) {
            Logger.d("platform is " + platform, new Object[0]);
            return platform;
        }
        Logger.d("platform err, use default:robot", new Object[0]);
        return "robot";
    }

    private static String getSystemVer() {
        String version = SystemUtils.getSystemProperties(SYSTEM_RELEASE_VERSION);
        if (!TextUtils.isEmpty((CharSequence)version)) {
            Logger.d("system version is " + version, new Object[0]);
            return version;
        }
        return "unknown";
    }

    public static String getSystemBuildType() {
        return SystemUtils.getSystemProperties(BUILD_TYPE);
    }

    public static String getSystemProperties(String key) {
        try {
            Method systemProperties_get = Class.forName("android.os.SystemProperties").getMethod("get", String.class);
            String ret = (String)systemProperties_get.invoke(null, key);
            if (ret != null) {
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static String getAndroidVersion() {
        switch (Build.VERSION.SDK_INT) {
            case 19: 
            case 20: {
                return "Android 4.0";
            }
            case 21: 
            case 22: {
                return "Android 5.0";
            }
            case 23: {
                return "Android 6.0";
            }
            case 24: 
            case 25: {
                return "Android 7.0";
            }
        }
        return "Android XX";
    }

    public static String getMemInfo() {
        String memInfo = "";
        try {
            int pid = Process.myPid();
            ShellUtils.CommandResult result = ShellUtils.execCommand("dumpsys meminfo " + pid, false);
            if (result != null && result.successMsg != null) {
                memInfo = result.successMsg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memInfo;
    }

    public static String getMCC(Context context) {
        String mccMnc;
        if (mMCC != null) {
            return mMCC;
        }
        if (context == null) {
            return null;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        try {
            mccMnc = tm.getSimOperator();
        }
        catch (Exception e) {
            return null;
        }
        if (null != mccMnc && mccMnc.length() >= 3) {
            mMCC = mccMnc.substring(0, 3);
            return mMCC;
        }
        return null;
    }

    public static String getMnc(Context context) {
        String mccMnc;
        if (mMNC != null) {
            return mMNC;
        }
        if (context == null) {
            return null;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        try {
            mccMnc = tm.getSimOperator();
        }
        catch (Exception e) {
            return null;
        }
        if (mccMnc != null && mccMnc.length() >= 3) {
            mMNC = mccMnc.substring(3);
            return mMNC;
        }
        return null;
    }

    public static String getLanguage() {
        String lan = Locale.getDefault().getLanguage();
        if (TextUtils.isEmpty((CharSequence)lan)) {
            lan = "NONE";
        }
        return lan;
    }

    public static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    public static String getResolution(Context context) {
        try {
            return String.format(Locale.US, "%d*%d", SystemUtils.getScreenHeight(context), SystemUtils.getScreenWidth(context));
        }
        catch (Exception var2) {
            return "";
        }
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics var1 = context.getResources().getDisplayMetrics();
        return var1.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics var1 = context.getResources().getDisplayMetrics();
        return var1.heightPixels;
    }

    public static String getAndroidID(Context context) {
        if (sAndroidID != null) {
            return sAndroidID;
        }
        try {
            sAndroidID = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return sAndroidID;
    }

    public static String getDensity(Context context) {
        String density = "";
        try {
            DisplayMetrics metrics = context.getResources().getDisplayMetrics();
            float densityF = metrics.density;
            density = String.valueOf(densityF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return density;
    }

    public static String getMobileModel() {
        return Build.MODEL;
    }

    public static String getNumberOfCPUCores() {
        int cores;
        if (sCpuCores != null) {
            return sCpuCores;
        }
        if (Build.VERSION.SDK_INT <= 10) {
            return String.valueOf(1);
        }
        try {
            cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        sCpuCores = String.valueOf(cores);
        return sCpuCores;
    }

    public static String getTotalMemory() {
        if (sTotalMemory != null) {
            return sTotalMemory;
        }
        try {
            String str1 = "/proc/meminfo";
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            sTotalMemory = arrayOfString[1];
            localBufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sTotalMemory;
    }

    public static String getTotalStorage() {
        if (sTotalStorage != null) {
            return sTotalStorage;
        }
        try {
            StatFs state = new StatFs(Environment.getExternalStorageDirectory().getAbsolutePath());
            long blockSize = state.getBlockSize();
            long blockCount = state.getBlockCount();
            long totalSpace = blockCount * blockSize / 1024L;
            sTotalStorage = String.valueOf(totalSpace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sTotalStorage;
    }

    public static String getCPUAbiList() {
        if (Build.VERSION.SDK_INT >= 21) {
            return TextUtils.join((CharSequence)",", (Object[])Build.SUPPORTED_ABIS);
        }
        String abi = Build.CPU_ABI;
        String abi2 = Build.CPU_ABI2;
        if (TextUtils.isEmpty((CharSequence)abi2)) {
            return abi;
        }
        return abi + "," + abi2;
    }
}

