/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.os.Process;
import com.ainirobot.base.util.Logger;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public final class OrionBaseUtil {
    private static String processName = null;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Initialize MD5 failed.", e);
            }
        }
    };
    private static final char last2byte = (char)Integer.parseInt("00000011", 2);
    private static final char last4byte = (char)Integer.parseInt("00001111", 2);
    private static final char last6byte = (char)Integer.parseInt("00111111", 2);
    private static final char lead6byte = (char)Integer.parseInt("11111100", 2);
    private static final char lead4byte = (char)Integer.parseInt("11110000", 2);
    private static final char lead2byte = (char)Integer.parseInt("11000000", 2);
    private static final char[] encodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private OrionBaseUtil() {
    }

    public static String formatTime(String format, long timeMilliSecond) {
        return new SimpleDateFormat(format).format(new Date(timeMilliSecond));
    }

    public static boolean isInMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }

    public static boolean isInMainProcess(Context context) {
        String pkgName = context.getPackageName();
        String processName = OrionBaseUtil.getProcessName(context);
        if (processName == null || processName.length() == 0) {
            processName = "";
        }
        return pkgName.equals(processName);
    }

    public static String getProcessName(Context context) {
        if (processName != null) {
            return processName;
        }
        processName = OrionBaseUtil.getProcessNameInternal(context);
        return processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameInternal(Context context) {
        List appProcessList;
        int myPid = Process.myPid();
        if (context == null || myPid <= 0) {
            return "";
        }
        byte[] b = new byte[128];
        FileInputStream in = null;
        try {
            in = new FileInputStream("/proc/" + myPid + "/cmdline");
            int len = in.read(b);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (b[i] > 0) continue;
                    len = i;
                    break;
                }
                String i = new String(b, 0, len, Charset.forName("UTF-8"));
                return i;
            }
        }
        catch (Exception e) {
            Logger.e("getProcessNameInternal exception:" + e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Logger.e(e.getMessage(), new Object[0]);
            }
        }
        ActivityManager.RunningAppProcessInfo myProcess = null;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null && (appProcessList = activityManager.getRunningAppProcesses()) != null) {
            try {
                for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
                    if (process.pid != myPid) continue;
                    myProcess = process;
                    break;
                }
            }
            catch (Exception e) {
                Logger.e("getProcessNameInternal exception:" + e.getMessage(), new Object[0]);
            }
            if (myProcess != null) {
                return myProcess.processName;
            }
        }
        return "";
    }

    public static String getLatestStack(String stack, int count) {
        if (stack == null || stack.isEmpty()) {
            return "";
        }
        String[] strings = stack.split("\n");
        if (strings.length <= count) {
            return stack;
        }
        StringBuffer sb = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strings[i]).append('\n');
        }
        return sb.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Logger.w("Failed to close resource", e);
        }
    }

    public static String getMD5String(String s) {
        return OrionBaseUtil.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        MessageDigest digest = MD5_DIGEST.get();
        return OrionBaseUtil.bufferToHex(digest.digest(bytes));
    }

    private static String bufferToHex(byte[] bytes) {
        return OrionBaseUtil.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            OrionBaseUtil.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    public static String encode(byte[] from) {
        int i;
        StringBuffer to = new StringBuffer((int)((double)from.length * 1.34) + 3);
        int num = 0;
        int currentByte = 0;
        for (i = 0; i < from.length; ++i) {
            num %= 8;
            while (num < 8) {
                switch (num) {
                    case 0: {
                        currentByte = (char)(from[i] & lead6byte);
                        currentByte = (char)(currentByte >>> 2);
                        break;
                    }
                    case 2: {
                        currentByte = (char)(from[i] & last6byte);
                        break;
                    }
                    case 4: {
                        currentByte = (char)(from[i] & last4byte);
                        currentByte = (char)(currentByte << 2);
                        if (i + 1 >= from.length) break;
                        currentByte = (char)(currentByte | (from[i + 1] & lead2byte) >>> 6);
                        break;
                    }
                    case 6: {
                        currentByte = (char)(from[i] & last2byte);
                        currentByte = (char)(currentByte << 4);
                        if (i + 1 >= from.length) break;
                        currentByte = (char)(currentByte | (from[i + 1] & lead4byte) >>> 4);
                    }
                }
                to.append(encodeTable[currentByte]);
                num += 6;
            }
        }
        if (to.length() % 4 != 0) {
            for (i = 4 - to.length() % 4; i > 0; --i) {
                to.append("=");
            }
        }
        return to.toString();
    }
}

