/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.util.LocalUtils;

public class OrionBaseSettingsObserver
extends ContentObserver {
    private static final String AUTHORITY = "settings";
    private static final String TABLE = "global";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://settings/global");
    private static final String TAG = "SettingsObserver:OB";
    public static final String ROBOT_SETTING_PLATFORM_NAME = "robot_setting_platform_name";

    public OrionBaseSettingsObserver(Handler handler) {
        super(handler);
    }

    public void onChange(boolean selfChange, Uri uri) {
        super.onChange(selfChange, uri);
        Log.i((String)TAG, (String)("onChange: host:" + uri.getHost() + " path:" + uri.getLastPathSegment()));
        String settingsItem = uri.getLastPathSegment();
        if (TextUtils.isEmpty((CharSequence)settingsItem)) {
            Log.w((String)TAG, (String)"onChange: settingsItem is empty");
            return;
        }
        switch (settingsItem) {
            case "robot_setting_platform_name": {
                String platform = OrionBaseSettingsObserver.getGlobalSettings(ApplicationWrapper.getApplicationContext(), settingsItem, "");
                Log.i((String)TAG, (String)("onChange: platform=" + platform));
                LocalUtils.setRobotPlatform(platform);
                break;
            }
            default: {
                Log.w((String)TAG, (String)("onChange: settingsItem" + settingsItem));
            }
        }
    }

    public static String getGlobalSettings(Context ctx, String key, String defValue) {
        String global = defValue;
        if (TextUtils.isEmpty((CharSequence)key) || null == ctx) {
            return global;
        }
        global = Settings.Global.getString((ContentResolver)ctx.getContentResolver(), (String)key);
        if (TextUtils.isEmpty((CharSequence)global)) {
            global = defValue;
        }
        return global;
    }
}

