/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.ainirobot.base.util.Logger;
import java.util.HashSet;
import java.util.Iterator;

public class OrionBaseHandlerThread {
    public static final String ORIONBASE_THREAD_NAME = "default_orionbase_thread";
    private static volatile HandlerThread defaultHandlerThread;
    private static volatile Handler defaultHandler;
    private static volatile Handler defaultMainHandler;
    private static HashSet<HandlerThread> handlerThreads;

    public static Handler getDefaultMainHandler() {
        return defaultMainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandlerThread getDefaultHandlerThread() {
        Class<OrionBaseHandlerThread> clazz = OrionBaseHandlerThread.class;
        synchronized (OrionBaseHandlerThread.class) {
            if (null == defaultHandlerThread || null == defaultHandlerThread.getLooper()) {
                defaultHandlerThread = new HandlerThread(ORIONBASE_THREAD_NAME);
                defaultHandlerThread.start();
                defaultHandler = new Handler(defaultHandlerThread.getLooper());
                Logger.w("create default handler thread, we should use these thread normal", new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultHandlerThread;
        }
    }

    public static Handler getDefaultHandler() {
        return defaultHandler;
    }

    public static HandlerThread getNewHandlerThread(String name) {
        Iterator<HandlerThread> i = handlerThreads.iterator();
        while (i.hasNext()) {
            HandlerThread element = i.next();
            if (element.isAlive()) continue;
            i.remove();
            Logger.w("warning: remove dead handler thread with name %s", name);
        }
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        handlerThreads.add(handlerThread);
        Logger.w("warning: create new handler thread with name %s, alive thread size:%d", name, handlerThreads.size());
        return handlerThread;
    }

    static {
        defaultMainHandler = new Handler(Looper.getMainLooper());
        handlerThreads = new HashSet();
    }
}

