/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.util.Log;

public class Logger {
    public static final String TAG = "OrionBase";
    private static LoggerImp debugLog;
    private static LoggerImp mLogImp;
    private static boolean mDebuggable;

    private Logger() {
    }

    public static boolean debuggable() {
        return mDebuggable;
    }

    public static void setDebuggable(boolean debuggable) {
        mDebuggable = debuggable;
    }

    public static void v(String msg, Object ... obj) {
        if (mLogImp != null) {
            mLogImp.v(TAG, msg, obj);
        }
    }

    public static void e(String msg, Object ... obj) {
        if (mLogImp != null) {
            mLogImp.e(TAG, msg, obj);
        }
    }

    public static void w(String msg, Object ... obj) {
        if (mLogImp != null) {
            mLogImp.w(TAG, msg, obj);
        }
    }

    public static void i(String msg, Object ... obj) {
        if (mLogImp != null) {
            mLogImp.i(TAG, msg, obj);
        }
    }

    public static void d(String msg, Object ... obj) {
        if (mLogImp != null) {
            mLogImp.d(TAG, msg, obj);
        }
    }

    public static void printErrStackTrace(Throwable tr, String format, Object ... obj) {
        if (mLogImp != null) {
            mLogImp.printErrStackTrace(TAG, tr, format, obj);
        }
    }

    static {
        mLogImp = debugLog = new LoggerImp(){

            @Override
            public void v(String tag, String format, Object ... params) {
                if (mDebuggable) {
                    if (params == null || params.length == 0) {
                        Log.v((String)tag, (String)format);
                    } else {
                        StringBuilder builder = new StringBuilder(format);
                        for (Object o : params) {
                            builder.append(o);
                            builder.append(" ");
                        }
                        Log.v((String)tag, (String)builder.toString());
                    }
                }
            }

            @Override
            public void i(String tag, String format, Object ... params) {
                if (mDebuggable) {
                    if (params == null || params.length == 0) {
                        Log.i((String)tag, (String)format);
                    } else {
                        StringBuilder builder = new StringBuilder(format);
                        for (Object o : params) {
                            builder.append(" ");
                            builder.append(o);
                        }
                        Log.i((String)tag, (String)builder.toString());
                    }
                }
            }

            @Override
            public void d(String tag, String format, Object ... params) {
                if (mDebuggable) {
                    if (params == null || params.length == 0) {
                        Log.d((String)tag, (String)format);
                    } else {
                        StringBuilder builder = new StringBuilder(format);
                        for (Object o : params) {
                            builder.append(" ");
                            builder.append(o);
                        }
                        Log.d((String)tag, (String)builder.toString());
                    }
                }
            }

            @Override
            public void w(String tag, String format, Object ... params) {
                if (mDebuggable) {
                    if (params == null || params.length == 0) {
                        Log.w((String)tag, (String)format);
                    } else {
                        StringBuilder builder = new StringBuilder(format);
                        for (Object o : params) {
                            builder.append(" ");
                            builder.append(o);
                        }
                        Log.w((String)tag, (String)builder.toString());
                    }
                }
            }

            @Override
            public void e(String tag, String format, Object ... params) {
                if (params == null || params.length == 0) {
                    Log.e((String)tag, (String)format);
                } else {
                    StringBuilder builder = new StringBuilder(format);
                    for (Object o : params) {
                        builder.append(" ");
                        builder.append(o);
                    }
                    Log.e((String)tag, (String)builder.toString());
                }
            }

            @Override
            public void printErrStackTrace(String tag, Throwable tr, String format, Object ... params) {
                if (mDebuggable) {
                    String log;
                    String string = log = params == null || params.length == 0 ? format : String.format(format, params);
                    if (log == null) {
                        log = "";
                    }
                    log = log + "  " + Log.getStackTraceString((Throwable)tr);
                    Log.e((String)tag, (String)log);
                }
            }
        };
        mDebuggable = false;
    }

    public static interface LoggerImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);
    }
}

