/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import com.ainirobot.base.util.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class LocalUtils {
    private static final String SETTINGS_GLOBAL_robot_uuid = "robot_uuid";
    private static final String SETTINGS_GLOBAL_corp_uuid = "corp_uuid";
    private static final String SETTINGS_GLOBA_VOICE_CORP_ID = "voice_corp_id";
    private static final String SETTINGS_AUTO_COLLECT_CRASH_LOG = "robot_setting_auto_collect_crash_log";
    private static final String mDefaultValue = "12";
    private static long sStartTime = 0L;
    private static String mPackageName = null;
    private static String mAppName = null;
    private static String mAppVersion = null;
    private static String mOptJson = null;
    private static String mJsRole;
    private static String mJsScene;
    private static String mClientId;
    private static String mModel;
    private static String mChannelNumber;
    private static String mPlatform;
    private static String mSDKVersion;

    private LocalUtils() {
    }

    public static void init() {
        if (sStartTime == 0L) {
            sStartTime = System.currentTimeMillis();
        }
    }

    public static long getUseTime() {
        if (sStartTime == 0L) {
            sStartTime = System.currentTimeMillis();
        }
        return System.currentTimeMillis() - sStartTime;
    }

    public static void setClientId(String clientId) {
        mClientId = clientId;
    }

    public static String getClientId() {
        return mClientId;
    }

    public static void setJsRole(String jsRole) {
        mJsRole = jsRole;
    }

    public static String getJsRole() {
        return mJsRole;
    }

    public static void setJsScene(String jsScene) {
        mJsScene = jsScene;
    }

    public static String getJsScene() {
        return mJsScene;
    }

    public static String getRobotUUID(Context ctx) {
        return LocalUtils.getGlobalSettings(ctx, SETTINGS_GLOBAL_robot_uuid, mDefaultValue);
    }

    public static String getCorpUUID(Context ctx) {
        return LocalUtils.getGlobalSettings(ctx, SETTINGS_GLOBAL_corp_uuid, mDefaultValue);
    }

    public static String getVoiceCorpId(Context ctx) {
        return LocalUtils.getGlobalSettings(ctx, SETTINGS_GLOBA_VOICE_CORP_ID, mDefaultValue);
    }

    public static String getAutoCollectCrashLog(Context ctx) {
        return LocalUtils.getGlobalSettings(ctx, SETTINGS_AUTO_COLLECT_CRASH_LOG, "1");
    }

    public static int getOsType(Context ctx) {
        return 1;
    }

    private static String getGlobalSettings(Context ctx, String key, String defValue) {
        String global = defValue;
        if (TextUtils.isEmpty((CharSequence)key) || null == ctx) {
            Logger.d("can't get system.settings a empty key or null context!", new Object[0]);
            return global;
        }
        global = Settings.Global.getString((ContentResolver)ctx.getContentResolver(), (String)key);
        if (TextUtils.isEmpty((CharSequence)global)) {
            global = defValue;
        }
        return global;
    }

    public static boolean isMainProcess(Context context) {
        return context.getPackageName().equals(LocalUtils.getProcessName(context));
    }

    public static String getProcessName(Context context) {
        ActivityManager.RunningAppProcessInfo proInfo;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        if (runningApps == null) {
            return null;
        }
        Iterator var3 = runningApps.iterator();
        do {
            if (!var3.hasNext()) {
                return null;
            }
            proInfo = (ActivityManager.RunningAppProcessInfo)var3.next();
        } while (proInfo.pid != Process.myPid() || proInfo.processName == null);
        return proInfo.processName;
    }

    public static String getTimeStr(long timeMillis) {
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.CHINA);
        Date date = new Date(timeMillis);
        try {
            return formatter.format(date);
        }
        catch (Exception e) {
            Logger.d("getTimeStr error: " + e.getMessage(), new Object[0]);
            return "";
        }
    }

    public static void setPackageName(String packageName) {
        mPackageName = packageName;
    }

    public static String getPackageName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)mPackageName)) {
            return mPackageName;
        }
        mPackageName = context.getPackageName();
        return mPackageName;
    }

    public static void setAppName(String appName) {
        mAppName = appName;
    }

    public static String getAppName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)mAppName)) {
            return mAppName;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            mAppName = context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            mAppName = "";
        }
        return mAppName;
    }

    public static String getVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setAppVersion(String appVersion) {
        mAppVersion = appVersion;
    }

    public static String getVersionCode(Context context) {
        if (!TextUtils.isEmpty((CharSequence)mAppVersion)) {
            return mAppVersion;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            mAppVersion = String.valueOf(packageInfo.versionCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            mAppVersion = "0";
        }
        return mAppVersion;
    }

    public static String getAndroidVersion() {
        return "Android " + Build.VERSION.RELEASE + "(" + Build.VERSION.SDK_INT + ")";
    }

    public static void setOptJson(String jsonString) {
        mOptJson = jsonString;
    }

    public static String getOptJson() {
        return mOptJson == null ? "" : mOptJson;
    }

    public static void setModel(String model) {
        mModel = model;
    }

    public static String getModel() {
        return mModel == null ? "" : mModel;
    }

    public static void setChannelNumber(String channelNumber) {
        mChannelNumber = channelNumber;
    }

    public static String getChannelNumber() {
        return mChannelNumber == null ? "" : mChannelNumber;
    }

    public static void setRobotPlatform(String platform) {
        mPlatform = platform;
    }

    public static String getRobotPlatform() {
        return mPlatform == null ? "" : mPlatform;
    }

    public static void setSDKVersion(String version) {
        mSDKVersion = version;
    }

    public static String getSDKVersion() {
        return TextUtils.isEmpty((CharSequence)mSDKVersion) ? "2.0.5.0" : mSDKVersion;
    }

    static {
        mSDKVersion = null;
    }
}

