/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.os.Process;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;

public class FileUtils {
    private static final Object sLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dst) {
        boolean result = false;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean renameTempFile(File temp, File dst) {
        boolean result = false;
        try {
            result = temp.exists() && temp.length() > 0L ? temp.renameTo(dst) : temp.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inputStreamToFileReplacePid(InputStream in, File file) {
        boolean flag = true;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            File distFile = file;
            if (!distFile.getParentFile().exists()) {
                distFile.getParentFile().mkdirs();
            }
            bufferedReader = new BufferedReader(new InputStreamReader(in));
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            String line = null;
            boolean firstLine = true;
            while ((line = bufferedReader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                    line = line.replace("%s", String.valueOf(Process.myPid()));
                }
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = flag = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static byte[] fileToByte(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stringToFile(String res, String filePath) {
        boolean flag = true;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            int len;
            File distFile = new File(filePath);
            if (!distFile.getParentFile().exists()) {
                distFile.getParentFile().mkdirs();
            }
            bufferedReader = new BufferedReader(new StringReader(res));
            bufferedWriter = new BufferedWriter(new FileWriter(distFile));
            char[] buf = new char[1024];
            while ((len = bufferedReader.read(buf)) != -1) {
                bufferedWriter.write(buf, 0, len);
            }
            bufferedWriter.flush();
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = flag = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stringToFile(String res, File file) {
        boolean flag = true;
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(file, true);
            pw = new PrintWriter(fw);
            pw.println(res);
            pw.flush();
            fw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            flag = false;
        }
        finally {
            try {
                pw.close();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public static String stringFromFile(File file) {
        byte[] bytes = FileUtils.bytesFromFile(file);
        return bytes == null ? null : new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] bytesFromFile(File file) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        Object object = sLock;
        synchronized (object) {
            try {
                fis = new FileInputStream(file);
                byte[] bytes = new byte[fis.available()];
                fis.read(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            catch (Exception exception) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    fis = null;
                }
            }
            return null;
        }
    }

    public static boolean deleteDir(File dir, boolean removeDir) {
        File[] files;
        if (dir == null || !dir.exists()) {
            return true;
        }
        if (dir.isFile()) {
            return dir.delete();
        }
        boolean result = true;
        for (File file : files = dir.listFiles()) {
            result = file.isFile() ? result && file.delete() : result && FileUtils.deleteDir(file, true);
        }
        if (removeDir && result) {
            result = result && dir.delete();
        }
        return result;
    }

    public static void closeReader(Reader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeRandomAccessFile(RandomAccessFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteOneFile(File file) {
        boolean isSuc;
        if (file == null) {
            return;
        }
        if (file.exists() && !(isSuc = file.delete())) {
            Log.d((String)"OrionBase", (String)("delete file fail:" + file.getAbsolutePath()));
        }
    }
}

