/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.content.Context;
import android.os.Environment;
import com.ainirobot.base.util.FileStore;
import com.ainirobot.base.util.Logger;
import java.io.File;

public class FileStoreImpl
implements FileStore {
    private final String contentPath;
    private final Context context;

    public FileStoreImpl(Context context, String path) {
        if (context == null) {
            throw new IllegalStateException("Cannot get directory before context has been set. Call OrionHawk.with() first");
        }
        this.context = context;
        this.contentPath = path;
    }

    @Override
    public File getCacheDir() {
        return this.prepare(this.context.getCacheDir());
    }

    @Override
    public File getExternalCacheDir() {
        File file = null;
        if (this.isExternalStorageAvailable()) {
            file = this.context.getExternalCacheDir();
        }
        return this.prepare(file);
    }

    @Override
    public File getFilesDir() {
        return this.prepare(this.context.getFilesDir());
    }

    @Override
    public File getExternalFilesDir() {
        File file = null;
        if (this.isExternalStorageAvailable()) {
            file = this.context.getExternalFilesDir(null);
        }
        return this.prepare(file);
    }

    public File prepare(File file) {
        if (file == null) {
            Logger.d("Null File", new Object[0]);
        } else {
            if (file.exists() || file.mkdirs()) {
                return file;
            }
            Logger.w("Report", "Couldn't create file");
        }
        return null;
    }

    public boolean isExternalStorageAvailable() {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            return true;
        }
        Logger.w("Report", "External Storage is not mounted and/or writable\nHave you declared android.permission.WRITE_EXTERNAL_STORAGE in the manifest?");
        return false;
    }
}

