/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.content.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class FilePreference {
    private static final String SOTRE_FILE_NAME = "file.store";
    private static final String SOTRE_FILE_TMP_NAME = "file.store.tmp";
    private Context mContext;

    public static FilePreference Instance() {
        return Holder.singleton;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    public synchronized void save(String key, String value) {
        try {
            File storeFile = new File(this.mContext.getFilesDir(), SOTRE_FILE_NAME);
            File tmpStoreFile = new File(this.mContext.getFilesDir(), SOTRE_FILE_TMP_NAME);
            if (!storeFile.exists()) {
                storeFile.createNewFile();
            }
            storeFile.renameTo(tmpStoreFile);
            Properties prop = new Properties();
            prop.setProperty(key, value);
            FileOutputStream fos = new FileOutputStream(tmpStoreFile);
            prop.store(fos, key + value);
            tmpStoreFile.renameTo(storeFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized String get(String key) {
        try {
            File storeFile = new File(this.mContext.getFilesDir(), SOTRE_FILE_NAME);
            if (storeFile.exists()) {
                Properties prop = new Properties();
                FileInputStream fis = new FileInputStream(storeFile);
                prop.load(fis);
                return (String)prop.get(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isWriting() {
        try {
            File storeFile = new File(this.mContext.getFilesDir(), SOTRE_FILE_TMP_NAME);
            if (storeFile.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static class Holder {
        private static FilePreference singleton = new FilePreference();

        private Holder() {
        }
    }
}

