/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import com.ainirobot.base.util.BackgroundPriorityRunnable;
import com.ainirobot.base.util.Logger;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ExecutorUtils {
    private static final long DEFAULT_TERMINATION_TIMEOUT = 2L;
    private static ExecutorService sExecutor = null;

    private ExecutorUtils() {
    }

    public static ExecutorService buildSingleThreadExecutorService() {
        if (sExecutor == null) {
            sExecutor = Executors.newSingleThreadExecutor(ExecutorUtils.getNamedThreadFactory("OrionBase"));
            ExecutorUtils.addDelayedShutdownHook("OrionBase", sExecutor);
        }
        return sExecutor;
    }

    private static ThreadFactory getNamedThreadFactory(final String threadNameTemplate) {
        final AtomicLong count = new AtomicLong(1L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(new BackgroundPriorityRunnable(){

                    @Override
                    public void onRun() {
                        runnable.run();
                    }
                });
                thread.setName(threadNameTemplate + count.getAndIncrement());
                return thread;
            }
        };
    }

    private static void addDelayedShutdownHook(String serviceName, ExecutorService service) {
        ExecutorUtils.addDelayedShutdownHook(serviceName, service, 2L, TimeUnit.SECONDS);
    }

    private static void addDelayedShutdownHook(String serviceName, ExecutorService service, long terminationTimeout, TimeUnit timeUnit) {
        final String str = serviceName;
        final ExecutorService executorService = service;
        final long j = terminationTimeout;
        final TimeUnit timeUnit2 = timeUnit;
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new BackgroundPriorityRunnable(){

            @Override
            public void onRun() {
                try {
                    Logger.d("Executing shutdown hook for " + str, new Object[0]);
                    executorService.shutdown();
                    if (!executorService.awaitTermination(j, timeUnit2)) {
                        Logger.d(str + " did not shut down in the allocated time. Requesting immediate shutdown.", new Object[0]);
                        executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    Logger.d(String.format(Locale.US, "Interrupted while waiting for %s to shut down. Requesting immediate shutdown.", str), new Object[0]);
                    executorService.shutdownNow();
                }
            }
        }, "Crashlytics Shutdown Hook for " + serviceName));
    }
}

