/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.os.StatFs;
import android.util.Log;
import com.ainirobot.base.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceUtil {
    private static final String TAG = DeviceUtil.class.getSimpleName();
    private static final long MB = 0x100000L;
    private static final int INVALID = 0;
    private static final String MEMORY_FILE_PATH = "/proc/meminfo";
    private static final String CPU_FILE_PATH_0 = "/sys/devices/system/cpu/";
    private static final String CPU_FILE_PATH_1 = "/sys/devices/system/cpu/possible";
    private static final String CPU_FILE_PATH_2 = "/sys/devices/system/cpu/present";
    private static LEVEL sLevelCache = null;
    public static final String DEVICE_MACHINE = "machine";
    private static final String DEVICE_MEMORY_FREE = "mem_free";
    private static final String DEVICE_MEMORY = "mem";
    private static final String DEVICE_CPU = "cpu_app";
    private static long sTotalMemory = 0L;
    private static long sLowMemoryThresold = 0L;
    private static int sMemoryClass = 0;
    private static final int RADIX = 1024;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return Pattern.matches("cpu[0-9]", pathname.getName());
        }
    };

    public static JSONObject getDeviceInfo(JSONObject oldObj, Application context) {
        try {
            oldObj.put(DEVICE_MACHINE, (Object)DeviceUtil.getLevel((Context)context));
            oldObj.put(DEVICE_CPU, DeviceUtil.getCurAppCpuRate());
            oldObj.put(DEVICE_MEMORY, DeviceUtil.getTotalMemory((Context)context));
            oldObj.put(DEVICE_MEMORY_FREE, DeviceUtil.getMemFree());
        }
        catch (JSONException e) {
            Logger.e("[JSONException for stack, error: %s", new Object[]{e});
        }
        return oldObj;
    }

    public static LEVEL getLevel(Context context) {
        if (null != sLevelCache) {
            return sLevelCache;
        }
        long start = System.currentTimeMillis();
        long totalMemory = DeviceUtil.getTotalMemory(context);
        int coresNum = DeviceUtil.getNumOfCores();
        Logger.i("[getLevel] totalMemory:%s coresNum:%s", totalMemory, coresNum);
        if (totalMemory >= 0x100000000L) {
            sLevelCache = LEVEL.BEST;
        } else if (totalMemory >= 0xC0000000L) {
            sLevelCache = LEVEL.HIGH;
        } else if (totalMemory >= 0x80000000L) {
            if (coresNum >= 4) {
                sLevelCache = LEVEL.HIGH;
            } else if (coresNum >= 2) {
                sLevelCache = LEVEL.MIDDLE;
            } else if (coresNum > 0) {
                sLevelCache = LEVEL.LOW;
            }
        } else if (totalMemory >= 0x40000000L) {
            if (coresNum >= 4) {
                sLevelCache = LEVEL.MIDDLE;
            } else if (coresNum >= 2) {
                sLevelCache = LEVEL.LOW;
            } else if (coresNum > 0) {
                sLevelCache = LEVEL.LOW;
            }
        } else {
            sLevelCache = 0L <= totalMemory && totalMemory < 0x40000000L ? LEVEL.BAD : LEVEL.UN_KNOW;
        }
        Logger.i("getLevel, cost:" + (System.currentTimeMillis() - start) + ", level:" + (Object)((Object)sLevelCache), new Object[0]);
        return sLevelCache;
    }

    private static int getAppId() {
        return android.os.Process.myPid();
    }

    public static int getProcessIdByName(Context context, String name) {
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (!appProcess.processName.equals(name)) continue;
            return appProcess.pid;
        }
        return -1;
    }

    public static long getLowMemoryThresold(Context context) {
        if (0L != sLowMemoryThresold) {
            return sLowMemoryThresold;
        }
        DeviceUtil.getTotalMemory(context);
        return sLowMemoryThresold;
    }

    public static int getMemoryClass(Context context) {
        if (0 != sMemoryClass) {
            return sMemoryClass * 1024;
        }
        DeviceUtil.getTotalMemory(context);
        return sMemoryClass * 1024;
    }

    public static long getTotalMemory(Context context) {
        if (0L != sTotalMemory) {
            return sTotalMemory;
        }
        long start = System.currentTimeMillis();
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            am.getMemoryInfo(memInfo);
            sTotalMemory = memInfo.totalMem;
            sLowMemoryThresold = memInfo.threshold;
            long memClass = Runtime.getRuntime().maxMemory();
            sMemoryClass = memClass == Long.MAX_VALUE ? am.getMemoryClass() : (int)(memClass / 0x100000L);
            Logger.i("getTotalMemory cost:" + (System.currentTimeMillis() - start) + ", total_mem:" + sTotalMemory + ", LowMemoryThresold:" + sLowMemoryThresold + ", Memory Class:" + sMemoryClass, new Object[0]);
            return sTotalMemory;
        }
        return 0L;
    }

    public static boolean isLowMemory(Context context) {
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        am.getMemoryInfo(memInfo);
        return memInfo.lowMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getAvailMemory(Context context) {
        long availMemory;
        block16: {
            if (Build.VERSION.SDK_INT >= 16) {
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                ActivityManager am = (ActivityManager)context.getSystemService("activity");
                am.getMemoryInfo(memInfo);
                return memInfo.availMem / 1024L;
            }
            availMemory = 0L;
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(MEMORY_FILE_PATH), StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            while (null != line) {
                String[] args = line.split("\\s+");
                if ("MemFree:".equals(args[0])) {
                    availMemory = (long)Integer.parseInt(args[1]) * 1024L;
                    break;
                }
                line = bufferedReader.readLine();
            }
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
                break block16;
            }
            catch (Exception e) {
                Logger.i("close reader %s", e.toString());
            }
            break block16;
            catch (Exception e) {
                try {
                    Logger.i("[getAvailMemory] error! %s", e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != bufferedReader) {
                            bufferedReader.close();
                        }
                    }
                    catch (Exception e2) {
                        Logger.i("close reader %s", e2.toString());
                    }
                    throw throwable;
                }
                try {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e3) {
                    Logger.i("close reader %s", e3.toString());
                }
            }
        }
        return availMemory / 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getMemFree() {
        long availMemory;
        block15: {
            availMemory = 0L;
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(MEMORY_FILE_PATH), StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            while (null != line) {
                String[] args = line.split("\\s+");
                if ("MemFree:".equals(args[0])) {
                    availMemory = (long)Integer.parseInt(args[1]) * 1024L;
                    break;
                }
                line = bufferedReader.readLine();
            }
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
                break block15;
            }
            catch (Exception e) {
                Logger.i("close reader %s", e.toString());
            }
            break block15;
            catch (Exception e) {
                try {
                    Logger.i("[getAvailMemory] error! %s", e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != bufferedReader) {
                            bufferedReader.close();
                        }
                    }
                    catch (Exception e2) {
                        Logger.i("close reader %s", e2.toString());
                    }
                    throw throwable;
                }
                try {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e3) {
                    Logger.i("close reader %s", e3.toString());
                }
            }
        }
        return availMemory / 1024L;
    }

    public static double getCurAppCpuRate() {
        double totalCpu1 = DeviceUtil.getTotalCpu();
        double appCpu1 = DeviceUtil.getAppCpu();
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double totalCpu2 = DeviceUtil.getTotalCpu();
        double appCpu2 = DeviceUtil.getAppCpu();
        double rate = (appCpu2 - appCpu1) / (totalCpu2 - totalCpu1);
        return rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static double getTotalCpu() {
        long cpuTime;
        block13: {
            cpuTime = 0L;
            RandomAccessFile procStatFile = null;
            procStatFile = new RandomAccessFile("/proc/stat", "r");
            String procStatString = procStatFile.readLine();
            String[] procStats = procStatString.split(" ");
            cpuTime = Long.parseLong(procStats[2]) + Long.parseLong(procStats[3]) + Long.parseLong(procStats[4]) + Long.parseLong(procStats[5]) + Long.parseLong(procStats[6]) + Long.parseLong(procStats[7]) + Long.parseLong(procStats[8]);
            try {
                if (null != procStatFile) {
                    procStatFile.close();
                }
                break block13;
            }
            catch (Exception e) {
                Logger.i("close process reader %s", e.toString());
            }
            break block13;
            catch (Exception e) {
                try {
                    Logger.i("RandomAccessFile(Process Stat) reader fail, error: %s", e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != procStatFile) {
                            procStatFile.close();
                        }
                    }
                    catch (Exception e2) {
                        Logger.i("close process reader %s", e2.toString());
                    }
                    throw throwable;
                }
                try {
                    if (null != procStatFile) {
                        procStatFile.close();
                    }
                }
                catch (Exception e3) {
                    Logger.i("close process reader %s", e3.toString());
                }
            }
        }
        return cpuTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static double getAppCpu() {
        long appTime;
        block13: {
            appTime = 0L;
            RandomAccessFile appStatFile = null;
            appStatFile = new RandomAccessFile("/proc/" + DeviceUtil.getAppId() + "/stat", "r");
            String appStatString = appStatFile.readLine();
            String[] appStats = appStatString.split(" ");
            appTime = Long.parseLong(appStats[13]) + Long.parseLong(appStats[14]);
            try {
                if (null != appStatFile) {
                    appStatFile.close();
                }
                break block13;
            }
            catch (Exception e) {
                Logger.i("close app reader %s", e.toString());
            }
            break block13;
            catch (Exception e) {
                try {
                    Logger.i("RandomAccessFile(App Stat) reader fail, error: %s", e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != appStatFile) {
                            appStatFile.close();
                        }
                    }
                    catch (Exception e2) {
                        Logger.i("close app reader %s", e2.toString());
                    }
                    throw throwable;
                }
                try {
                    if (null != appStatFile) {
                        appStatFile.close();
                    }
                }
                catch (Exception e3) {
                    Logger.i("close app reader %s", e3.toString());
                }
            }
        }
        return appTime;
    }

    public static String getMaxCpuFreq() {
        String result = "";
        try {
            String[] args = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            InputStream in = process.getInputStream();
            byte[] re = new byte[24];
            while (in.read(re) != -1) {
                result = result + new String(re);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            result = "N/A";
        }
        return result.trim();
    }

    public static Debug.MemoryInfo getAppMemory(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            Debug.MemoryInfo[] memInfo = activityManager.getProcessMemoryInfo(new int[]{DeviceUtil.getAppId()});
            if (memInfo.length > 0) {
                return memInfo[0];
            }
        }
        catch (Exception e) {
            Logger.i("getAppMemoryInfo fail, error: %s", e.toString());
        }
        return null;
    }

    public static Debug.MemoryInfo getAppMemory(Context context, int pid) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            Debug.MemoryInfo[] memInfo = activityManager.getProcessMemoryInfo(new int[]{pid});
            if (memInfo.length > 0) {
                return memInfo[0];
            }
        }
        catch (Exception e) {
            Logger.i("getProcessMemoryInfo fail, error: %s", e.toString());
        }
        return null;
    }

    public static Debug.MemoryInfo getProcessMemory(Context context, String processName) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int pid = DeviceUtil.getProcessIdByName(context, processName);
            if (pid == -1) {
                return null;
            }
            Debug.MemoryInfo[] memInfo = activityManager.getProcessMemoryInfo(new int[]{pid});
            if (memInfo.length > 0) {
                return memInfo[0];
            }
        }
        catch (Exception e) {
            Logger.i("getProcessMemoryInfo fail, error: %s", e.toString());
        }
        return null;
    }

    public static int getNumOfCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = DeviceUtil.getCoresFromFile(CPU_FILE_PATH_1);
            if (cores == 0) {
                cores = DeviceUtil.getCoresFromFile(CPU_FILE_PATH_2);
            }
            if (cores == 0) {
                cores = DeviceUtil.getCoresFromCPUFiles(CPU_FILE_PATH_0);
            }
        }
        catch (Exception e) {
            cores = 0;
        }
        if (cores == 0) {
            cores = 1;
        }
        return cores;
    }

    private static int getCoresFromCPUFiles(String path) {
        File[] list = new File(path).listFiles(CPU_FILTER);
        return null == list ? 0 : list.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int getCoresFromFile(String file) {
        String fileContents;
        FileInputStream is;
        block17: {
            is = null;
            is = new FileInputStream(file);
            BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            fileContents = buf.readLine();
            buf.close();
            if (fileContents != null && fileContents.matches("0-[\\d]+$")) break block17;
            int n = 0;
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                Logger.i("[getCoresFromFile] error! %s", e.toString());
            }
            return n;
        }
        String num = fileContents.substring(2);
        int n = Integer.parseInt(num) + 1;
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            Logger.i("[getCoresFromFile] error! %s", e.toString());
        }
        return n;
        catch (IOException e) {
            int n2;
            try {
                Logger.i("[getCoresFromFile] error! %s", e.toString());
                n2 = 0;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e2) {
                    Logger.i("[getCoresFromFile] error! %s", e2.toString());
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e3) {
                Logger.i("[getCoresFromFile] error! %s", e3.toString());
            }
            return n2;
        }
    }

    public static long getDalvikHeap() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 1024L;
    }

    public static long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize() / 1024L;
    }

    public static long getVmSize() {
        String status = String.format("/proc/%s/status", DeviceUtil.getAppId());
        try {
            Pattern p;
            Matcher matcher;
            String[] args;
            String content = DeviceUtil.getStringFromFile(status).trim();
            for (String str : args = content.split("\n")) {
                Pattern p2;
                Matcher matcher2;
                if (!str.startsWith("VmSize") || !(matcher2 = (p2 = Pattern.compile("\\d+")).matcher(str)).find()) continue;
                return Long.parseLong(matcher2.group());
            }
            if (args.length > 12 && (matcher = (p = Pattern.compile("\\d+")).matcher(args[12])).find()) {
                return Long.parseLong(matcher.group());
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String convertStreamToString(InputStream is) throws Exception {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStringFromFile(String filePath) throws Exception {
        String ret;
        File fl = new File(filePath);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fl);
            ret = DeviceUtil.convertStreamToString(fin);
        }
        finally {
            if (null != fin) {
                fin.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessName() {
        File f = new File("/proc/self/cmdline");
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(f);
            byte[] buffer = new byte[256];
            int length = ((InputStream)reader).read(buffer);
            if (length > 0) {
                String string = new String(buffer, 0, length).trim();
                return string;
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"proc/self/cmdline not found");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"read cmdline error");
        }
        finally {
            if (reader != null) {
                try {
                    ((InputStream)reader).close();
                }
                catch (IOException e) {}
            }
        }
        return "";
    }

    public static int getAvailableSize(StatFs stat) {
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        return (int)(availableBlocks * blockSize / 1024L / 1024L);
    }

    public static int getTotalSize(StatFs stat) {
        long blockSize = stat.getBlockSizeLong();
        long totalBlocks = stat.getBlockCountLong();
        return (int)(totalBlocks * blockSize / 1024L / 1024L);
    }

    public static enum LEVEL {
        BEST(5),
        HIGH(4),
        MIDDLE(3),
        LOW(2),
        BAD(1),
        UN_KNOW(-1);

        int value;

        private LEVEL(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }
}

