/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Debug;
import android.provider.Settings;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class CommonUtils {
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int NET_WIFI = 1;
    private static final int NET_2G = 2;
    private static final int NET_3G = 3;
    private static final int NET_4G = 4;
    private static final int NET_NOT_NETWORK = 5;
    private static int mLastNetworkState = -1;
    private static long mLastNetworkTimeStamp = -1L;

    public static boolean isEmulator(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return "sdk".equals(Build.PRODUCT) || "google_sdk".equals(Build.PRODUCT) || androidId == null;
    }

    public static boolean isRooted(Context context) {
        boolean isEmulator = CommonUtils.isEmulator(context);
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && buildTags.contains("test-keys")) {
            return true;
        }
        File file = new File("/system/app/Superuser.apk");
        if (file.exists()) {
            return true;
        }
        file = new File("/system/xbin/su");
        return !isEmulator && file.exists();
    }

    public static boolean isDebuggerAttached() {
        return Debug.isDebuggerConnected() || Debug.waitingForDebugger();
    }

    public static int getDeviceState(Context context) {
        int deviceState = 0;
        if (CommonUtils.isEmulator(context)) {
            deviceState |= 1;
        }
        if (CommonUtils.isRooted(context)) {
            deviceState |= 2;
        }
        if (CommonUtils.isApkInDebug(context)) {
            deviceState |= 4;
        }
        if (CommonUtils.isDebuggerAttached()) {
            deviceState |= 8;
        }
        if (!Constants.BUILD_TYPE_DEBUG) {
            deviceState |= 0x10;
        }
        return deviceState;
    }

    private static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String hexify(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_VALUES[v >>> 4];
            hexChars[i * 2 + 1] = HEX_VALUES[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void closeOrLog(Closeable c, String message) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException var3) {
                Logger.e("OrionHawk", message, var3);
            }
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean canTryConnection(Context context) {
        if (!CommonUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    public static int getNetworkState(Context context) {
        int networkType;
        if (mLastNetworkState != -1 && System.currentTimeMillis() - mLastNetworkTimeStamp < 600000L) {
            return mLastNetworkState;
        }
        int[] netWorkInfoStatus = CommonUtils.getNetWorkInfoStatus(context);
        int networkStatue = netWorkInfoStatus[0];
        mLastNetworkState = networkStatue == 5 ? 5 : (networkStatue == 1 ? 1 : ((networkType = netWorkInfoStatus[1]) == 2 ? 2 : (networkType == 3 ? 3 : 4)));
        mLastNetworkTimeStamp = System.currentTimeMillis();
        return mLastNetworkState;
    }

    @SuppressLint(value={"MissingPermission"})
    private static int[] getNetWorkInfoStatus(Context context) {
        ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = null;
        try {
            info = connectMgr.getActiveNetworkInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] type = new int[]{5, 0};
        if (info != null) {
            try {
                if (info.getState() != NetworkInfo.State.CONNECTED) {
                    return type;
                }
            }
            catch (NoSuchFieldError e) {
                return type;
            }
            block2 : switch (info.getType()) {
                case 1: {
                    type[0] = 1;
                    break;
                }
                case 0: {
                    type[0] = 0;
                    switch (info.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            type[1] = 2;
                            break block2;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            type[1] = 3;
                            break block2;
                        }
                        case 13: {
                            type[1] = 4;
                            break block2;
                        }
                    }
                    type[1] = 0;
                    break;
                }
                default: {
                    type[0] = 5;
                }
            }
        }
        return type;
    }

    public static int capFileCount(File directory, FilenameFilter filter, int maxAllowed, Comparator<File> sortComparator) {
        File[] sessionFiles = directory.listFiles(filter);
        if (sessionFiles == null) {
            return 0;
        }
        int numRetained = sessionFiles.length;
        Arrays.sort(sessionFiles, sortComparator);
        for (File file : sessionFiles) {
            if (numRetained <= maxAllowed) {
                return numRetained;
            }
            file.delete();
            --numRetained;
        }
        return numRetained;
    }

    public static int capAnrFileCount(File directory, FilenameFilter filter, int maxAllowed, Comparator<File> sortComparator) {
        File[] sessionFiles = directory.listFiles(filter);
        if (sessionFiles == null) {
            return 0;
        }
        int numRetained = sessionFiles.length;
        Arrays.sort(sessionFiles, sortComparator);
        for (File file : sessionFiles) {
            File anrPublicFile;
            if (numRetained <= maxAllowed) {
                return numRetained;
            }
            String path = file.getAbsolutePath();
            if (path.contains(".anr_cache")) {
                path = path.replace(".anr_cache", ".anr");
            }
            if ((anrPublicFile = new File(path + ".public")).exists()) {
                anrPublicFile.delete();
            }
            file.delete();
            --numRetained;
        }
        return numRetained;
    }

    public static int capFileCount(File directory, FilenameFilter filter, FilenameFilter exfilter1, FilenameFilter exfilter2, FilenameFilter exfilter3, int maxAllowed, Comparator<File> sortComparator) {
        File[] exfils;
        int i = 0;
        File[] sessionFiles = directory.listFiles(filter);
        if (sessionFiles == null) {
            return 0;
        }
        int numRetained = sessionFiles.length;
        Arrays.sort(sessionFiles, sortComparator);
        int length = sessionFiles.length;
        ArrayList<String> crashAndANRIds = new ArrayList<String>();
        for (File file : exfils = directory.listFiles(exfilter1)) {
            crashAndANRIds.add(file.getPath().substring(0, file.getPath().lastIndexOf(46)));
        }
        for (File file : exfils = directory.listFiles(exfilter2)) {
            crashAndANRIds.add(file.getPath().substring(0, file.getPath().lastIndexOf(46)));
        }
        for (File file : exfils = directory.listFiles(exfilter3)) {
            crashAndANRIds.add(file.getPath().substring(0, file.getPath().lastIndexOf(46)));
        }
        while (i < length) {
            File file = sessionFiles[i];
            if (numRetained <= maxAllowed) {
                return numRetained;
            }
            if (crashAndANRIds.contains(file.getPath().substring(0, file.getPath().lastIndexOf(46)))) {
                ++i;
                continue;
            }
            file.delete();
            --numRetained;
            ++i;
        }
        return numRetained;
    }
}

