/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.os.Process;
import com.ainirobot.base.util.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class CLSUUID {
    private static String _clsId;
    private static final AtomicLong _sequenceNumber;
    private static final Pattern ID_PATTERN;

    public CLSUUID() {
        byte[] bytes = new byte[10];
        this.populateTime(bytes);
        this.populateSequenceNumber(bytes);
        this.populatePID(bytes);
        String timeSeqPid = CommonUtils.hexify(bytes);
        String uuid = this.formatId(UUID.randomUUID().toString());
        _clsId = String.format(Locale.US, "%s-%s-%s-%s", timeSeqPid.substring(0, 12), timeSeqPid.substring(12, 16), timeSeqPid.subSequence(16, 20), uuid.substring(0, 12)).toUpperCase(Locale.US);
    }

    private void populateTime(byte[] bytes) {
        long time = new Date().getTime();
        long tvUsec = time % 1000L;
        byte[] timeBytes = CLSUUID.convertLongToFourByteBuffer(time / 1000L);
        bytes[0] = timeBytes[0];
        bytes[1] = timeBytes[1];
        bytes[2] = timeBytes[2];
        bytes[3] = timeBytes[3];
        byte[] msecsBytes = CLSUUID.convertLongToTwoByteBuffer(tvUsec);
        bytes[4] = msecsBytes[0];
        bytes[5] = msecsBytes[1];
    }

    private void populateSequenceNumber(byte[] bytes) {
        byte[] sequenceBytes = CLSUUID.convertLongToTwoByteBuffer(_sequenceNumber.incrementAndGet());
        bytes[6] = sequenceBytes[0];
        bytes[7] = sequenceBytes[1];
    }

    private void populatePID(byte[] bytes) {
        byte[] pidBytes = CLSUUID.convertLongToTwoByteBuffer(Integer.valueOf(Process.myPid()).shortValue());
        bytes[8] = pidBytes[0];
        bytes[9] = pidBytes[1];
    }

    private static byte[] convertLongToFourByteBuffer(long value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt((int)value);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.position(0);
        return buf.array();
    }

    private static byte[] convertLongToTwoByteBuffer(long value) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)value);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.position(0);
        return buf.array();
    }

    private String formatId(String id) {
        return id == null ? null : ID_PATTERN.matcher(id).replaceAll("").toLowerCase(Locale.US);
    }

    public String toString() {
        return _clsId;
    }

    static {
        _sequenceNumber = new AtomicLong(0L);
        ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
    }
}

