/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.os.Looper;
import com.ainirobot.base.util.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class BackgroundWorker {
    private final ExecutorService executorService;

    public BackgroundWorker(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public <T> T submitAndWait(Callable<T> callable) {
        try {
            if (Looper.getMainLooper() == Looper.myLooper()) {
                return this.executorService.submit(callable).get(4L, TimeUnit.SECONDS);
            }
            return this.executorService.submit(callable).get();
        }
        catch (RejectedExecutionException e) {
            Logger.d("Executor is shut down because we're handling a fatal crash.", new Object[0]);
            return null;
        }
        catch (Exception e2) {
            Logger.e("Report", "Failed to execute task.", e2);
            return null;
        }
    }

    public Future<?> submit(final Runnable runnable) {
        try {
            return this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        Logger.e("Report", "Failed to execute task.", e);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Logger.d("Executor is shut down because we're handling a fatal crash.", new Object[0]);
            return null;
        }
    }

    public <T> Future<T> submit(final Callable<T> callable) {
        try {
            return this.executorService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        return callable.call();
                    }
                    catch (Exception e) {
                        Logger.e("Report", "Failed to execute task.", e);
                        return null;
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Logger.d("Executor is shut down because we're handling a fatal crash.", new Object[0]);
            return null;
        }
    }
}

