/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.util;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActivityUtils {
    private static final boolean DEBUG = false;
    private static WeakReference<Object> sV4FragmentRef = null;
    private static WeakReference<Fragment> sFragmentRef = null;
    private static Boolean sHasSupport = null;
    private static Class<?> classFragment = null;
    private static Class<?> classFragmentActivity = null;
    private static Class<?> classFragmentManager = null;
    private static Method methodIsVisible = null;
    private static Method methodGetSupportFragmentManager = null;
    private static Method methodGetFragments = null;
    private static final StringBuilder stringBuilder = new StringBuilder();
    private static final String SEPRATOR = "-";

    public static List<String> getActivityList(Context context) {
        ArrayList<String> activityList = new ArrayList<String>();
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 1);
            for (ActivityInfo activity : packageInfo.activities) {
                Class<?> aClass = Class.forName(activity.name);
                activityList.add(aClass.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return activityList;
    }

    public static Activity getGlobalActivity() throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
        Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
        activitiesField.setAccessible(true);
        Map activities = (Map)activitiesField.get(activityThread);
        for (Object activityRecord : activities.values()) {
            Class<?> activityRecordClass = activityRecord.getClass();
            Field pausedField = activityRecordClass.getDeclaredField("paused");
            pausedField.setAccessible(true);
            if (pausedField.getBoolean(activityRecord)) continue;
            Field activityField = activityRecordClass.getDeclaredField("activity");
            activityField.setAccessible(true);
            Activity activity = (Activity)activityField.get(activityRecord);
            return activity;
        }
        return null;
    }

    public static String getVisibleFragmentTag(Activity activity) {
        if (ActivityUtils.isSupportV4(activity)) {
            return ActivityUtils.getVisibleFragmentTagSupport(activity);
        }
        return ActivityUtils.getVisibleFragmentTagNonSupport(activity);
    }

    private static boolean isSupportV4(Activity activity) {
        if (sHasSupport == null) {
            try {
                classFragment = Class.forName("android.support.v4.app.Fragment");
                classFragmentActivity = Class.forName("android.support.v4.app.FragmentActivity");
                classFragmentManager = Class.forName("android.support.v4.app.FragmentManager");
                methodIsVisible = classFragment.getMethod("isVisible", new Class[0]);
                methodGetSupportFragmentManager = classFragmentActivity.getMethod("getSupportFragmentManager", new Class[0]);
                methodGetFragments = classFragmentManager.getMethod("getFragments", new Class[0]);
                sHasSupport = true;
            }
            catch (Exception e) {
                sHasSupport = false;
            }
        }
        return sHasSupport != false && classFragmentActivity != null && activity != null && classFragmentActivity.isAssignableFrom(activity.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVisibleFragmentTagNonSupport(Activity activity) {
        try {
            List added;
            Fragment currentFragment;
            Fragment fragment = currentFragment = sFragmentRef == null ? null : (Fragment)sFragmentRef.get();
            if (currentFragment != null && currentFragment.isVisible()) {
                return ActivityUtils.generateTag(activity.getClass().getSimpleName(), currentFragment.getClass().getSimpleName());
            }
            Field sFragmentField = activity.getFragmentManager().getClass().getDeclaredField("mAdded");
            sFragmentField.setAccessible(true);
            List list = added = (List)sFragmentField.get(activity.getFragmentManager());
            synchronized (list) {
                for (Fragment fragment2 : added) {
                    if (fragment2 == null || !fragment2.isVisible()) continue;
                    sFragmentRef = new WeakReference<Fragment>(fragment2);
                    return ActivityUtils.generateTag(activity.getClass().getSimpleName(), fragment2.getClass().getSimpleName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ActivityUtils.generateTag(activity.getClass().getSimpleName(), null);
    }

    private static String getVisibleFragmentTagSupport(Activity activity) {
        try {
            Object currentFragment;
            Object object = currentFragment = sV4FragmentRef == null ? null : (Object)sV4FragmentRef.get();
            if (currentFragment != null && ((Boolean)methodIsVisible.invoke(currentFragment, new Object[0])).booleanValue()) {
                return ActivityUtils.generateTag(activity.getClass().getSimpleName(), currentFragment.getClass().getSimpleName());
            }
            Object fragmentManager = methodGetSupportFragmentManager.invoke((Object)activity, new Object[0]);
            List addedFragments = (List)methodGetFragments.invoke(fragmentManager, new Object[0]);
            for (Object fragment : addedFragments) {
                if (fragment == null || !((Boolean)methodIsVisible.invoke(fragment, new Object[0])).booleanValue()) continue;
                sV4FragmentRef = new WeakReference(fragment);
                return ActivityUtils.generateTag(activity.getClass().getSimpleName(), fragment.getClass().getSimpleName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ActivityUtils.generateTag(activity.getClass().getSimpleName(), null);
    }

    private static String generateTag(String activity, String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return activity;
        }
        stringBuilder.setLength(0);
        return stringBuilder.append(activity).append(SEPRATOR).append(tag).toString();
    }
}

