/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.writer;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.protocol.nano.DataManager;
import com.ainirobot.base.protocol.nano.MessageNano;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.writer.IEventWriter;
import com.ainirobot.base.writer.PublicWriter;
import java.io.FileOutputStream;

public class PerformanceWriter
implements IEventWriter {
    private String mSessionId;
    private String mPerformanceData;
    private int mType;
    private Bundle mExtras;

    public PerformanceWriter(String sessionId, String performanceData, int type, Bundle extras) {
        this.mSessionId = sessionId;
        this.mPerformanceData = performanceData;
        this.mType = type;
        this.mExtras = extras;
    }

    @Override
    public void write(FileOutputStream fileOutputStream) throws Exception {
        Context ctx = ApplicationWrapper.getApplicationContext();
        String appName = this.mExtras == null ? PerformanceWriter.getSafeString(LocalUtils.getAppName(ctx)) : this.mExtras.getString("key_app_name", "");
        String packageName = this.mExtras == null ? PerformanceWriter.getSafeString(LocalUtils.getPackageName(ctx)) : this.mExtras.getString("key_package_name", "");
        String versionName = this.mExtras == null ? PerformanceWriter.getSafeString(String.valueOf(LocalUtils.getVersionCode(ctx))) : this.mExtras.getString("key_app_version", "");
        DataManager.ReportData reportData = PublicWriter.writePublic(this.mSessionId, appName, packageName, versionName, "", this.mPerformanceData, this.mType, 0, "", 0);
        byte[] serialized = MessageNano.toByteArray(reportData);
        fileOutputStream.write(serialized);
    }

    private static String getSafeString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

