/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.writer;

import android.os.Bundle;
import com.ainirobot.base.protocol.nano.DataManager;
import com.ainirobot.base.protocol.nano.MessageNano;
import com.ainirobot.base.writer.IEventWriter;
import com.ainirobot.base.writer.PublicWriter;
import java.io.FileOutputStream;
import org.json.JSONObject;

public class NativeCrashWriter
implements IEventWriter {
    private Thread mThread;
    private String mSessionId;
    private Bundle mExtras;

    public NativeCrashWriter(String sessionId, Thread thread, Bundle extras) {
        this.mThread = thread;
        this.mSessionId = sessionId;
        this.mExtras = extras;
    }

    @Override
    public void write(FileOutputStream fileOutputStream) throws Exception {
        JSONObject jsonObject = new JSONObject();
        int collapse = this.mExtras == null ? 2 : this.mExtras.getInt("key_collapse", 2);
        int sourceType = this.mExtras == null ? 1 : this.mExtras.getInt("key_source_type", 1);
        String source = this.mExtras == null ? "" : this.mExtras.getString("key_source", "");
        long cTime = this.mExtras == null ? System.currentTimeMillis() : this.mExtras.getLong("key_ctime", System.currentTimeMillis());
        String className = this.mExtras == null ? "" : this.mExtras.getString("class_name", "");
        String abi = this.mExtras == null ? "" : this.mExtras.getString("abi", "");
        String native_info = this.mExtras == null ? "" : this.mExtras.getString("native_info", "");
        String thread_info = this.mExtras == null ? "" : this.mExtras.getString("thread_info", "");
        String backtrace = this.mExtras == null ? "" : this.mExtras.getString("backtrace", "");
        jsonObject.put("abi", (Object)abi);
        jsonObject.put("thread_info", (Object)thread_info);
        jsonObject.put("backtrace", (Object)backtrace);
        jsonObject.put("native_info", (Object)native_info);
        String appName = this.mExtras == null ? "" : this.mExtras.getString("key_app_name", "");
        String packageName = this.mExtras == null ? "" : this.mExtras.getString("key_package_name", "");
        String versionName = this.mExtras == null ? "" : this.mExtras.getString("key_app_version", "");
        String cosLogUrl = this.mExtras == null ? "" : this.mExtras.getString("key_cos_log_url", "");
        DataManager.ReportData reportData = PublicWriter.writePublic(this.mSessionId, appName, packageName, versionName, className, jsonObject.toString(), 1, collapse, source, sourceType, cTime, "", cosLogUrl);
        byte[] serialized = MessageNano.toByteArray(reportData);
        fileOutputStream.write(serialized);
    }
}

