/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.writer;

import android.os.Bundle;
import com.ainirobot.base.protocol.nano.DataManager;
import com.ainirobot.base.protocol.nano.MessageNano;
import com.ainirobot.base.upload.data.MiddleOutFallbackStrategy;
import com.ainirobot.base.upload.data.RemoveRepeatsStrategy;
import com.ainirobot.base.upload.data.StackTraceTrimmingStrategy;
import com.ainirobot.base.upload.data.TrimmedThrowableData;
import com.ainirobot.base.writer.IEventWriter;
import com.ainirobot.base.writer.PublicWriter;
import java.io.FileOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

class FatalWriter
implements IEventWriter {
    private Throwable mThrowable;
    private Thread mThread;
    private String mSessionId;
    private Bundle mExtras;
    private StackTraceTrimmingStrategy stackTraceTrimmingStrategy;

    public FatalWriter(String sessionId, Thread thread, Throwable ex, Bundle extras) {
        this.mThread = thread;
        this.mSessionId = sessionId;
        this.mThrowable = ex;
        this.mExtras = extras;
        this.stackTraceTrimmingStrategy = new MiddleOutFallbackStrategy(1024, new RemoveRepeatsStrategy(10));
    }

    @Override
    public void write(FileOutputStream fileOutputStream) throws Exception {
        TrimmedThrowableData trimmedEx = new TrimmedThrowableData(this.mThrowable, this.stackTraceTrimmingStrategy);
        JSONObject jsonObject = this.parseThrowableData(trimmedEx);
        int collapse = this.mExtras == null ? 1 : this.mExtras.getInt("key_collapse", 1);
        int sourceType = this.mExtras == null ? 1 : this.mExtras.getInt("key_source_type", 1);
        String source = this.mExtras == null ? "" : this.mExtras.getString("key_source", "");
        long cTime = this.mExtras == null ? System.currentTimeMillis() : this.mExtras.getLong("key_ctime", System.currentTimeMillis());
        String appName = this.mExtras == null ? "" : this.mExtras.getString("key_app_name", "");
        String packageName = this.mExtras == null ? "" : this.mExtras.getString("key_package_name", "");
        String versionName = this.mExtras == null ? "" : this.mExtras.getString("key_app_version", "");
        String cosLogUrl = this.mExtras == null ? "" : this.mExtras.getString("key_cos_log_url", "");
        DataManager.ReportData reportData = PublicWriter.writePublic(this.mSessionId, appName, packageName, versionName, trimmedEx.className, jsonObject.toString(), 1, collapse, source, sourceType, cTime, "", cosLogUrl);
        byte[] serialized = MessageNano.toByteArray(reportData);
        fileOutputStream.write(serialized);
    }

    private JSONObject parseThrowableData(TrimmedThrowableData trimmedEx) throws Exception {
        StackTraceElement[] exceptionStack = trimmedEx.stacktrace;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("CrashThreadName", (Object)(this.mThread == null ? "unknown" : this.mThread.getName()));
        jsonObject.put("CrashClassName", (Object)trimmedEx.className);
        jsonObject.put("CrashMessage", (Object)trimmedEx.localizedMessage);
        JSONArray jsonArray = new JSONArray();
        for (StackTraceElement element : exceptionStack) {
            JSONObject stackObject = new JSONObject();
            stackObject.put("StackClassName", (Object)element.getClassName());
            stackObject.put("StackMethodName", (Object)element.getMethodName());
            stackObject.put("StackFileName", (Object)element.getFileName());
            stackObject.put("StackLineNumber", element.getLineNumber());
            jsonArray.put((Object)stackObject);
        }
        jsonObject.put("CrashStackMsg", (Object)jsonArray);
        Throwable cause = trimmedEx.throwable.getCause();
        if (cause != null) {
            TrimmedThrowableData trimmedData = new TrimmedThrowableData(cause, this.stackTraceTrimmingStrategy);
            JSONObject causeJsonObject = this.parseThrowableData(trimmedData);
            jsonObject.put("CrashCause", (Object)causeJsonObject);
        }
        return jsonObject;
    }
}

