/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.writer;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.protocol.nano.DataManager;
import com.ainirobot.base.protocol.nano.MessageNano;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.writer.IEventWriter;
import com.ainirobot.base.writer.PublicWriter;
import java.io.FileOutputStream;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class ApiWriter
implements IEventWriter {
    private List<JSONObject> mJsonObjects;
    private String mSessionId;
    private Bundle mExtras;

    public ApiWriter(String sessionId, List<JSONObject> jsonObjects, Bundle extras) {
        this.mJsonObjects = jsonObjects;
        this.mSessionId = sessionId;
        this.mExtras = extras;
    }

    @Override
    public void write(FileOutputStream fileOutputStream) throws Exception {
        if (this.mJsonObjects == null || this.mJsonObjects.isEmpty()) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < this.mJsonObjects.size(); ++i) {
            jsonArray.put(i, (Object)this.mJsonObjects.get(i));
        }
        Context ctx = ApplicationWrapper.getApplicationContext();
        String appName = this.mExtras == null ? ApiWriter.getSafeString(LocalUtils.getAppName(ctx)) : this.mExtras.getString("key_app_name", "");
        String packageName = this.mExtras == null ? ApiWriter.getSafeString(LocalUtils.getPackageName(ctx)) : this.mExtras.getString("key_package_name", "");
        String versionName = this.mExtras == null ? ApiWriter.getSafeString(String.valueOf(LocalUtils.getVersionCode(ctx))) : this.mExtras.getString("key_app_version", "");
        DataManager.ReportData reportData = PublicWriter.writePublic(this.mSessionId, appName, packageName, versionName, null, jsonArray.toString(), 3, 0, "", 0);
        byte[] serialized = MessageNano.toByteArray(reportData);
        fileOutputStream.write(serialized);
    }

    private static String getSafeString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

