/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.writer;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.protocol.nano.DataManager;
import com.ainirobot.base.protocol.nano.MessageNano;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.writer.IEventWriter;
import com.ainirobot.base.writer.PublicWriter;
import java.io.File;
import java.io.FileOutputStream;

class AnrWriter
implements IEventWriter {
    private String mSessionId;
    private String mPath;
    private String mCosAnrUrl;
    private String mReason;
    private Context mContext;
    private Bundle mExtras;

    public AnrWriter(String sessionId, String path, String cosAnrUrl, String reason, Context context, Bundle extras) {
        this.mSessionId = sessionId;
        this.mPath = path;
        this.mCosAnrUrl = cosAnrUrl;
        this.mReason = reason;
        this.mContext = context;
        this.mExtras = extras;
    }

    @Override
    public void write(FileOutputStream fileOutputStream) throws Exception {
        File anrFile = new File(this.mPath);
        File tempFile = new File(this.mContext.getFilesDir(), this.mSessionId + ".anr_temp");
        File dstFile = new File(this.mContext.getFilesDir(), this.mSessionId + ".anr");
        boolean result = FileUtils.copyFile(anrFile, tempFile);
        if (result) {
            boolean success = FileUtils.renameTempFile(tempFile, dstFile);
            Logger.d("AnrWriter", "write anr file: " + success);
            if (success) {
                String appName = this.mExtras == null ? "" : this.mExtras.getString("key_app_name", "");
                String packageName = this.mExtras == null ? "" : this.mExtras.getString("key_package_name", "");
                String versionName = this.mExtras == null ? "" : this.mExtras.getString("key_app_version", "");
                long cTime = this.mExtras == null ? System.currentTimeMillis() : this.mExtras.getLong("key_ctime", System.currentTimeMillis());
                String cosLogUrl = this.mExtras == null ? "" : this.mExtras.getString("key_cos_log_url", "");
                DataManager.ReportData reportData = PublicWriter.writePublic(this.mSessionId, appName, packageName, versionName, "", this.mReason, 2, 1, "", 0, cTime, this.mCosAnrUrl, cosLogUrl);
                byte[] serialized = MessageNano.toByteArray(reportData);
                fileOutputStream.write(serialized);
                anrFile.delete();
            }
        }
    }
}

