/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.report;

import com.ainirobot.base.network.HttpMethod;
import com.ainirobot.base.network.HttpRequest;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.report.AbstractSpiCall;
import com.ainirobot.base.upload.report.SettingsRequest;
import com.ainirobot.base.util.CommonUtils;
import com.ainirobot.base.util.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateAppSpiCall
extends AbstractSpiCall {
    public UpdateAppSpiCall(String url, HttpRequestFactory requestFactory) {
        super(url, requestFactory, HttpMethod.POST);
    }

    public JSONObject invoke(SettingsRequest requestData) {
        JSONObject toReturn = null;
        HttpRequest httpRequest = null;
        try {
            JSONObject queryParams = this.getQueryParamsFor(requestData);
            httpRequest = this.applyHeadersTo(this.getHttpRequest());
            httpRequest = this.applyMultipartDataTo(httpRequest, queryParams);
            toReturn = this.handleResponse(httpRequest);
            Logger.d(toReturn.toString(), new Object[0]);
        }
        catch (Exception e) {
            toReturn = null;
        }
        return toReturn;
    }

    private HttpRequest applyHeadersTo(HttpRequest request) {
        this.applyNonNullHeader(request, "Accept", "application/json");
        return request;
    }

    private void applyNonNullHeader(HttpRequest request, String key, String value) {
        if (value != null) {
            request.header(key, value);
        }
    }

    private JSONObject getQueryParamsFor(SettingsRequest requestData) {
        JSONObject queryParams = new JSONObject();
        try {
            queryParams.put("corp_id", (Object)requestData.corp_id);
            queryParams.put("app_package", (Object)requestData.app_package);
            queryParams.put("app_version", (Object)requestData.app_version);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            String key = "d26a53750bc40b38b65a";
            SecretKeySpec sk = new SecretKeySpec(key.getBytes(), mac.getAlgorithm());
            mac.init(sk);
            byte[] result = mac.doFinal((requestData.corp_id + requestData.app_package + requestData.app_version).getBytes());
            queryParams.put("secret", (Object)CommonUtils.hexify(result));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.d(queryParams.toString(), new Object[0]);
        return queryParams;
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, JSONObject queryParams) {
        request.send(queryParams.toString());
        return request;
    }

    private JSONObject handleResponse(HttpRequest httpRequest) {
        JSONObject toReturn;
        int statusCode = httpRequest.code();
        if (this.requestWasSuccessful(statusCode)) {
            toReturn = this.getJsonObjectFrom(httpRequest.body());
        } else {
            Logger.d("Failed to retrieve settings from " + this.getUrl(), new Object[0]);
            toReturn = null;
        }
        return toReturn;
    }

    private boolean requestWasSuccessful(int httpStatusCode) {
        return httpStatusCode == 200 || httpStatusCode == 201 || httpStatusCode == 202 || httpStatusCode == 203;
    }

    private JSONObject getJsonObjectFrom(String httpRequestBody) {
        try {
            return new JSONObject(httpRequestBody);
        }
        catch (Exception var3) {
            Logger.d("Failed to parse settings JSON from " + this.getUrl(), var3);
            Logger.d("Settings response " + httpRequestBody, new Object[0]);
            return null;
        }
    }
}

