/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.handler;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.upload.handler.AHandler;
import com.ainirobot.base.upload.writer.EventWriterFactory;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.Callable;

public class PerformanceHandler
extends AHandler {
    public PerformanceHandler(Context context, BackgroundWorker backgroundWorker, File filesDir, HttpRequestFactory httpRequestFactory, CrashlyticsController controller) {
        super(context, backgroundWorker, filesDir, httpRequestFactory, controller);
    }

    @Override
    public boolean acceptFile(String filename) {
        return filename.endsWith(".performance");
    }

    @Override
    public boolean acceptCacheFile(String filename) {
        return filename.endsWith(".performance_cache");
    }

    @Override
    protected int maxSessionCount() {
        return 2000;
    }

    public void handle(final String performanceData, final int type, final boolean forceReport, final Bundle extras) {
        this.mBackgroundWorker.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                CrashlyticsController crashlyticsController = PerformanceHandler.this.mController;
                synchronized (crashlyticsController) {
                    PerformanceHandler.this.doOpenSession();
                    PerformanceHandler.this.writePerformanceData(performanceData, type, extras);
                    if (forceReport) {
                        PerformanceHandler.this.sendSessionReport();
                    }
                    PerformanceHandler.this.mController.submitAllReports(0.0f);
                }
                return null;
            }
        });
    }

    private void writePerformanceData(final String performanceData, final int type, final Bundle extras) {
        try {
            final String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId == null) {
                Logger.w("Report", "Tried to write a performance data while no session was open.", null);
                return;
            }
            String tag = ".performance_temp";
            this.writeFile(currentSessionId, type, tag, new AHandler.FileOutputStreamWriteAction(){

                @Override
                public void writeTo(FileOutputStream fileOutputStream) throws Exception {
                    EventWriterFactory.createPerformanceWriter(currentSessionId, performanceData, type, extras).write(fileOutputStream);
                }
            });
            File tempCrashFile = new File(this.mFilesDir, this.getFileName(currentSessionId, type, tag));
            File dstCrashFile = new File(this.mFilesDir, this.getFileName(currentSessionId, type, ".performance"));
            boolean success = FileUtils.renameTempFile(tempCrashFile, dstCrashFile);
            Logger.d("rename temp file is " + success, new Object[0]);
        }
        catch (Exception e) {
            Logger.e("Report", "An error occurred in the fatal exception logger", e);
        }
    }
}

