/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.handler;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.upload.handler.AHandler;
import com.ainirobot.base.upload.writer.EventWriterFactory;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.Callable;

public class NativeCrashHandler
extends AHandler {
    @Override
    public boolean acceptFile(String filename) {
        return filename.length() == 35 + ".native".length() && filename.endsWith(".native");
    }

    @Override
    public boolean acceptCacheFile(String filename) {
        return filename.length() == 35 + ".native_cache".length() && filename.endsWith(".native_cache");
    }

    @Override
    protected int maxSessionCount() {
        return 20;
    }

    public NativeCrashHandler(Context context, BackgroundWorker backgroundWorker, File filesDir, HttpRequestFactory httpRequestFactory, CrashlyticsController controller) {
        super(context, backgroundWorker, filesDir, httpRequestFactory, controller);
    }

    public void handle(final Thread thread, final Bundle extras) {
        Logger.d("Crashlytics is handling uncaught native exception\"\" from thread " + (thread == null ? "unknown" : thread.getName()), new Object[0]);
        this.mBackgroundWorker.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                CrashlyticsController crashlyticsController = NativeCrashHandler.this.mController;
                synchronized (crashlyticsController) {
                    NativeCrashHandler.this.doOpenSession();
                    if (extras != null) {
                        NativeCrashHandler.this.writeNativeCrash(thread, extras);
                    }
                    NativeCrashHandler.this.sendSessionReport();
                    NativeCrashHandler.this.mController.submitAllReports(0.0f);
                }
                return null;
            }
        });
    }

    private void writeNativeCrash(final Thread thread, final Bundle extras) {
        try {
            String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId == null) {
                Logger.w("Tried to write a native crash while no session was open.", new Object[]{null});
                return;
            }
            String tag = ".native_crash_temp";
            this.writeFile(currentSessionId, tag, new AHandler.FileOutputStreamWriteAction(){

                @Override
                public void writeTo(FileOutputStream fileOutputStream) throws Exception {
                    EventWriterFactory.createNativeCrashWriter(NativeCrashHandler.this.sessionId, thread, extras).write(fileOutputStream);
                }
            });
            File tempCrashFile = new File(this.mFilesDir, this.sessionId + tag);
            File dstCrashFile = new File(this.mFilesDir, this.sessionId + ".native");
            boolean success = FileUtils.renameTempFile(tempCrashFile, dstCrashFile);
            Logger.d("CrashlyticsCore", "rename temp file is " + success);
        }
        catch (Exception e) {
            Logger.e("CrashlyticsCore", "An error occurred in the native crash logger", e);
        }
    }
}

