/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.handler;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.upload.handler.AHandler;
import com.ainirobot.base.upload.writer.EventWriterFactory;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.Callable;

public class JavaCrashHandler
extends AHandler {
    public JavaCrashHandler(Context context, BackgroundWorker backgroundWorker, File filesDir, HttpRequestFactory httpRequestFactory, CrashlyticsController controller) {
        super(context, backgroundWorker, filesDir, httpRequestFactory, controller);
    }

    public void handle(final Thread thread, final Throwable ex, final Bundle extras) {
        this.mBackgroundWorker.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                CrashlyticsController crashlyticsController = JavaCrashHandler.this.mController;
                synchronized (crashlyticsController) {
                    Logger.d("Crashlytics is handling uncaught exception\"" + ex + "\" from thread " + (thread == null ? "unknown" : thread.getName()), new Object[0]);
                    JavaCrashHandler.this.doOpenSession();
                    if (ex != null) {
                        JavaCrashHandler.this.writeFatal(thread, ex, extras);
                    }
                    JavaCrashHandler.this.sendSessionReport();
                    JavaCrashHandler.this.mController.submitAllReports(0.0f);
                }
                return null;
            }
        });
    }

    private void writeFatal(final Thread thread, final Throwable ex, final Bundle extras) {
        try {
            String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId == null) {
                Logger.e("Tried to write a fatal exception while no session was open.", new Object[]{null});
                return;
            }
            String tag = ".crash_temp";
            this.writeFile(currentSessionId, tag, new AHandler.FileOutputStreamWriteAction(){

                @Override
                public void writeTo(FileOutputStream fileOutputStream) throws Exception {
                    EventWriterFactory.createFatalWriter(JavaCrashHandler.this.sessionId, thread, ex, extras).write(fileOutputStream);
                }
            });
            File tempCrashFile = new File(this.mFilesDir, this.sessionId + tag);
            File dstCrashFile = new File(this.mFilesDir, this.sessionId + ".crash");
            boolean success = FileUtils.renameTempFile(tempCrashFile, dstCrashFile);
            Logger.d("CrashlyticsCore", "rename temp file is " + success);
        }
        catch (Exception e) {
            Logger.e("CrashlyticsCore", "An error occurred in the fatal exception logger", e);
        }
    }

    @Override
    public boolean acceptFile(String filename) {
        return filename.length() == 35 + ".crash".length() && filename.endsWith(".crash");
    }

    @Override
    public boolean acceptCacheFile(String filename) {
        return filename.length() == 35 + ".crash_cache".length() && filename.endsWith(".crash_cache");
    }

    @Override
    public int maxSessionCount() {
        return 20;
    }
}

